package com.floreantpos.model.dao;

import java.io.Serializable;
import java.util.List;

import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.model.OnlineStore;

public class OnlineStoreDAO extends BaseOnlineStoreDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public OnlineStoreDAO() {
	}

	@Override
	protected Serializable save(Object obj, Session s) {
		updateTime((OnlineStore) obj);
		return super.save(obj, s);
	}

	@Override
	protected void update(Object obj, Session s) {
		updateTime((OnlineStore) obj);
		super.update(obj, s);
	}

	@Override
	protected void saveOrUpdate(Object obj, Session s) {
		updateTime((OnlineStore) obj);
		super.saveOrUpdate(obj, s);
	}

	public OnlineStore findBy(String storeId, String outletId) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(getReferenceClass());
			criteria.add(Restrictions.eq(OnlineStore.PROP_STORE_ID, storeId));
			criteria.add(Restrictions.eq(OnlineStore.PROP_OUTLET_ID, outletId));
			criteria.setMaxResults(1);
			return (OnlineStore) criteria.uniqueResult();
		}
	}

	public List<OnlineStore> findBy(String storeId) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(getReferenceClass());
			criteria.add(Restrictions.eq(OnlineStore.PROP_STORE_ID, storeId));
			return criteria.list();
		}
	}

	public Boolean isStoreOnLiveMode(String storeId) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(getReferenceClass());
			criteria.setProjection(Projections.rowCount());
			criteria.add(Restrictions.eq(OnlineStore.PROP_STORE_ID, storeId));
			criteria.add(Restrictions.eq(OnlineStore.PROP_LIVE, true));
			Number number = (Number) criteria.uniqueResult();
			return number != null && number.intValue() > 0;
		}
	}
}