package com.orocube.rest.service.mqtt;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttMessage;

import com.floreantpos.PosLog;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.util.POSUtil;
import com.orocube.common.util.TerminalUtil;
import com.orocube.rest.service.ServiceUtils;

public class OroMqttMessagePublisher {

	//	public static void publishDrawerClosed(CashDrawer cashDrawer) {
	//		/*List<CashDrawer> drawers = new ArrayList<>();
	//		drawers.add(cashDrawer);
	//		pulishDrawers(drawers);*/
	//	}
	//
	//	public static void publishDrawerOpened(CashDrawer cashDrawer) {
	//		/*List<CashDrawer> drawers = new ArrayList<>();
	//		drawers.add(cashDrawer);
	//		pulishDrawers(drawers);*/
	//	}

	//	public static void pulishDrawers(List<CashDrawer> drawers) {
	//		try {
	//			List<String> ids = new ArrayList<>();
	//			if (drawers != null && drawers.size() > 0) {
	//				for (CashDrawer cashDrawer : drawers) {
	//					ids.add(cashDrawer.getId());
	//				}
	//				String jsonResponse = convertCashDrawersToJson(drawers);
	//				OroMqttClient.getInstance().publishOnThread(MqttTopics.PUBLIC, jsonResponse);
	//			}
	//		} catch (Exception e2) {
	//			PosLog.error(OroMqttMessagePublisher.class, e2);
	//		}
	//	}

	//	public static String convertCashDrawersToJson(List<CashDrawer> cashDrawers) throws Exception {
	//		PosResponse reponse = new PosResponse();
	//		reponse.setResponseCode(1);
	//		reponse.setRequest(Messages.getString("OroMqttMessagePublisher.0")); //$NON-NLS-1$
	//		reponse.setMsg((cashDrawers.size() == 1 ? Messages.getString("OroMqttMessagePublisher.1") //$NON-NLS-1$
	//				: cashDrawers.size() + Messages.getString("OroMqttMessagePublisher.2")) + Messages.getString("OroMqttMessagePublisher.3")); //$NON-NLS-1$ //$NON-NLS-2$
	//		reponse.setDeviceId(TerminalUtil.getSystemUID());
	//		reponse.setData(cashDrawers);
	//		reponse.setOutletId(Application.getInstance().getCurrentTerminalOutletId());
	//		return ServiceUtils.getAsJsonString(reponse);
	//	}

	public static void publishTicket(final String ticketId) {
		//		if (StringUtils.isEmpty(ticketId)) {
		//			return;
		//		}
		//		AsyncAction.execute(new Runnable() {
		//			@Override
		//			public void run() {
		//				try {
		//					List<Ticket> tickets = new ArrayList<>();
		//					Ticket ticket = TicketDAO.getInstance().loadFullTicket(ticketId);
		//					tickets.add(ticket);
		//					publishTickets(tickets);
		//				} catch (Exception e) {
		//					throw new RuntimeException(e);
		//				}
		//			}
		//		});
	}

	public static void publishTickets(List<Ticket> tickets) throws Exception {
		//		List<String> ticketIds = new ArrayList<String>();
		//		List<String> transactionIds = new ArrayList<String>();
		//
		//		Set<PosTransaction> transactionList = null;
		//		if (tickets != null && tickets.size() > 0) {
		//			for (Ticket ticket : tickets) {
		//				transactionList = ticket.getTransactions();
		//				if (transactionList != null) {
		//					for (PosTransaction posTransaction : transactionList) {
		//						transactionIds.add(posTransaction.getId());
		//					}
		//				}
		//				ticket.setProperties(null);
		//				ticket.setDiscounts(null);
		//				ticket.setTransactions(null);
		//				ticketIds.add(ticket.getId());
		//			}
		//			String jsonResponse = ServiceUtils.createPosResponseAsString(tickets, true);
		//			OroMqttClient.getInstance().publishData(MqttTopics.PUBLIC, jsonResponse, true);
		//		}
	}

	public static void publishTicket(Ticket t, String currentSchema) {
		try {
			List<Ticket> tickets = new ArrayList<>();
			tickets.add(t);

			for (Ticket ticket : tickets) {
				ticket.setProperties(null);
				//TODO:Discount should not be null
				ticket.setDiscounts(null);
				String orderTypeId = ticket.getOrderTypeId();
				if (StringUtils.isNotBlank(orderTypeId)) {
					ticket.setOrderType(new OrderType(orderTypeId, ticket.getOrderTypeId()));
				}

				for (TicketItem ticketItem : ticket.getTicketItems()) {
					String menuItemId = ticketItem.getMenuItemId();
					ticketItem.setMenuItem(null);
					ticketItem.setMenuItemId(menuItemId);
				}
			}
			publishDataByOutlet(currentSchema, t.getOutletId(),
					ServiceUtils.createPosResponseAsString(tickets, TerminalUtil.getSystemUID() + "-client", true, MqttSender.ONLINE_ORDER)); //$NON-NLS-1$
		} catch (Exception e) {
			PosLog.error(OroMqttMessagePublisher.class, e.getMessage());
		}
	}

	private static void publishDataByOutlet(String currentSchema, String outletId, String jsonResponse) throws Exception {
		MqttMessage message = new MqttMessage();
		message.setPayload(POSUtil.compress(jsonResponse));
		String storeUuid = currentSchema + "/"; //$NON-NLS-1$
		MqttClient mqttClient = OroMqttClient.getInstance().getMqttClient();
		PosLog.debug(OroMqttMessagePublisher.class, "Publishing to " + storeUuid + outletId + "/" + MqttTopics.PUBLIC); //$NON-NLS-1$ //$NON-NLS-2$
		mqttClient.publish(storeUuid + outletId + "/" + MqttTopics.PUBLIC, message); //$NON-NLS-1$
	}
}
