package com.floreantpos.model;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.model.base.BaseOnlineStore;
import com.google.gson.Gson;
import com.google.gson.JsonObject;

public class OnlineStore extends BaseOnlineStore implements TimedModel, PropertyContainer, AddressContainer {
	private static final long serialVersionUID = 1L;

	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;
	private transient JsonObject propertiesContainer;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public OnlineStore() {
	}

	/**
	 * Constructor for primary key
	 */
	public OnlineStore(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	@Override
	public String getProperties() {
		if (propertiesContainer != null) {
			return propertiesContainer.toString();
		}

		String properties = super.getProperties();
		if (StringUtils.isEmpty(properties)) {
			return null;
		}
		try {
			propertiesContainer = new Gson().fromJson(properties, com.google.gson.JsonObject.class);
		} catch (Exception e) {
		}
		return properties;
	}

	@Override
	public void setProperties(String properties) {
		super.setProperties(properties);
		try {
			propertiesContainer = new Gson().fromJson(properties, com.google.gson.JsonObject.class);
		} catch (Exception e) {
		}
	}

	@Override
	public JsonObject getPropertyStore() {
		if (propertiesContainer == null) {
			propertiesContainer = new JsonObject();
		}
		return propertiesContainer;
	}

	@Override
	public java.lang.String getFriendlyUrl() {
		if (StringUtils.isBlank(super.getFriendlyUrl())) {
			return getStoreId() + "___" + getOutletId(); //$NON-NLS-1$
		}
		return super.getFriendlyUrl();
	}

	public boolean isNotFriendlyUrl() {
		if (StringUtils.isBlank(super.getStoreId()) || StringUtils.isBlank(super.getOutletId())) {
			return true;
		}
		return getFriendlyUrl().equals(getStoreId() + "___" + getOutletId()); //$NON-NLS-1$
	}

	public String buildFriendlyUrl() {
		String friendlyUrl = ""; //$NON-NLS-1$
		if (StringUtils.isNotBlank(getStoreName())) {
			friendlyUrl = getStoreName().toLowerCase();
		}
		if (StringUtils.isNotBlank(getCity())) {
			friendlyUrl += "_" + getCity().toLowerCase(); //$NON-NLS-1$
		}
		if (StringUtils.isNotBlank(getZipCode())) {
			friendlyUrl += "_" + getZipCode(); //$NON-NLS-1$
		}
		friendlyUrl = friendlyUrl.replaceAll("\\W", ""); //$NON-NLS-1$ //$NON-NLS-2$
		return friendlyUrl;
	}
}