package com.floreantpos.model;

import javax.xml.bind.annotation.XmlTransient;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BasePriceTableItem;
import com.floreantpos.model.dao.MenuItemDAO;

@JsonIgnoreProperties(ignoreUnknown = true, value = { "menuItem", "itemName" })
public class PriceTableItem extends BasePriceTableItem {
	private static final long serialVersionUID = 1L;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public PriceTableItem() {
	}

	/**
	 * Constructor for primary key
	 */
	public PriceTableItem(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/
	private MenuItem menuItem;
	private String itemName;
	private double regularPrice;

	@XmlTransient
	public MenuItem getMenuItem() {
		if (menuItem == null) {
			menuItem = MenuItemDAO.getInstance().get(getMenuItemId());
		}
		return menuItem;
	}

	public void setMenuItem(MenuItem menuItem) {
		this.menuItem = menuItem;
	}

	@XmlTransient
	public String getItemName() {
		return itemName;
	}

	public void setItemName(String itemName) {
		this.itemName = itemName;
	}

	public double getRegularPrice() {
		return getMenuItem().getPrice();
	}

	public void setRegularPrice(double regularPrice) {
		this.regularPrice = regularPrice;
	}
}