package com.floreantpos.model.dao;

import java.util.Iterator;
import java.util.List;

import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;

import com.floreantpos.model.MenuItemInventoryStatus;

public class MenuItemInventoryStatusDAO extends BaseMenuItemInventoryStatusDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public MenuItemInventoryStatusDAO() {
	}

	@Override
	public String save(MenuItemInventoryStatus menuItemInventoryStatus) throws HibernateException {
		menuItemInventoryStatus.setLastUpdateTime(StoreDAO.getServerTimestamp());
		return super.save(menuItemInventoryStatus);
	}

	@Override
	public String save(MenuItemInventoryStatus menuItemInventoryStatus, Session s) throws HibernateException {
		menuItemInventoryStatus.setLastUpdateTime(StoreDAO.getServerTimestamp());
		updateTime(menuItemInventoryStatus);
		return super.save(menuItemInventoryStatus, s);
	}

	@Override
	public void saveOrUpdate(MenuItemInventoryStatus menuItemInventoryStatus) throws HibernateException {
		menuItemInventoryStatus.setLastUpdateTime(StoreDAO.getServerTimestamp());
		super.saveOrUpdate(menuItemInventoryStatus);
	}

	@Override
	public void saveOrUpdate(MenuItemInventoryStatus menuItemInventoryStatus, Session s) throws HibernateException {
		menuItemInventoryStatus.setLastUpdateTime(StoreDAO.getServerTimestamp());
		updateTime(menuItemInventoryStatus);
		super.saveOrUpdate(menuItemInventoryStatus, s);
	}

	@Override
	public void update(MenuItemInventoryStatus menuItemInventoryStatus) throws HibernateException {
		menuItemInventoryStatus.setLastUpdateTime(StoreDAO.getServerTimestamp());
		super.update(menuItemInventoryStatus);
	}

	@Override
	public void update(MenuItemInventoryStatus menuItemInventoryStatus, Session s) throws HibernateException {
		menuItemInventoryStatus.setLastUpdateTime(StoreDAO.getServerTimestamp());
		updateTime(menuItemInventoryStatus);
		super.update(menuItemInventoryStatus, s);
	}

	public void saveOrUpdateMenuItemInventoryStatus(List<MenuItemInventoryStatus> dataList, boolean updateLastUpdateTime, boolean updateSyncTime)
			throws Exception {

		if (dataList == null)
			return;

		Transaction tx = null;
		try (Session session = createNewSession()) {
			tx = session.beginTransaction();

			for (Iterator<MenuItemInventoryStatus> iterator = dataList.iterator(); iterator.hasNext();) {
				MenuItemInventoryStatus item = (MenuItemInventoryStatus) iterator.next();
				MenuItemInventoryStatus existingItem = get(item.getId());
				if (existingItem != null) {
					long version = existingItem.getVersion();
					PropertyUtils.copyProperties(existingItem, item);
					existingItem.setVersion(version);
					existingItem.setUpdateLastUpdateTime(updateLastUpdateTime);
					existingItem.setUpdateSyncTime(updateSyncTime);
					update(existingItem, session);
				}
				else {
					item.setUpdateLastUpdateTime(updateLastUpdateTime);
					item.setUpdateSyncTime(updateSyncTime);
					save(item, session);
				}
			}
			tx.commit();
		} catch (Exception e) {
			tx.rollback();
			throw e;
		}
	}
}