package com.floreantpos.model.dao;

import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.model.SiiopaCustomer;

public class SiiopaCustomerDAO extends BaseSiiopaCustomerDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public SiiopaCustomerDAO() {
	}

	public SiiopaCustomer findByPhoneOrEmail(String mobileNo, String email) {
		Session session = null;
		try {
			session = createNewSession();
			Criteria criteria = session.createCriteria(getReferenceClass());
			addDeletedFilter(criteria);
			if (StringUtils.isEmpty(mobileNo)) {
				criteria.add(Restrictions.eq(SiiopaCustomer.PROP_EMAIL, email));
			}
			else {
				criteria.add(Restrictions.or(Restrictions.eq(SiiopaCustomer.PROP_MOBILE_NO, mobileNo), Restrictions.eq(SiiopaCustomer.PROP_EMAIL, email)));
			}
			List list = criteria.list();
			if (list.size() > 0) {
				return (SiiopaCustomer) list.get(0);
			}
			return null;
		} finally {
			if (session != null) {
				closeSession(session);
			}
		}
	}

}