package com.floreantpos.model.dao;

import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.model.TempTicket;

public class TempTicketDAO extends BaseTempTicketDAO {

	private final static TempTicketDAO instance = new TempTicketDAO();

	public static TempTicketDAO getInstance() {
		return instance;
	}

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public TempTicketDAO() {
	}

	@Override
	public synchronized void saveOrUpdate(TempTicket tempTicket) {

		Session session = null;
		Transaction tx = null;
		try {
			session = createNewSession();
			tx = session.beginTransaction();

			saveOrUpdate(tempTicket, session);

			tx.commit();

		} catch (Exception e) {
			if (tx != null) {
				tx.rollback();
			}
			throw e;
		} finally {
			closeSession(session);
		}
	}

	/**
	 * @param customerId
	 * 
	 * 
	 * @return
	 */
	public List<TempTicket> findTempTicketsByCustomer(String customerId) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(getReferenceClass());

			if (StringUtils.isNotBlank(customerId)) {
				criteria.add(Restrictions.eq(TempTicket.PROP_CUSTOMER_ID, customerId));
			}

			return criteria.list();
		}
	}

}