package com.floreantpos.report.model;

import com.floreantpos.Messages;
import com.floreantpos.report.EndOfDayReportData;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.util.NumberUtil;

public class EndOfDaySummaryReportModel extends ListTableModel {
	public EndOfDaySummaryReportModel() {
		super(new String[] { "empName", "customerName", "ticketId", "ticketAmt", "serviceCharge", "tips", "tax", "total", "memberCharge", "creditCard", //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$//$NON-NLS-5$//$NON-NLS-6$//$NON-NLS-7$//$NON-NLS-8$//$NON-NLS-9$//$NON-NLS-10$
				"cashPymt", "othersPayment", "discount", "refund" }); //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-11$

	}

	public Object getValueAt(int rowIndex, int columnIndex) {
		EndOfDayReportData data = (EndOfDayReportData) rows.get(rowIndex);
		switch (columnIndex) {
			case 0:
				return data.getEmployeeId() + " - " + data.getEmployeeName();//$NON-NLS-1$

			case 1:
				String customerName = data.getCustomerName();
				String memberId = data.getMemberId() == null ? "" : data.getMemberId() + " - ";//$NON-NLS-1$
				return customerName == null ? Messages.getString("GUEST") : memberId + customerName;//$NON-NLS-1$

			case 2:
				return data.getTicketId();

			case 3:
				return NumberUtil.getCurrencyFormatWithoutSymbol(data.getNetAmount());
			case 4:
				return NumberUtil.getCurrencyFormatWithoutSymbol(data.getServiceCharge());

			case 5:
				return NumberUtil.getCurrencyFormatWithoutSymbol(data.getGratuityAmount());

			case 6:
				return NumberUtil.getCurrencyFormatWithoutSymbol(data.getTaxAmount());

			case 7:
				return NumberUtil.getCurrencyFormatWithoutSymbol(data.getTotalTicketAmount() + data.getGratuityAmount());

			case 8:
				return NumberUtil.getCurrencyFormatWithoutSymbol(data.getMemberCharge());

			case 9:
				return NumberUtil.getCurrencyFormatWithoutSymbol(data.getCreditCardPayment());

			case 10:
				return NumberUtil.getCurrencyFormatWithoutSymbol(data.getCashPayment());

			case 11:
				return NumberUtil.getCurrencyFormatWithoutSymbol(data.getOthersPayment());

			case 12:
				return NumberUtil.getCurrencyFormatWithoutSymbol(data.getDiscount());

			case 13:
				return NumberUtil.getCurrencyFormatWithoutSymbol(data.getRefundPaymentCredit());
		}
		return null;
	}

}
