package com.floreantpos.report.model;

import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.Messages;
import com.floreantpos.model.GiftCertificateTransaction;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.ListTableModel;

public class GiftCardTransactionsReportModel extends ListTableModel {
	private String[] columnNames = { "txNumber", "ticketNo", "txTime", "desc", "txAmount", "txGiftCardNumber" };//$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$//$NON-NLS-5$ //$NON-NLS-6$

	public GiftCardTransactionsReportModel(List rows) {
		setColumnNames(columnNames);
		setRows(rows);
	}

	public Object getValueAt(int rowIndex, int columnIndex) {
		PosTransaction transaction = (PosTransaction) rows.get(rowIndex);

		switch (columnIndex) {
			case 0:
				return transaction.getId();
			case 1:
				if (StringUtils.isNotEmpty(transaction.getTicketId())) {
					return transaction.getTicketId();
				}
				return ""; //$NON-NLS-1$
			case 2:
				if (transaction.getTransactionTime() != null)
					return DateUtil.formatReportDateAsString(transaction.getTransactionTime());
				return ""; //$NON-NLS-1$

			case 3:
				if (transaction instanceof GiftCertificateTransaction)
					return Messages.getString("GiftCardTransactionsReportModel.2"); //$NON-NLS-1$
				else
					return Messages.getString("GiftCardTransactionsReportModel.3"); //$NON-NLS-1$
			case 4:
				if (transaction instanceof GiftCertificateTransaction) {
					return transaction.getAmount() * -1;
				}
				else {
					double giftCardBalanceAmount = transaction.getGiftCertFaceValue();
					if (giftCardBalanceAmount == 0.0) {
						giftCardBalanceAmount = transaction.getAmount()
								- (transaction.getServiceChargeAmount() + transaction.getTaxAmount() + transaction.getTipsAmount());
					}
					return giftCardBalanceAmount;
				}
			case 5:
				return transaction.getGiftCertNumber();

		}
		return null;
	}
}
