package com.floreantpos.util;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

import javax.imageio.ImageIO;

public class ImageUtil {
	public static byte[] convertImageToByteArray(BufferedImage image) throws IOException {
		try (ByteArrayOutputStream baos = new ByteArrayOutputStream()) {
			ImageIO.write(image, "jpg", baos); //$NON-NLS-1$
			baos.flush();
			return baos.toByteArray();
		}
	}

	public static BufferedImage doScaleImageWithRatio(BufferedImage image, boolean reduceSize, int width, int height) throws IOException {
		if (reduceSize) {
			if (width > height) {
				width = width - 100;
				height = (height * width) / width;
			}
			else {
				height = height - 100;
				width = (width * height) / height;
			}
		}
		
		BufferedImage resizedImage = new BufferedImage(width, height, BufferedImage.TYPE_INT_ARGB);

		Graphics2D graphics2D = resizedImage.createGraphics();
		graphics2D.setComposite(AlphaComposite.Src);
		graphics2D.drawImage(image, 0, 0, width, height, null);
		graphics2D.dispose();

		byte[] byteArray = convertImageToByteArray(resizedImage);
		if ((byteArray.length / 1024) > 1000) {
			resizedImage = null;
			byteArray = null;
			return doScaleImageWithRatio(image, true, width, height);
		}
		return resizedImage;
	}
}
