/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.extension;

import java.awt.Component;

import com.floreantpos.extension.stripe.StripeProcessor;
import com.floreantpos.ui.views.payment.CardProcessor;

import net.xeoh.plugins.base.annotations.PluginImplementation;

@PluginImplementation
public class StripeGatewayPlugin extends PaymentGatewayPlugin {
	public static final String ID = String.valueOf("Stripe".hashCode()); //$NON-NLS-1$

	@Override
	public String getProductName() {
		return "Stripe"; //$NON-NLS-1$
	}

	@Override
	public String toString() {
		return getProductName();
	}

	@Override
	public String getId() {
		return ID;
	}

	@Override
	public CardProcessor getProcessor() {
		return new StripeProcessor();
	}

	@Override
	public boolean shouldShowCardInputProcessor() {
		return true;
	}

	@Override
	public boolean hasValidLicense() {
		return true;
	}

	@Override
	public String getProductVersion() {
		return null;
	}

	@Override
	public Component getParent() {
		return null;
	}

	@Override
	public Integer getProductNumericVersion() {
		return null;
	}

	@Override
	public String getUpdateServerURL() {
		return null;
	}

	@Override
	public boolean supportsBatchClose() {
		return false;
	}

	@Override
	public void restartPOS(boolean arg0) {
	}
}
