package com.floreantpos.model;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import javax.swing.ImageIcon;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.PosLog;
import com.floreantpos.model.base.BaseShopTable;
import com.floreantpos.model.dao.SalesAreaDAO;
import com.floreantpos.model.dao.ShopFloorDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.GlobalIdGenerator;
import com.google.gson.Gson;
import com.google.gson.JsonObject;

@XmlRootElement
@JsonIgnoreProperties(ignoreUnknown = true, value = { "typesAsString", "floor", "userName", "image" })
public class ShopTable extends BaseShopTable implements TimedModel, PropertyContainer {
	private static final long serialVersionUID = 1L;
	public static final String PROP_ID = "id"; //$NON-NLS-1$
	public static final String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$

	public final static int TYPE_RECTANGLE = 0;
	public final static int TYPE_ROUNDED_RECTANGLE = 1;
	public final static int TYPE_ROUND = 2;
	public final static int TYPE_POLYGON = 3;
	public final static int TYPE_CUSTOM = 4;

	public final static String RESERVATION_NUMBER = "RES_NO"; //$NON-NLS-1$

	private Date ticketCreateTime;
	private boolean showStatus;
	private boolean reArrange;
	private int guestNumber;
	private String typesAsString;

	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;

	private transient JsonObject propertiesContainer;

	public static final SimpleDateFormat bookingDateFormat = new SimpleDateFormat("yyyy-MMM-dd hh:mm:ss"); //$NON-NLS-1$

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public ShopTable() {
		super();
		setGlobalId(GlobalIdGenerator.generateGlobalId());
	}

	/**
	 * Constructor for primary key
	 */
	public ShopTable(java.lang.Integer id, java.lang.String outletId) {

		super(id, outletId);
	}

	/**
	 * Constructor for required fields
	 */
	public ShopTable(java.lang.Integer id, java.lang.String outletId, java.lang.String globalId) {

		super(id, outletId, globalId);
	}

	/*[CONSTRUCTOR MARKER END]*/

	public ShopTable(ShopFloor floor, String outletId, Integer x, Integer y, Integer id) {
		super();
		setGlobalId(com.floreantpos.util.GlobalIdGenerator.generateGlobalId());
		setOutletId(outletId);
		setCapacity(4);
		setId(id);
		setFloorId(floor.getId());
		setX(x);
		setY(y);
	}

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	public TableStatus getTableStatus() {
		return getShopTableStatus().getTableStatus();
	}

	public void setTableStatus(TableStatus tableStatus) {
		setTableStatusNum(tableStatus.getValue());
	}

	private void setTableStatusNum(int value) {
		ShopTableStatus status = getShopTableStatus();
		status.setTableStatusNum(value);
		setShopTableStatus(status);
	}

	public Integer getTableNumber() {
		return getId();
	}

	@Override
	public String toString() {
		return String.valueOf(getTableNumber());
	}

	private boolean isTemporary;

	public boolean isTemporary() {
		return isTemporary;
	}

	public void setTemporary(boolean isTemporary) {
		this.isTemporary = isTemporary;
	}

	public String getTypesAsString() {
		List<ShopTableType> tableTypes = getTypes();
		String strTableTypes = ""; //$NON-NLS-1$
		if (tableTypes == null || tableTypes.size() == 0) {
			return ""; //$NON-NLS-1$
		}
		boolean getComma = false;
		for (ShopTableType shopTableType : tableTypes) {
			if (getComma) {
				strTableTypes += ", "; //$NON-NLS-1$
			}
			strTableTypes += shopTableType.getName();
			getComma = true;
		}
		return strTableTypes;
	}

	public String getTicketId() {
		ShopTableStatus status = getStatus();
		if (status == null)
			return null;
		List<String> ticketNumbers = status.getListOfTicketNumbers();
		if (ticketNumbers != null && ticketNumbers.size() > 0)
			return ticketNumbers.get(0);
		return null;
	}

	public String getUserId() {
		ShopTableStatus status = getStatus();
		if (status == null)
			return null;
		return status.getUserId();
	}

	public String getUserName() {
		ShopTableStatus status = getStatus();
		if (status == null)
			return null;
		return status.getUserName();
	}

	public String getTicketShortId() {
		ShopTableStatus status = getStatus();
		if (status == null)
			return null;
		return status.getTokenNo();
	}

	@Override
	public ShopTableStatus getShopTableStatus() {
		ShopTableStatus shopTableStatus = super.getShopTableStatus();
		if (shopTableStatus != null) {
			return shopTableStatus;
		}

		shopTableStatus = new ShopTableStatus(getId(), getOutletId());
		shopTableStatus.setTableStatus(TableStatus.Available);
		return shopTableStatus;
	}

	@Deprecated
	public ShopTableStatus getStatus() {
		return getShopTableStatus();
	}

	//	public ShopTableStatus saveAndGetNewStatus() {
	//		ShopTableStatus shopTableStatus = new ShopTableStatus();
	//		Integer tableId = getId();
	//		shopTableStatus.setId(tableId);
	//		shopTableStatus.setTableStatus(TableStatus.Available);
	////		if (tableId != null)
	////			ShopTableStatusDAO.getInstance().save(shopTableStatus);
	////		setShopTableStatus(shopTableStatus);
	//		return shopTableStatus;
	//	}

	public Date getTicketCreateTime() {
		return ticketCreateTime;
	}

	public void setTicketCreateTime(Date ticketCreateTime) {
		this.ticketCreateTime = ticketCreateTime;
	}

	public boolean isShowStatus() {
		return showStatus;
	}

	public void setShowStatus(boolean showStatus) {
		this.showStatus = showStatus;
	}

	public boolean isReArrange() {
		return reArrange;
	}

	public void setReArrange(boolean reArrange) {
		this.reArrange = reArrange;
	}

	public int getGuestNumber() {
		return guestNumber;
	}

	public void setGuestNumber(int guestNumber) {
		this.guestNumber = guestNumber;
	}

	@XmlTransient
	public ShopFloor getFloor() {
		if (StringUtils.isNotEmpty(getFloorId())) {
			return ShopFloorDAO.getInstance().get(getFloorId(), getOutletId());
		}
		return null;
	}

	public void setFloor(ShopFloor shopFloor) {
		String shopFloorId = null;
		if (shopFloor != null) {
			shopFloorId = shopFloor.getId();
		}
		super.setFloorId(shopFloorId);
	}

	@XmlTransient
	public SalesArea getSalesArea() {
		if (StringUtils.isNotEmpty(getSalesAreaId())) {
			return SalesAreaDAO.getInstance().get(getSalesAreaId());
		}
		return null;
	}

	public void setSalesArea(SalesArea salesArea) {
		String salesAreaId = null;
		if (salesArea != null) {
			salesAreaId = salesArea.getId();
		}
		super.setSalesAreaId(salesAreaId);
	}

	@Override
	public String getProperties() {
		if (propertiesContainer != null) {
			return propertiesContainer.toString();
		}

		String properties = super.getProperties();
		if (StringUtils.isEmpty(properties)) {
			return null;
		}

		propertiesContainer = new Gson().fromJson(properties, JsonObject.class);
		return properties;
	}

	@Override
	public void setProperties(String properties) {
		super.setProperties(properties);
		propertiesContainer = new Gson().fromJson(properties, JsonObject.class);
	}

	public void setTypesAsString(String typesAsString) {
		this.typesAsString = typesAsString;
	}

	public double getAngle() {
		String angleText = getProperty("angle"); //$NON-NLS-1$
		if (StringUtils.isNotEmpty(angleText)) {
			try {
				return Double.parseDouble(angleText);
			} catch (Exception e) {
				PosLog.error(getClass(), e);
			}
		}
		return 0;
	}

	public void setAngle(double angle) {
		addProperty("angle", String.valueOf(angle));//$NON-NLS-1$
	}

	public void setImageResource(ImageResource imageResource) {
		addProperty("image", imageResource.getId());//$NON-NLS-1$
	}

	public ImageIcon getImage() {
		if (propertiesContainer == null) {
			return null;
		}
		String imageResourceId = getProperty("image");//$NON-NLS-1$
		if (StringUtils.isEmpty(imageResourceId)) {
			return null;
		}

		ImageResource imageResource = DataProvider.get().getImageResource(imageResourceId);
		if (imageResource != null) {
			ImageIcon imageIcon = imageResource.getImageIcon();
			return imageIcon;
		}
		return null;
	}

	@Override
	public JsonObject getPropertyStore() {
		if (propertiesContainer == null) {
			propertiesContainer = new JsonObject();
		}
		return propertiesContainer;
	}

	public void removeImage() {
		removeProperty("image"); //$NON-NLS-1$
	}

	@Override
	public Integer getWidth() {
		ImageIcon imageIcon = getImage();
		if (imageIcon == null) {
			return super.getWidth();
		}
		return imageIcon.getIconWidth();
	}

	@Override
	public Integer getHeight() {
		ImageIcon imageIcon = getImage();
		if (imageIcon == null) {
			return super.getHeight();
		}
		return imageIcon.getIconHeight();
	}

	public String getNameOrNumber() {
		Store store = DataProvider.get().getStore();
		String tableName = this.getName();
		return (store.isShowTableNameOnTable() && StringUtils.isNotBlank(tableName)) ? tableName : this.getTableNumber().toString();
	}

	//	public String getOutletName() {
	//		Outlet outlet = OutletDAO.getInstance().get(getOutletId());
	//		if (outlet == null) {
	//			return ""; //$NON-NLS-1$
	//		}
	//		return outlet.getName();
	//	}
}