package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the DELIVERY_ADDRESS table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="DELIVERY_ADDRESS"
 */

public abstract class BaseDeliveryAddress  implements Comparable, Serializable {

	public static String REF = "DeliveryAddress"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_DISTANCE = "distance"; //$NON-NLS-1$
	public static String PROP_PHONE_EXTENSION = "phoneExtension"; //$NON-NLS-1$
	public static String PROP_ROOM_NO = "roomNo"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_COUNTRY = "country"; //$NON-NLS-1$
	public static String PROP_ZIP_CODE = "zipCode"; //$NON-NLS-1$
	public static String PROP_CITY = "city"; //$NON-NLS-1$
	public static String PROP_DEFAULT_ADDRESS = "defaultAddress"; //$NON-NLS-1$
	public static String PROP_PHONE_NO = "phoneNo"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_NAME = "name"; //$NON-NLS-1$
	public static String PROP_STATE = "state"; //$NON-NLS-1$
	public static String PROP_CUSTOMER_ID = "customerId"; //$NON-NLS-1$
	public static String PROP_ADDRESS = "address"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_COUNTRY_CODE = "countryCode"; //$NON-NLS-1$


	// constructors
	public BaseDeliveryAddress () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseDeliveryAddress (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	 long version;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.String name;
				private java.lang.String address;
				private java.lang.String phoneNo;
				private java.lang.String phoneExtension;
				private java.lang.String roomNo;
				private java.lang.String city;
				private java.lang.String state;
				private java.lang.String zipCode;
				private java.lang.String country;
				private java.lang.String countryCode;
				private java.lang.String properties;
				private java.lang.Double distance;
				private java.lang.String customerId;
				private java.lang.Boolean defaultAddress;
				private java.lang.Boolean deleted;
	


	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.GlobalIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */

	public long getVersion () {
			return version;
	}



	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: NAME
	 */

	public java.lang.String getName () {
			return name;
	}



	/**
	 * Set the value related to the column: NAME
	 * @param name the NAME value
	 */
			public void setName (java.lang.String name) {
			this.name = name;
	}



	/**
	 * Return the value associated with the column: ADDRESS
	 */

	public java.lang.String getAddress () {
			return address;
	}



	/**
	 * Set the value related to the column: ADDRESS
	 * @param address the ADDRESS value
	 */
			public void setAddress (java.lang.String address) {
			this.address = address;
	}



	/**
	 * Return the value associated with the column: PHONE_NO
	 */

	public java.lang.String getPhoneNo () {
			return phoneNo;
	}



	/**
	 * Set the value related to the column: PHONE_NO
	 * @param phoneNo the PHONE_NO value
	 */
			public void setPhoneNo (java.lang.String phoneNo) {
			this.phoneNo = phoneNo;
	}



	/**
	 * Return the value associated with the column: PHONE_EXTENSION
	 */

	public java.lang.String getPhoneExtension () {
			return phoneExtension;
	}



	/**
	 * Set the value related to the column: PHONE_EXTENSION
	 * @param phoneExtension the PHONE_EXTENSION value
	 */
			public void setPhoneExtension (java.lang.String phoneExtension) {
			this.phoneExtension = phoneExtension;
	}



	/**
	 * Return the value associated with the column: ROOM_NO
	 */

	public java.lang.String getRoomNo () {
			return roomNo;
	}



	/**
	 * Set the value related to the column: ROOM_NO
	 * @param roomNo the ROOM_NO value
	 */
			public void setRoomNo (java.lang.String roomNo) {
			this.roomNo = roomNo;
	}



	/**
	 * Return the value associated with the column: CITY
	 */

	public java.lang.String getCity () {
			return city;
	}



	/**
	 * Set the value related to the column: CITY
	 * @param city the CITY value
	 */
			public void setCity (java.lang.String city) {
			this.city = city;
	}



	/**
	 * Return the value associated with the column: STATE
	 */

	public java.lang.String getState () {
			return state;
	}



	/**
	 * Set the value related to the column: STATE
	 * @param state the STATE value
	 */
			public void setState (java.lang.String state) {
			this.state = state;
	}



	/**
	 * Return the value associated with the column: ZIPCODE
	 */

	public java.lang.String getZipCode () {
			return zipCode;
	}



	/**
	 * Set the value related to the column: ZIPCODE
	 * @param zipCode the ZIPCODE value
	 */
			public void setZipCode (java.lang.String zipCode) {
			this.zipCode = zipCode;
	}



	/**
	 * Return the value associated with the column: COUNTRY
	 */

	public java.lang.String getCountry () {
			return country;
	}



	/**
	 * Set the value related to the column: COUNTRY
	 * @param country the COUNTRY value
	 */
			public void setCountry (java.lang.String country) {
			this.country = country;
	}



	/**
	 * Return the value associated with the column: COUNTRY_CODE
	 */

	public java.lang.String getCountryCode () {
			return countryCode;
	}



	/**
	 * Set the value related to the column: COUNTRY_CODE
	 * @param countryCode the COUNTRY_CODE value
	 */
			public void setCountryCode (java.lang.String countryCode) {
			this.countryCode = countryCode;
	}



	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
			public void setProperties (java.lang.String properties) {
			this.properties = properties;
	}



	/**
	 * Return the value associated with the column: DISTANCE
	 */

	public java.lang.Double getDistance () {
						return distance == null ? Double.valueOf(0) : distance;
		}



	/**
	 * Set the value related to the column: DISTANCE
	 * @param distance the DISTANCE value
	 */
			public void setDistance (java.lang.Double distance) {
			this.distance = distance;
	}



	/**
	 * Return the value associated with the column: CUSTOMER_ID
	 */

	public java.lang.String getCustomerId () {
			return customerId;
	}



	/**
	 * Set the value related to the column: CUSTOMER_ID
	 * @param customerId the CUSTOMER_ID value
	 */
			public void setCustomerId (java.lang.String customerId) {
			this.customerId = customerId;
	}



	/**
	 * Return the value associated with the column: DEFAULT_ADDRESS
	 */

	public java.lang.Boolean isDefaultAddress () {
					return defaultAddress == null ? Boolean.FALSE : defaultAddress;
		}

	public java.lang.Boolean getDefaultAddress () {
				return defaultAddress == null ? Boolean.FALSE : defaultAddress;
			}


	/**
	 * Set the value related to the column: DEFAULT_ADDRESS
	 * @param defaultAddress the DEFAULT_ADDRESS value
	 */
			public void setDefaultAddress (java.lang.Boolean defaultAddress) {
			this.defaultAddress = defaultAddress;
	}



	/**
	 * Return the value associated with the column: DELETED
	 */

	public java.lang.Boolean isDeleted () {
					return deleted == null ? Boolean.FALSE : deleted;
		}

	public java.lang.Boolean getDeleted () {
				return deleted == null ? Boolean.FALSE : deleted;
			}


	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
			public void setDeleted (java.lang.Boolean deleted) {
			this.deleted = deleted;
	}





	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.DeliveryAddress)) return false;
		else {
			com.floreantpos.model.DeliveryAddress deliveryAddress = (com.floreantpos.model.DeliveryAddress) obj;
			if (null == this.getId() || null == deliveryAddress.getId()) return this == obj;
			else return (this.getId().equals(deliveryAddress.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}