package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the ONLINE_STORE table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="ONLINE_STORE"
 */

public abstract class BaseOnlineStore  implements Comparable, Serializable {

	public static String REF = "OnlineStore"; //$NON-NLS-1$
	public static String PROP_TEMPORARILY_SHUTDOWN = "temporarilyShutdown"; //$NON-NLS-1$
	public static String PROP_TELEPHONE = "telephone"; //$NON-NLS-1$
	public static String PROP_FRIENDLY_URL = "friendlyUrl"; //$NON-NLS-1$
	public static String PROP_STORE_IMAGE_ID = "storeImageId"; //$NON-NLS-1$
	public static String PROP_OUTLET_LONGITUDE = "outletLongitude"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_STORE_ID = "storeId"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_STREET = "street"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$
	public static String PROP_OUTLET_NAME = "outletName"; //$NON-NLS-1$
	public static String PROP_STORE_NAME = "storeName"; //$NON-NLS-1$
	public static String PROP_ZIP_CODE = "zipCode"; //$NON-NLS-1$
	public static String PROP_FLAT_NO = "flatNo"; //$NON-NLS-1$
	public static String PROP_LIVE = "live"; //$NON-NLS-1$
	public static String PROP_HOUSE = "house"; //$NON-NLS-1$
	public static String PROP_CITY = "city"; //$NON-NLS-1$
	public static String PROP_ADDRESS_LINE3 = "addressLine3"; //$NON-NLS-1$
	public static String PROP_ADDRESS_LINE2 = "addressLine2"; //$NON-NLS-1$
	public static String PROP_ADDRESS_LINE1 = "addressLine1"; //$NON-NLS-1$
	public static String PROP_TYPE = "type"; //$NON-NLS-1$
	public static String PROP_STATE = "state"; //$NON-NLS-1$
	public static String PROP_OUTLET_LATITUDE = "outletLatitude"; //$NON-NLS-1$
	public static String PROP_COUNTRY = "country"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$


	// constructors
	public BaseOnlineStore () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseOnlineStore (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	 long version;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.String storeId;
				private java.lang.String outletId;
				private java.lang.String friendlyUrl;
				private java.lang.String storeName;
				private java.lang.String outletName;
				private java.lang.String storeImageId;
				private java.lang.String addressLine1;
				private java.lang.String addressLine2;
				private java.lang.String addressLine3;
				private java.lang.String house;
				private java.lang.String flatNo;
				private java.lang.String type;
				private java.lang.String street;
				private java.lang.String city;
				private java.lang.String state;
				private java.lang.String zipCode;
				private java.lang.String country;
				private java.lang.String telephone;
				private java.lang.Double outletLatitude;
				private java.lang.Double outletLongitude;
				private java.lang.Boolean live;
				private java.lang.Boolean temporarilyShutdown;
				private java.lang.String properties;
				private java.lang.Boolean deleted;
	


	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.UUIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */

	public long getVersion () {
			return version;
	}



	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: STORE_ID
	 */

	public java.lang.String getStoreId () {
			return storeId;
	}



	/**
	 * Set the value related to the column: STORE_ID
	 * @param storeId the STORE_ID value
	 */
			public void setStoreId (java.lang.String storeId) {
			this.storeId = storeId;
	}



	/**
	 * Return the value associated with the column: OUTLET_ID
	 */

	public java.lang.String getOutletId () {
			return outletId;
	}



	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
			public void setOutletId (java.lang.String outletId) {
			this.outletId = outletId;
	}



	/**
	 * Return the value associated with the column: FRIENDLY_URL
	 */

	public java.lang.String getFriendlyUrl () {
			return friendlyUrl;
	}



	/**
	 * Set the value related to the column: FRIENDLY_URL
	 * @param friendlyUrl the FRIENDLY_URL value
	 */
			public void setFriendlyUrl (java.lang.String friendlyUrl) {
			this.friendlyUrl = friendlyUrl;
	}



	/**
	 * Return the value associated with the column: STORE_NAME
	 */

	public java.lang.String getStoreName () {
			return storeName;
	}



	/**
	 * Set the value related to the column: STORE_NAME
	 * @param storeName the STORE_NAME value
	 */
			public void setStoreName (java.lang.String storeName) {
			this.storeName = storeName;
	}



	/**
	 * Return the value associated with the column: OUTLET_NAME
	 */

	public java.lang.String getOutletName () {
			return outletName;
	}



	/**
	 * Set the value related to the column: OUTLET_NAME
	 * @param outletName the OUTLET_NAME value
	 */
			public void setOutletName (java.lang.String outletName) {
			this.outletName = outletName;
	}



	/**
	 * Return the value associated with the column: STORE_IMAGE_ID
	 */

	public java.lang.String getStoreImageId () {
			return storeImageId;
	}



	/**
	 * Set the value related to the column: STORE_IMAGE_ID
	 * @param storeImageId the STORE_IMAGE_ID value
	 */
			public void setStoreImageId (java.lang.String storeImageId) {
			this.storeImageId = storeImageId;
	}



	/**
	 * Return the value associated with the column: ADDRESS_LINE1
	 */

	public java.lang.String getAddressLine1 () {
			return addressLine1;
	}



	/**
	 * Set the value related to the column: ADDRESS_LINE1
	 * @param addressLine1 the ADDRESS_LINE1 value
	 */
			public void setAddressLine1 (java.lang.String addressLine1) {
			this.addressLine1 = addressLine1;
	}



	/**
	 * Return the value associated with the column: ADDRESS_LINE2
	 */

	public java.lang.String getAddressLine2 () {
			return addressLine2;
	}



	/**
	 * Set the value related to the column: ADDRESS_LINE2
	 * @param addressLine2 the ADDRESS_LINE2 value
	 */
			public void setAddressLine2 (java.lang.String addressLine2) {
			this.addressLine2 = addressLine2;
	}



	/**
	 * Return the value associated with the column: ADDRESS_LINE3
	 */

	public java.lang.String getAddressLine3 () {
			return addressLine3;
	}



	/**
	 * Set the value related to the column: ADDRESS_LINE3
	 * @param addressLine3 the ADDRESS_LINE3 value
	 */
			public void setAddressLine3 (java.lang.String addressLine3) {
			this.addressLine3 = addressLine3;
	}



	/**
	 * Return the value associated with the column: HOUSE
	 */

	public java.lang.String getHouse () {
			return house;
	}



	/**
	 * Set the value related to the column: HOUSE
	 * @param house the HOUSE value
	 */
			public void setHouse (java.lang.String house) {
			this.house = house;
	}



	/**
	 * Return the value associated with the column: FLAT_NO
	 */

	public java.lang.String getFlatNo () {
			return flatNo;
	}



	/**
	 * Set the value related to the column: FLAT_NO
	 * @param flatNo the FLAT_NO value
	 */
			public void setFlatNo (java.lang.String flatNo) {
			this.flatNo = flatNo;
	}



	/**
	 * Return the value associated with the column: TYPE
	 */

	public java.lang.String getType () {
			return type;
	}



	/**
	 * Set the value related to the column: TYPE
	 * @param type the TYPE value
	 */
			public void setType (java.lang.String type) {
			this.type = type;
	}



	/**
	 * Return the value associated with the column: STREET
	 */

	public java.lang.String getStreet () {
			return street;
	}



	/**
	 * Set the value related to the column: STREET
	 * @param street the STREET value
	 */
			public void setStreet (java.lang.String street) {
			this.street = street;
	}



	/**
	 * Return the value associated with the column: CITY
	 */

	public java.lang.String getCity () {
			return city;
	}



	/**
	 * Set the value related to the column: CITY
	 * @param city the CITY value
	 */
			public void setCity (java.lang.String city) {
			this.city = city;
	}



	/**
	 * Return the value associated with the column: STATE
	 */

	public java.lang.String getState () {
			return state;
	}



	/**
	 * Set the value related to the column: STATE
	 * @param state the STATE value
	 */
			public void setState (java.lang.String state) {
			this.state = state;
	}



	/**
	 * Return the value associated with the column: ZIPCODE
	 */

	public java.lang.String getZipCode () {
			return zipCode;
	}



	/**
	 * Set the value related to the column: ZIPCODE
	 * @param zipCode the ZIPCODE value
	 */
			public void setZipCode (java.lang.String zipCode) {
			this.zipCode = zipCode;
	}



	/**
	 * Return the value associated with the column: COUNTRY
	 */

	public java.lang.String getCountry () {
			return country;
	}



	/**
	 * Set the value related to the column: COUNTRY
	 * @param country the COUNTRY value
	 */
			public void setCountry (java.lang.String country) {
			this.country = country;
	}



	/**
	 * Return the value associated with the column: TELEPHONE
	 */

	public java.lang.String getTelephone () {
			return telephone;
	}



	/**
	 * Set the value related to the column: TELEPHONE
	 * @param telephone the TELEPHONE value
	 */
			public void setTelephone (java.lang.String telephone) {
			this.telephone = telephone;
	}



	/**
	 * Return the value associated with the column: OUTLET_LATITUDE
	 */

	public java.lang.Double getOutletLatitude () {
						return outletLatitude == null ? Double.valueOf(0) : outletLatitude;
		}



	/**
	 * Set the value related to the column: OUTLET_LATITUDE
	 * @param outletLatitude the OUTLET_LATITUDE value
	 */
			public void setOutletLatitude (java.lang.Double outletLatitude) {
			this.outletLatitude = outletLatitude;
	}



	/**
	 * Return the value associated with the column: OUTLET_LONGITUDE
	 */

	public java.lang.Double getOutletLongitude () {
						return outletLongitude == null ? Double.valueOf(0) : outletLongitude;
		}



	/**
	 * Set the value related to the column: OUTLET_LONGITUDE
	 * @param outletLongitude the OUTLET_LONGITUDE value
	 */
			public void setOutletLongitude (java.lang.Double outletLongitude) {
			this.outletLongitude = outletLongitude;
	}



	/**
	 * Return the value associated with the column: LIVE
	 */

	public java.lang.Boolean isLive () {
					return live == null ? Boolean.FALSE : live;
		}

	public java.lang.Boolean getLive () {
				return live == null ? Boolean.FALSE : live;
			}


	/**
	 * Set the value related to the column: LIVE
	 * @param live the LIVE value
	 */
			public void setLive (java.lang.Boolean live) {
			this.live = live;
	}



	/**
	 * Return the value associated with the column: TEMPORARILY_SHUTDOWN
	 */

	public java.lang.Boolean isTemporarilyShutdown () {
					return temporarilyShutdown == null ? Boolean.FALSE : temporarilyShutdown;
		}

	public java.lang.Boolean getTemporarilyShutdown () {
				return temporarilyShutdown == null ? Boolean.FALSE : temporarilyShutdown;
			}


	/**
	 * Set the value related to the column: TEMPORARILY_SHUTDOWN
	 * @param temporarilyShutdown the TEMPORARILY_SHUTDOWN value
	 */
			public void setTemporarilyShutdown (java.lang.Boolean temporarilyShutdown) {
			this.temporarilyShutdown = temporarilyShutdown;
	}



	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
			public void setProperties (java.lang.String properties) {
			this.properties = properties;
	}



	/**
	 * Return the value associated with the column: DELETED
	 */

	public java.lang.Boolean isDeleted () {
						return deleted == null ? Boolean.valueOf(false) : deleted;
			}

	public java.lang.Boolean getDeleted () {
					return deleted == null ? Boolean.valueOf(false) : deleted;
			}


	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
			public void setDeleted (java.lang.Boolean deleted) {
			this.deleted = deleted;
	}


	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue () {
		return "false";
	}




	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.OnlineStore)) return false;
		else {
			com.floreantpos.model.OnlineStore onlineStore = (com.floreantpos.model.OnlineStore) obj;
			if (null == this.getId() || null == onlineStore.getId()) return this == obj;
			else return (this.getId().equals(onlineStore.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}