package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the TICKET table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="TICKET"
 */

public abstract class BaseTicket  implements Comparable, Serializable {

	public static String REF = "Ticket"; //$NON-NLS-1$
	public static String PROP_ADVANCE_AMOUNT = "advanceAmount"; //$NON-NLS-1$
	public static String PROP_RE_OPENED = "reOpened"; //$NON-NLS-1$
	public static String PROP_CASHIER_ID = "cashierId"; //$NON-NLS-1$
	public static String PROP_SHIFT_ID = "shiftId"; //$NON-NLS-1$
	public static String PROP_DELIVERY_DATE = "deliveryDate"; //$NON-NLS-1$
	public static String PROP_CREATE_DATE = "createDate"; //$NON-NLS-1$
	public static String PROP_GRATUITY = "gratuity"; //$NON-NLS-1$
	public static String PROP_TAX_AMOUNT = "taxAmount"; //$NON-NLS-1$
	public static String PROP_CREATED_BY_USER_ID = "createdByUserId"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_SHOULD_INCLUDE_IN_SALES = "shouldIncludeInSales"; //$NON-NLS-1$
	public static String PROP_EXTRA_PROPERTIES = "extraProperties"; //$NON-NLS-1$
	public static String PROP_TERMINAL_ID = "terminalId"; //$NON-NLS-1$
	public static String PROP_DISCOUNTS_PROPERTY = "discountsProperty"; //$NON-NLS-1$
	public static String PROP_REFUNDED = "refunded"; //$NON-NLS-1$
	public static String PROP_STATUS = "status"; //$NON-NLS-1$
	public static String PROP_WASTED = "wasted"; //$NON-NLS-1$
	public static String PROP_CUSTOMER_ID = "customerId"; //$NON-NLS-1$
	public static String PROP_INVENTORY_LOCATION_ID = "inventoryLocationId"; //$NON-NLS-1$
	public static String PROP_DISCOUNT_AMOUNT = "discountAmount"; //$NON-NLS-1$
	public static String PROP_PAID_AMOUNT = "paidAmount"; //$NON-NLS-1$
	public static String PROP_TICKET_TABLE_NUMBERS = "ticketTableNumbers"; //$NON-NLS-1$
	public static String PROP_CLOUD_SYNCED = "cloudSynced"; //$NON-NLS-1$
	public static String PROP_NOTE = "note"; //$NON-NLS-1$
	public static String PROP_EXTRA_DELIVERY_INFO = "extraDeliveryInfo"; //$NON-NLS-1$
	public static String PROP_DATA_VERSION = "dataVersion"; //$NON-NLS-1$
	public static String PROP_NUMBER_OF_GUESTS = "numberOfGuests"; //$NON-NLS-1$
	public static String PROP_SUBTOTAL_AMOUNT = "subtotalAmount"; //$NON-NLS-1$
	public static String PROP_REFUNDABLE_AMOUNT = "refundableAmount"; //$NON-NLS-1$
	public static String PROP_DUE_AMOUNT = "dueAmount"; //$NON-NLS-1$
	public static String PROP_SHOULD_CALCULATE_PRICE = "shouldCalculatePrice"; //$NON-NLS-1$
	public static String PROP_DELIVERY_ADDRESS = "deliveryAddress"; //$NON-NLS-1$
	public static String PROP_PAID = "paid"; //$NON-NLS-1$
	public static String PROP_TAX_INCLUDED = "taxIncluded"; //$NON-NLS-1$
	public static String PROP_CUSTOMER_WILL_PICKUP = "customerWillPickup"; //$NON-NLS-1$
	public static String PROP_HAS_SYNC_ERROR = "hasSyncError"; //$NON-NLS-1$
	public static String PROP_CREATION_HOUR = "creationHour"; //$NON-NLS-1$
	public static String PROP_SOURCE = "source"; //$NON-NLS-1$
	public static String PROP_ORDER_STATUS = "orderStatus"; //$NON-NLS-1$
	public static String PROP_SERVICE_CHARGE = "serviceCharge"; //$NON-NLS-1$
	public static String PROP_OWNER_ID = "ownerId"; //$NON-NLS-1$
	public static String PROP_VOID_REASON = "voidReason"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_ORDER_TYPE_ID = "orderTypeId"; //$NON-NLS-1$
	public static String PROP_OWNER_TYPE_ID = "ownerTypeId"; //$NON-NLS-1$
	public static String PROP_VOIDED_BY_ID = "voidedById"; //$NON-NLS-1$
	public static String PROP_STORE_SESSION_ID = "storeSessionId"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_VOIDED = "voided"; //$NON-NLS-1$
	public static String PROP_FEE_AMOUNT = "feeAmount"; //$NON-NLS-1$
	public static String PROP_REVENUE_PURPOSE = "revenue_purpose"; //$NON-NLS-1$
	public static String PROP_DELIVERY_CHARGE = "deliveryCharge"; //$NON-NLS-1$
	public static String PROP_SALES_AREA_ID = "salesAreaId"; //$NON-NLS-1$
	public static String PROP_ACTIVE_DATE = "activeDate"; //$NON-NLS-1$
	public static String PROP_REFUND_AMOUNT = "refundAmount"; //$NON-NLS-1$
	public static String PROP_TOTAL_AMOUNT = "totalAmount"; //$NON-NLS-1$
	public static String PROP_VOID_AMOUNT = "voidAmount"; //$NON-NLS-1$
	public static String PROP_ASSIGNED_DRIVER_ID = "assignedDriverId"; //$NON-NLS-1$
	public static String PROP_TAX_EXEMPT = "taxExempt"; //$NON-NLS-1$
	public static String PROP_TOKEN_NO = "tokenNo"; //$NON-NLS-1$
	public static String PROP_TYPE = "type"; //$NON-NLS-1$
	public static String PROP_CLOSED = "closed"; //$NON-NLS-1$
	public static String PROP_SHORT_ID = "shortId"; //$NON-NLS-1$
	public static String PROP_CLOSING_DATE = "closingDate"; //$NON-NLS-1$
	public static String PROP_DEPARTMENT_ID = "departmentId"; //$NON-NLS-1$


	// constructors
	public BaseTicket () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseTicket (
		java.lang.String id,
		java.lang.String outletId) {

		this.setId(id);
		this.setOutletId(outletId);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key

	private java.lang.String id;

	private java.lang.String outletId;

	 long version;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.String shortId;
				private java.lang.Integer tokenNo;
				private java.lang.Integer dataVersion;
				private java.util.Date createDate;
				private java.util.Date closingDate;
				private java.util.Date activeDate;
				private java.util.Date deliveryDate;
				private java.lang.Integer creationHour;
				private java.lang.Boolean paid;
				private java.lang.Boolean voided;
				private java.lang.String voidReason;
				private java.lang.Boolean wasted;
				private java.lang.Boolean refunded;
				private java.lang.Boolean closed;
				private java.lang.Boolean taxIncluded;
				private java.lang.Double subtotalAmount;
				private java.lang.Double discountAmount;
				private java.lang.Double taxAmount;
				private java.lang.Double totalAmount;
				private java.lang.Double paidAmount;
				private java.lang.Double voidAmount;
				private java.lang.Double refundAmount;
				private java.lang.Double refundableAmount;
				private java.lang.Double dueAmount;
				private java.lang.Double feeAmount;
				private java.lang.Double advanceAmount;
				private java.lang.Integer numberOfGuests;
				private java.lang.String status;
				private java.lang.Integer orderStatus;
				private java.lang.Integer type;
				private java.lang.String departmentId;
				private java.lang.String salesAreaId;
				private java.lang.String storeSessionId;
				private java.lang.Boolean shouldCalculatePrice;
				private java.lang.Boolean taxExempt;
				private java.lang.Boolean reOpened;
				private java.lang.Double serviceCharge;
				private java.lang.Double deliveryCharge;
				private java.lang.String customerId;
				private java.lang.String deliveryAddress;
				private java.lang.Boolean customerWillPickup;
				private java.lang.String extraDeliveryInfo;
				private java.lang.Boolean shouldIncludeInSales;
				private java.lang.String revenue_purpose;
				private java.lang.String source;
				private java.lang.String orderTypeId;
				private java.lang.String inventoryLocationId;
				private java.lang.String shiftId;
				private java.lang.String createdByUserId;
				private java.lang.String ownerId;
				private java.lang.String ownerTypeId;
				private java.lang.String cashierId;
				private java.lang.String assignedDriverId;
				private java.lang.String voidedById;
				private java.lang.Integer terminalId;
				private java.lang.Boolean cloudSynced;
				private java.lang.Boolean hasSyncError;
				private java.lang.String ticketTableNumbers;
				private java.lang.String discountsProperty;
				private java.lang.String note;
				private java.lang.String extraProperties;
				private java.lang.Boolean deleted;
	
	// many to one
	private com.floreantpos.model.Gratuity gratuity;

	// collections
	private java.util.Map<String, String> properties;
	private java.util.List<com.floreantpos.model.TicketItem> ticketItems;
	private java.util.Set<com.floreantpos.model.PosTransaction> transactions;



	/**
     * @hibernate.property
     *  column=ID
	 * not-null=true
	 */
	public java.lang.String getId () {
		return this.id;
	}

	/**
	 * Set the value related to the column: ID
	 * @param id the ID value
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}

	/**
     * @hibernate.property
     *  column=OUTLET_ID
	 * not-null=true
	 */
	public java.lang.String getOutletId () {
		return this.outletId;
	}

	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
	public void setOutletId (java.lang.String outletId) {
		this.outletId = outletId;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */

	public long getVersion () {
			return version;
	}



	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: SHORT_ID
	 */

	public java.lang.String getShortId () {
			return shortId;
	}



	/**
	 * Set the value related to the column: SHORT_ID
	 * @param shortId the SHORT_ID value
	 */
			public void setShortId (java.lang.String shortId) {
			this.shortId = shortId;
	}



	/**
	 * Return the value associated with the column: TOKEN_NO
	 */

	public java.lang.Integer getTokenNo () {
						return tokenNo == null ? Integer.valueOf(0) : tokenNo;
		}



	/**
	 * Set the value related to the column: TOKEN_NO
	 * @param tokenNo the TOKEN_NO value
	 */
			public void setTokenNo (java.lang.Integer tokenNo) {
			this.tokenNo = tokenNo;
	}



	/**
	 * Return the value associated with the column: DATA_VERSION
	 */

	public java.lang.Integer getDataVersion () {
						return dataVersion == null ? Integer.valueOf(0) : dataVersion;
		}



	/**
	 * Set the value related to the column: DATA_VERSION
	 * @param dataVersion the DATA_VERSION value
	 */
			public void setDataVersion (java.lang.Integer dataVersion) {
			this.dataVersion = dataVersion;
	}



	/**
	 * Return the value associated with the column: CREATE_DATE
	 */

	public java.util.Date getCreateDate () {
			return createDate;
	}



	/**
	 * Set the value related to the column: CREATE_DATE
	 * @param createDate the CREATE_DATE value
	 */
			public void setCreateDate (java.util.Date createDate) {
			this.createDate = createDate;
	}



	/**
	 * Return the value associated with the column: CLOSING_DATE
	 */

	public java.util.Date getClosingDate () {
			return closingDate;
	}



	/**
	 * Set the value related to the column: CLOSING_DATE
	 * @param closingDate the CLOSING_DATE value
	 */
			public void setClosingDate (java.util.Date closingDate) {
			this.closingDate = closingDate;
	}



	/**
	 * Return the value associated with the column: ACTIVE_DATE
	 */

	public java.util.Date getActiveDate () {
			return activeDate;
	}



	/**
	 * Set the value related to the column: ACTIVE_DATE
	 * @param activeDate the ACTIVE_DATE value
	 */
			public void setActiveDate (java.util.Date activeDate) {
			this.activeDate = activeDate;
	}



	/**
	 * Return the value associated with the column: DELIVEERY_DATE
	 */

	public java.util.Date getDeliveryDate () {
			return deliveryDate;
	}



	/**
	 * Set the value related to the column: DELIVEERY_DATE
	 * @param deliveryDate the DELIVEERY_DATE value
	 */
			public void setDeliveryDate (java.util.Date deliveryDate) {
			this.deliveryDate = deliveryDate;
	}



	/**
	 * Return the value associated with the column: CREATION_HOUR
	 */

	public java.lang.Integer getCreationHour () {
						return creationHour == null ? Integer.valueOf(0) : creationHour;
		}



	/**
	 * Set the value related to the column: CREATION_HOUR
	 * @param creationHour the CREATION_HOUR value
	 */
			public void setCreationHour (java.lang.Integer creationHour) {
			this.creationHour = creationHour;
	}



	/**
	 * Return the value associated with the column: PAID
	 */

	public java.lang.Boolean isPaid () {
					return paid == null ? Boolean.FALSE : paid;
		}

	public java.lang.Boolean getPaid () {
				return paid == null ? Boolean.FALSE : paid;
			}


	/**
	 * Set the value related to the column: PAID
	 * @param paid the PAID value
	 */
			public void setPaid (java.lang.Boolean paid) {
			this.paid = paid;
	}



	/**
	 * Return the value associated with the column: VOIDED
	 */

	public java.lang.Boolean isVoided () {
					return voided == null ? Boolean.FALSE : voided;
		}

	public java.lang.Boolean getVoided () {
				return voided == null ? Boolean.FALSE : voided;
			}


	/**
	 * Set the value related to the column: VOIDED
	 * @param voided the VOIDED value
	 */
			public void setVoided (java.lang.Boolean voided) {
			this.voided = voided;
	}



	/**
	 * Return the value associated with the column: VOID_REASON
	 */

	public java.lang.String getVoidReason () {
			return voidReason;
	}



	/**
	 * Set the value related to the column: VOID_REASON
	 * @param voidReason the VOID_REASON value
	 */
			public void setVoidReason (java.lang.String voidReason) {
			this.voidReason = voidReason;
	}



	/**
	 * Return the value associated with the column: WASTED
	 */

	public java.lang.Boolean isWasted () {
					return wasted == null ? Boolean.FALSE : wasted;
		}

	public java.lang.Boolean getWasted () {
				return wasted == null ? Boolean.FALSE : wasted;
			}


	/**
	 * Set the value related to the column: WASTED
	 * @param wasted the WASTED value
	 */
			public void setWasted (java.lang.Boolean wasted) {
			this.wasted = wasted;
	}



	/**
	 * Return the value associated with the column: REFUNDED
	 */

	public java.lang.Boolean isRefunded () {
					return refunded == null ? Boolean.FALSE : refunded;
		}

	public java.lang.Boolean getRefunded () {
				return refunded == null ? Boolean.FALSE : refunded;
			}


	/**
	 * Set the value related to the column: REFUNDED
	 * @param refunded the REFUNDED value
	 */
			public void setRefunded (java.lang.Boolean refunded) {
			this.refunded = refunded;
	}



	/**
	 * Return the value associated with the column: SETTLED
	 */

	public java.lang.Boolean isClosed () {
					return closed == null ? Boolean.FALSE : closed;
		}

	public java.lang.Boolean getClosed () {
				return closed == null ? Boolean.FALSE : closed;
			}


	/**
	 * Set the value related to the column: SETTLED
	 * @param closed the SETTLED value
	 */
			public void setClosed (java.lang.Boolean closed) {
			this.closed = closed;
	}



	/**
	 * Return the value associated with the column: TAX_INCLUDED
	 */

	public java.lang.Boolean isTaxIncluded () {
					return taxIncluded == null ? Boolean.FALSE : taxIncluded;
		}

	public java.lang.Boolean getTaxIncluded () {
				return taxIncluded == null ? Boolean.FALSE : taxIncluded;
			}


	/**
	 * Set the value related to the column: TAX_INCLUDED
	 * @param taxIncluded the TAX_INCLUDED value
	 */
			public void setTaxIncluded (java.lang.Boolean taxIncluded) {
			this.taxIncluded = taxIncluded;
	}



	/**
	 * Return the value associated with the column: SUB_TOTAL
	 */

	public java.lang.Double getSubtotalAmount () {
						return subtotalAmount == null ? Double.valueOf(0) : subtotalAmount;
		}



	/**
	 * Set the value related to the column: SUB_TOTAL
	 * @param subtotalAmount the SUB_TOTAL value
	 */
			public void setSubtotalAmount (java.lang.Double subtotalAmount) {
			this.subtotalAmount = subtotalAmount;
	}



	/**
	 * Return the value associated with the column: TOTAL_DISCOUNT
	 */

	public java.lang.Double getDiscountAmount () {
						return discountAmount == null ? Double.valueOf(0) : discountAmount;
		}



	/**
	 * Set the value related to the column: TOTAL_DISCOUNT
	 * @param discountAmount the TOTAL_DISCOUNT value
	 */
			public void setDiscountAmount (java.lang.Double discountAmount) {
			this.discountAmount = discountAmount;
	}



	/**
	 * Return the value associated with the column: TOTAL_TAX
	 */

	public java.lang.Double getTaxAmount () {
						return taxAmount == null ? Double.valueOf(0) : taxAmount;
		}



	/**
	 * Set the value related to the column: TOTAL_TAX
	 * @param taxAmount the TOTAL_TAX value
	 */
			public void setTaxAmount (java.lang.Double taxAmount) {
			this.taxAmount = taxAmount;
	}



	/**
	 * Return the value associated with the column: TOTAL_PRICE
	 */

	public java.lang.Double getTotalAmount () {
						return totalAmount == null ? Double.valueOf(0) : totalAmount;
		}



	/**
	 * Set the value related to the column: TOTAL_PRICE
	 * @param totalAmount the TOTAL_PRICE value
	 */
			public void setTotalAmount (java.lang.Double totalAmount) {
			this.totalAmount = totalAmount;
	}



	/**
	 * Return the value associated with the column: PAID_AMOUNT
	 */

	public java.lang.Double getPaidAmount () {
						return paidAmount == null ? Double.valueOf(0) : paidAmount;
		}



	/**
	 * Set the value related to the column: PAID_AMOUNT
	 * @param paidAmount the PAID_AMOUNT value
	 */
			public void setPaidAmount (java.lang.Double paidAmount) {
			this.paidAmount = paidAmount;
	}



	/**
	 * Return the value associated with the column: VOID_AMOUNT
	 */

	public java.lang.Double getVoidAmount () {
						return voidAmount == null ? Double.valueOf(0) : voidAmount;
		}



	/**
	 * Set the value related to the column: VOID_AMOUNT
	 * @param voidAmount the VOID_AMOUNT value
	 */
			public void setVoidAmount (java.lang.Double voidAmount) {
			this.voidAmount = voidAmount;
	}



	/**
	 * Return the value associated with the column: REFUND_AMOUNT
	 */

	public java.lang.Double getRefundAmount () {
						return refundAmount == null ? Double.valueOf(0) : refundAmount;
		}



	/**
	 * Set the value related to the column: REFUND_AMOUNT
	 * @param refundAmount the REFUND_AMOUNT value
	 */
			public void setRefundAmount (java.lang.Double refundAmount) {
			this.refundAmount = refundAmount;
	}



	/**
	 * Return the value associated with the column: REFUNDABLE_AMOUNT
	 */

	public java.lang.Double getRefundableAmount () {
						return refundableAmount == null ? Double.valueOf(0) : refundableAmount;
		}



	/**
	 * Set the value related to the column: REFUNDABLE_AMOUNT
	 * @param refundableAmount the REFUNDABLE_AMOUNT value
	 */
			public void setRefundableAmount (java.lang.Double refundableAmount) {
			this.refundableAmount = refundableAmount;
	}



	/**
	 * Return the value associated with the column: DUE_AMOUNT
	 */

	public java.lang.Double getDueAmount () {
						return dueAmount == null ? Double.valueOf(0) : dueAmount;
		}



	/**
	 * Set the value related to the column: DUE_AMOUNT
	 * @param dueAmount the DUE_AMOUNT value
	 */
			public void setDueAmount (java.lang.Double dueAmount) {
			this.dueAmount = dueAmount;
	}



	/**
	 * Return the value associated with the column: FEE_AMOUNT
	 */

	public java.lang.Double getFeeAmount () {
						return feeAmount == null ? Double.valueOf(0) : feeAmount;
		}



	/**
	 * Set the value related to the column: FEE_AMOUNT
	 * @param feeAmount the FEE_AMOUNT value
	 */
			public void setFeeAmount (java.lang.Double feeAmount) {
			this.feeAmount = feeAmount;
	}



	/**
	 * Return the value associated with the column: ADVANCE_AMOUNT
	 */

	public java.lang.Double getAdvanceAmount () {
						return advanceAmount == null ? Double.valueOf(0) : advanceAmount;
		}



	/**
	 * Set the value related to the column: ADVANCE_AMOUNT
	 * @param advanceAmount the ADVANCE_AMOUNT value
	 */
			public void setAdvanceAmount (java.lang.Double advanceAmount) {
			this.advanceAmount = advanceAmount;
	}



	/**
	 * Return the value associated with the column: NUMBER_OF_GUESTS
	 */

	public java.lang.Integer getNumberOfGuests () {
						return numberOfGuests == null ? Integer.valueOf(0) : numberOfGuests;
		}



	/**
	 * Set the value related to the column: NUMBER_OF_GUESTS
	 * @param numberOfGuests the NUMBER_OF_GUESTS value
	 */
			public void setNumberOfGuests (java.lang.Integer numberOfGuests) {
			this.numberOfGuests = numberOfGuests;
	}



	/**
	 * Return the value associated with the column: STATUS
	 */

	public java.lang.String getStatus () {
			return status;
	}



	/**
	 * Set the value related to the column: STATUS
	 * @param status the STATUS value
	 */
			public void setStatus (java.lang.String status) {
			this.status = status;
	}



	/**
	 * Return the value associated with the column: ORDER_STATUS
	 */

	public java.lang.Integer getOrderStatus () {
						return orderStatus == null ? Integer.valueOf(0) : orderStatus;
		}



	/**
	 * Set the value related to the column: ORDER_STATUS
	 * @param orderStatus the ORDER_STATUS value
	 */
			public void setOrderStatus (java.lang.Integer orderStatus) {
			this.orderStatus = orderStatus;
	}



	/**
	 * Return the value associated with the column: TYPE
	 */

	public java.lang.Integer getType () {
						return type == null ? Integer.valueOf(0) : type;
		}



	/**
	 * Set the value related to the column: TYPE
	 * @param type the TYPE value
	 */
			public void setType (java.lang.Integer type) {
			this.type = type;
	}



	/**
	 * Return the value associated with the column: DEPARTMENT_ID
	 */

	public java.lang.String getDepartmentId () {
			return departmentId;
	}



	/**
	 * Set the value related to the column: DEPARTMENT_ID
	 * @param departmentId the DEPARTMENT_ID value
	 */
			public void setDepartmentId (java.lang.String departmentId) {
			this.departmentId = departmentId;
	}



	/**
	 * Return the value associated with the column: SALES_AREA_ID
	 */

	public java.lang.String getSalesAreaId () {
			return salesAreaId;
	}



	/**
	 * Set the value related to the column: SALES_AREA_ID
	 * @param salesAreaId the SALES_AREA_ID value
	 */
			public void setSalesAreaId (java.lang.String salesAreaId) {
			this.salesAreaId = salesAreaId;
	}



	/**
	 * Return the value associated with the column: STORE_SESSION_ID
	 */

	public java.lang.String getStoreSessionId () {
			return storeSessionId;
	}



	/**
	 * Set the value related to the column: STORE_SESSION_ID
	 * @param storeSessionId the STORE_SESSION_ID value
	 */
			public void setStoreSessionId (java.lang.String storeSessionId) {
			this.storeSessionId = storeSessionId;
	}



	/**
	 * Return the value associated with the column: SHLD_CALC_PRICE
	 */

	public java.lang.Boolean isShouldCalculatePrice () {
						return shouldCalculatePrice == null ? Boolean.valueOf(true) : shouldCalculatePrice;
			}

	public java.lang.Boolean getShouldCalculatePrice () {
					return shouldCalculatePrice == null ? Boolean.valueOf(true) : shouldCalculatePrice;
			}


	/**
	 * Set the value related to the column: SHLD_CALC_PRICE
	 * @param shouldCalculatePrice the SHLD_CALC_PRICE value
	 */
			public void setShouldCalculatePrice (java.lang.Boolean shouldCalculatePrice) {
			this.shouldCalculatePrice = shouldCalculatePrice;
	}


	/**
	 * Custom property
	 */
	public static String getShouldCalculatePriceDefaultValue () {
		return "true";
	}


	/**
	 * Return the value associated with the column: IS_TAX_EXEMPT
	 */

	public java.lang.Boolean isTaxExempt () {
					return taxExempt == null ? Boolean.FALSE : taxExempt;
		}

	public java.lang.Boolean getTaxExempt () {
				return taxExempt == null ? Boolean.FALSE : taxExempt;
			}


	/**
	 * Set the value related to the column: IS_TAX_EXEMPT
	 * @param taxExempt the IS_TAX_EXEMPT value
	 */
			public void setTaxExempt (java.lang.Boolean taxExempt) {
			this.taxExempt = taxExempt;
	}



	/**
	 * Return the value associated with the column: IS_RE_OPENED
	 */

	public java.lang.Boolean isReOpened () {
					return reOpened == null ? Boolean.FALSE : reOpened;
		}

	public java.lang.Boolean getReOpened () {
				return reOpened == null ? Boolean.FALSE : reOpened;
			}


	/**
	 * Set the value related to the column: IS_RE_OPENED
	 * @param reOpened the IS_RE_OPENED value
	 */
			public void setReOpened (java.lang.Boolean reOpened) {
			this.reOpened = reOpened;
	}



	/**
	 * Return the value associated with the column: SERVICE_CHARGE
	 */

	public java.lang.Double getServiceCharge () {
						return serviceCharge == null ? Double.valueOf(0) : serviceCharge;
		}



	/**
	 * Set the value related to the column: SERVICE_CHARGE
	 * @param serviceCharge the SERVICE_CHARGE value
	 */
			public void setServiceCharge (java.lang.Double serviceCharge) {
			this.serviceCharge = serviceCharge;
	}



	/**
	 * Return the value associated with the column: DELIVERY_CHARGE
	 */

	public java.lang.Double getDeliveryCharge () {
						return deliveryCharge == null ? Double.valueOf(0) : deliveryCharge;
		}



	/**
	 * Set the value related to the column: DELIVERY_CHARGE
	 * @param deliveryCharge the DELIVERY_CHARGE value
	 */
			public void setDeliveryCharge (java.lang.Double deliveryCharge) {
			this.deliveryCharge = deliveryCharge;
	}



	/**
	 * Return the value associated with the column: CUSTOMER_ID
	 */

	public java.lang.String getCustomerId () {
			return customerId;
	}



	/**
	 * Set the value related to the column: CUSTOMER_ID
	 * @param customerId the CUSTOMER_ID value
	 */
			public void setCustomerId (java.lang.String customerId) {
			this.customerId = customerId;
	}



	/**
	 * Return the value associated with the column: DELIVERY_ADDRESS
	 */

	public java.lang.String getDeliveryAddress () {
			return deliveryAddress;
	}



	/**
	 * Set the value related to the column: DELIVERY_ADDRESS
	 * @param deliveryAddress the DELIVERY_ADDRESS value
	 */
			public void setDeliveryAddress (java.lang.String deliveryAddress) {
			this.deliveryAddress = deliveryAddress;
	}



	/**
	 * Return the value associated with the column: CUSTOMER_PICKEUP
	 */

	public java.lang.Boolean isCustomerWillPickup () {
					return customerWillPickup == null ? Boolean.FALSE : customerWillPickup;
		}

	public java.lang.Boolean getCustomerWillPickup () {
				return customerWillPickup == null ? Boolean.FALSE : customerWillPickup;
			}


	/**
	 * Set the value related to the column: CUSTOMER_PICKEUP
	 * @param customerWillPickup the CUSTOMER_PICKEUP value
	 */
			public void setCustomerWillPickup (java.lang.Boolean customerWillPickup) {
			this.customerWillPickup = customerWillPickup;
	}



	/**
	 * Return the value associated with the column: DELIVERY_EXTRA_INFO
	 */

	public java.lang.String getExtraDeliveryInfo () {
			return extraDeliveryInfo;
	}



	/**
	 * Set the value related to the column: DELIVERY_EXTRA_INFO
	 * @param extraDeliveryInfo the DELIVERY_EXTRA_INFO value
	 */
			public void setExtraDeliveryInfo (java.lang.String extraDeliveryInfo) {
			this.extraDeliveryInfo = extraDeliveryInfo;
	}



	/**
	 * Return the value associated with the column: INCLUDE_IN_SALES
	 */

	public java.lang.Boolean isShouldIncludeInSales () {
						return shouldIncludeInSales == null ? Boolean.valueOf(true) : shouldIncludeInSales;
			}

	public java.lang.Boolean getShouldIncludeInSales () {
					return shouldIncludeInSales == null ? Boolean.valueOf(true) : shouldIncludeInSales;
			}


	/**
	 * Set the value related to the column: INCLUDE_IN_SALES
	 * @param shouldIncludeInSales the INCLUDE_IN_SALES value
	 */
			public void setShouldIncludeInSales (java.lang.Boolean shouldIncludeInSales) {
			this.shouldIncludeInSales = shouldIncludeInSales;
	}


	/**
	 * Custom property
	 */
	public static String getShouldIncludeInSalesDefaultValue () {
		return "true";
	}


	/**
	 * Return the value associated with the column: REVENUE_PURPOSE
	 */

	public java.lang.String getRevenue_purpose () {
			return revenue_purpose;
	}



	/**
	 * Set the value related to the column: REVENUE_PURPOSE
	 * @param revenue_purpose the REVENUE_PURPOSE value
	 */
			public void setRevenue_purpose (java.lang.String revenue_purpose) {
			this.revenue_purpose = revenue_purpose;
	}



	/**
	 * Return the value associated with the column: TICKET_SOURCE
	 */

	public java.lang.String getSource () {
			return source;
	}



	/**
	 * Set the value related to the column: TICKET_SOURCE
	 * @param source the TICKET_SOURCE value
	 */
			public void setSource (java.lang.String source) {
			this.source = source;
	}



	/**
	 * Return the value associated with the column: ORDER_TYPE
	 */

	public java.lang.String getOrderTypeId () {
			return orderTypeId;
	}



	/**
	 * Set the value related to the column: ORDER_TYPE
	 * @param orderTypeId the ORDER_TYPE value
	 */
			public void setOrderTypeId (java.lang.String orderTypeId) {
			this.orderTypeId = orderTypeId;
	}



	/**
	 * Return the value associated with the column: INVENTORY_LOCATION
	 */

	public java.lang.String getInventoryLocationId () {
			return inventoryLocationId;
	}



	/**
	 * Set the value related to the column: INVENTORY_LOCATION
	 * @param inventoryLocationId the INVENTORY_LOCATION value
	 */
			public void setInventoryLocationId (java.lang.String inventoryLocationId) {
			this.inventoryLocationId = inventoryLocationId;
	}



	/**
	 * Return the value associated with the column: SHIFT_ID
	 */

	public java.lang.String getShiftId () {
			return shiftId;
	}



	/**
	 * Set the value related to the column: SHIFT_ID
	 * @param shiftId the SHIFT_ID value
	 */
			public void setShiftId (java.lang.String shiftId) {
			this.shiftId = shiftId;
	}



	/**
	 * Return the value associated with the column: CREATED_BY
	 */

	public java.lang.String getCreatedByUserId () {
			return createdByUserId;
	}



	/**
	 * Set the value related to the column: CREATED_BY
	 * @param createdByUserId the CREATED_BY value
	 */
			public void setCreatedByUserId (java.lang.String createdByUserId) {
			this.createdByUserId = createdByUserId;
	}



	/**
	 * Return the value associated with the column: OWNER_ID
	 */

	public java.lang.String getOwnerId () {
			return ownerId;
	}



	/**
	 * Set the value related to the column: OWNER_ID
	 * @param ownerId the OWNER_ID value
	 */
			public void setOwnerId (java.lang.String ownerId) {
			this.ownerId = ownerId;
	}



	/**
	 * Return the value associated with the column: OWNER_TYPE_ID
	 */

	public java.lang.String getOwnerTypeId () {
			return ownerTypeId;
	}



	/**
	 * Set the value related to the column: OWNER_TYPE_ID
	 * @param ownerTypeId the OWNER_TYPE_ID value
	 */
			public void setOwnerTypeId (java.lang.String ownerTypeId) {
			this.ownerTypeId = ownerTypeId;
	}



	/**
	 * Return the value associated with the column: CASHIER_ID
	 */

	public java.lang.String getCashierId () {
			return cashierId;
	}



	/**
	 * Set the value related to the column: CASHIER_ID
	 * @param cashierId the CASHIER_ID value
	 */
			public void setCashierId (java.lang.String cashierId) {
			this.cashierId = cashierId;
	}



	/**
	 * Return the value associated with the column: DRIVER_ID
	 */

	public java.lang.String getAssignedDriverId () {
			return assignedDriverId;
	}



	/**
	 * Set the value related to the column: DRIVER_ID
	 * @param assignedDriverId the DRIVER_ID value
	 */
			public void setAssignedDriverId (java.lang.String assignedDriverId) {
			this.assignedDriverId = assignedDriverId;
	}



	/**
	 * Return the value associated with the column: VOID_BY_USER
	 */

	public java.lang.String getVoidedById () {
			return voidedById;
	}



	/**
	 * Set the value related to the column: VOID_BY_USER
	 * @param voidedById the VOID_BY_USER value
	 */
			public void setVoidedById (java.lang.String voidedById) {
			this.voidedById = voidedById;
	}



	/**
	 * Return the value associated with the column: TERMINAL_ID
	 */

	public java.lang.Integer getTerminalId () {
						return terminalId == null ? Integer.valueOf(0) : terminalId;
		}



	/**
	 * Set the value related to the column: TERMINAL_ID
	 * @param terminalId the TERMINAL_ID value
	 */
			public void setTerminalId (java.lang.Integer terminalId) {
			this.terminalId = terminalId;
	}



	/**
	 * Return the value associated with the column: CLOUD_SYNCED
	 */

	public java.lang.Boolean isCloudSynced () {
					return cloudSynced == null ? Boolean.FALSE : cloudSynced;
		}

	public java.lang.Boolean getCloudSynced () {
				return cloudSynced == null ? Boolean.FALSE : cloudSynced;
			}


	/**
	 * Set the value related to the column: CLOUD_SYNCED
	 * @param cloudSynced the CLOUD_SYNCED value
	 */
			public void setCloudSynced (java.lang.Boolean cloudSynced) {
			this.cloudSynced = cloudSynced;
	}



	/**
	 * Return the value associated with the column: HAS_SYNC_ERROR
	 */

	public java.lang.Boolean isHasSyncError () {
					return hasSyncError == null ? Boolean.FALSE : hasSyncError;
		}

	public java.lang.Boolean getHasSyncError () {
				return hasSyncError == null ? Boolean.FALSE : hasSyncError;
			}


	/**
	 * Set the value related to the column: HAS_SYNC_ERROR
	 * @param hasSyncError the HAS_SYNC_ERROR value
	 */
			public void setHasSyncError (java.lang.Boolean hasSyncError) {
			this.hasSyncError = hasSyncError;
	}



	/**
	 * Return the value associated with the column: TABLE_NUM
	 */

	public java.lang.String getTicketTableNumbers () {
			return ticketTableNumbers;
	}



	/**
	 * Set the value related to the column: TABLE_NUM
	 * @param ticketTableNumbers the TABLE_NUM value
	 */
			public void setTicketTableNumbers (java.lang.String ticketTableNumbers) {
			this.ticketTableNumbers = ticketTableNumbers;
	}



	/**
	 * Return the value associated with the column: DISCOUNTS_PROPERTY
	 */

	public java.lang.String getDiscountsProperty () {
			return discountsProperty;
	}



	/**
	 * Set the value related to the column: DISCOUNTS_PROPERTY
	 * @param discountsProperty the DISCOUNTS_PROPERTY value
	 */
			public void setDiscountsProperty (java.lang.String discountsProperty) {
			this.discountsProperty = discountsProperty;
	}



	/**
	 * Return the value associated with the column: NOTE
	 */

	public java.lang.String getNote () {
			return note;
	}



	/**
	 * Set the value related to the column: NOTE
	 * @param note the NOTE value
	 */
			public void setNote (java.lang.String note) {
			this.note = note;
	}



	/**
	 * Return the value associated with the column: EXTRA_PROPERTIES
	 */

	public java.lang.String getExtraProperties () {
			return extraProperties;
	}



	/**
	 * Set the value related to the column: EXTRA_PROPERTIES
	 * @param extraProperties the EXTRA_PROPERTIES value
	 */
			public void setExtraProperties (java.lang.String extraProperties) {
			this.extraProperties = extraProperties;
	}



	/**
	 * Return the value associated with the column: DELETED
	 */

	public java.lang.Boolean isDeleted () {
						return deleted == null ? Boolean.valueOf(false) : deleted;
			}

	public java.lang.Boolean getDeleted () {
					return deleted == null ? Boolean.valueOf(false) : deleted;
			}


	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
			public void setDeleted (java.lang.Boolean deleted) {
			this.deleted = deleted;
	}


	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue () {
		return "false";
	}


	/**
	 * Return the value associated with the column: GRATUITY_ID
	 */

	public com.floreantpos.model.Gratuity getGratuity () {
			return gratuity;
	}



	/**
	 * Set the value related to the column: GRATUITY_ID
	 * @param gratuity the GRATUITY_ID value
	 */
			public void setGratuity (com.floreantpos.model.Gratuity gratuity) {
			this.gratuity = gratuity;
	}



	/**
	 * Return the value associated with the column: properties
	 */

	public java.util.Map<String, String> getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: properties
	 * @param properties the properties value
	 */
			public void setProperties (java.util.Map<String, String> properties) {
			this.properties = properties;
	}



	/**
	 * Return the value associated with the column: ticketItems
	 */

	public java.util.List<com.floreantpos.model.TicketItem> getTicketItems () {
			return ticketItems;
	}



	/**
	 * Set the value related to the column: ticketItems
	 * @param ticketItems the ticketItems value
	 */
			public void setTicketItems (java.util.List<com.floreantpos.model.TicketItem> ticketItems) {
			this.ticketItems = ticketItems;
	}

	public void addToticketItems (com.floreantpos.model.TicketItem ticketItem) {
		if (null == getTicketItems()) setTicketItems(new java.util.ArrayList<com.floreantpos.model.TicketItem>());
		getTicketItems().add(ticketItem);
	}



	/**
	 * Return the value associated with the column: transactions
	 */

	public java.util.Set<com.floreantpos.model.PosTransaction> getTransactions () {
			return transactions;
	}



	/**
	 * Set the value related to the column: transactions
	 * @param transactions the transactions value
	 */
			public void setTransactions (java.util.Set<com.floreantpos.model.PosTransaction> transactions) {
			this.transactions = transactions;
	}

	public void addTotransactions (com.floreantpos.model.PosTransaction posTransaction) {
		if (null == getTransactions()) setTransactions(new java.util.TreeSet<com.floreantpos.model.PosTransaction>());
		getTransactions().add(posTransaction);
	}





	public boolean equals (Object obj) {
		if (null == obj) return false;//abcd
		if (!(obj instanceof com.floreantpos.model.Ticket)) return false;
		else {
			com.floreantpos.model.Ticket ticket = (com.floreantpos.model.Ticket) obj;
			if (null != this.getId() && null != ticket.getId()) {
				if (!this.getId().equals(ticket.getId())) {
					return false;
				}
			}
			else {
				return false;
			}
			if (null != this.getOutletId() && null != ticket.getOutletId()) {
				if (!this.getOutletId().equals(ticket.getOutletId())) {
					return false;
				}
			}
			else {
				return false;
			}
			return true;
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			StringBuilder sb = new StringBuilder();
			if (null != this.getId()) {
				sb.append(this.getId().hashCode());
				sb.append(":");
			}
			else {
				return super.hashCode();
			}
			if (null != this.getOutletId()) {
				sb.append(this.getOutletId().hashCode());
				sb.append(":");
			}
			else {
				return super.hashCode();
			}
			this.hashCode = sb.toString().hashCode();
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}