package com.floreantpos.webservice;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.routines.EmailValidator;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.hibernate.Hibernate;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.constants.RestConstants;
import com.floreantpos.model.ActionHistory;
import com.floreantpos.model.Address;
import com.floreantpos.model.AttendenceHistory;
import com.floreantpos.model.Attribute;
import com.floreantpos.model.AttributeGroup;
import com.floreantpos.model.BookingInfo;
import com.floreantpos.model.CashBreakdown;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.CookingInstruction;
import com.floreantpos.model.Course;
import com.floreantpos.model.CronJob;
import com.floreantpos.model.Currency;
import com.floreantpos.model.CustomPayment;
import com.floreantpos.model.Customer;
import com.floreantpos.model.CustomerGroup;
import com.floreantpos.model.DataSyncInfo;
import com.floreantpos.model.DeclaredTips;
import com.floreantpos.model.DeliveryAddress;
import com.floreantpos.model.DeliveryCharge;
import com.floreantpos.model.Department;
import com.floreantpos.model.Discount;
import com.floreantpos.model.GiftCard;
import com.floreantpos.model.Gratuity;
import com.floreantpos.model.GratuityPaymentHistory;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.InventoryClosingBalance;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryStock;
import com.floreantpos.model.InventoryStockUnit;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.InventoryUnitGroup;
import com.floreantpos.model.InventoryVendor;
import com.floreantpos.model.InventoryVendorItems;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemInventoryStatus;
import com.floreantpos.model.MenuItemModifierPage;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuItemSize;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.MenuPage;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.PackagingUnit;
import com.floreantpos.model.PizzaCrust;
import com.floreantpos.model.PizzaPrice;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.PriceRule;
import com.floreantpos.model.PriceShift;
import com.floreantpos.model.PriceTable;
import com.floreantpos.model.PrinterGroup;
import com.floreantpos.model.PurchaseOrder;
import com.floreantpos.model.Recepie;
import com.floreantpos.model.ReportGroup;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.Shift;
import com.floreantpos.model.ShopFloor;
import com.floreantpos.model.ShopFloorTemplate;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.ShopTableStatus;
import com.floreantpos.model.ShopTableType;
import com.floreantpos.model.SlideShowImage;
import com.floreantpos.model.StockCount;
import com.floreantpos.model.Store;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.StoreSessionControl;
import com.floreantpos.model.Tax;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TerminalType;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketDiscount;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemDiscount;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.UserType;
import com.floreantpos.model.VirtualPrinter;
import com.floreantpos.model.VoidItem;
import com.floreantpos.model.VoidReason;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.InventoryTransactionDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.services.report.CashDrawerReportService;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.XMLTransientUtil;
import com.google.gson.GsonBuilder;
import com.orocube.common.util.TerminalUtil;
import com.orocube.rest.service.PosResponse;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;

public class PosWebService {

	public PosResponse checkConnection() throws Exception {
		Store store = StoreDAO.getRestaurant();
		Terminal terminal = DataProvider.get().getCurrentTerminal();
		String serviceURL = store.getProperty(RestConstants.WEB_SERVICE_URL);
		String userName = store.getProperty(RestConstants.WEB_LOGIN_USER_NAME);
		String password = store.getProperty(RestConstants.WEB_LOGIN_USER_PASSWORD);
		return checkConnection(serviceURL, userName, password, String.valueOf(terminal.getId()));
	}

	public PosResponse checkConnection(String url, String adminUserName, String adminPassword, String terminalId) throws Exception {
		return login(url, adminUserName, adminPassword, terminalId);
	}

	@SuppressWarnings({ "unchecked", "rawtypes" })
	public PosResponse login(String url, String adminUserName, String adminPassword, String terminalId) throws Exception {
		try {
			Client client = createWebClient();
			MultivaluedMap map = new MultivaluedMapImpl();
			map.add(RestConstants.DEVICE_ID, TerminalUtil.getSystemUID());
			map.add(RestConstants.USER_EMAIL, adminUserName);
			map.add(RestConstants.PASSWORD, adminPassword);
			map.add(RestConstants.TERMINAL_ID, terminalId);

			WebResource webResource = client.resource(url + RestConstants.URL_SERVICE_STORE_LOGIN);
			ClientResponse response = webResource.accept(MediaType.APPLICATION_JSON).post(ClientResponse.class, map);
			if (response.getStatus() != 200) {
				throw new RuntimeException(Messages.getString("PosWebService.72") + response.getStatus()); //$NON-NLS-1$
			}
			PosResponse posResponse = createResponseFromEntity(response);
			return posResponse;

		} catch (Exception ex) {
			throw ex;
		}
	}

	@SuppressWarnings({ "unchecked", "rawtypes" })
	public PosResponse register(String url, String storeName, String adminUserName, String adminPassword) throws Exception {
		try {
			if (StringUtils.isEmpty(url)) {
				throw new PosException(Messages.getString("CloudLoginPanel.0")); //$NON-NLS-1$
			}
			if (StringUtils.isEmpty(adminUserName)) {
				throw new PosException(Messages.getString("CloudLoginPanel.1")); //$NON-NLS-1$
			}
			if (!EmailValidator.getInstance().isValid(adminUserName)) {
				throw new PosException(Messages.getString("CloudLoginPanel.3")); //$NON-NLS-1$
			}
			if (StringUtils.isEmpty(adminPassword)) {
				throw new PosException(Messages.getString("CloudLoginPanel.4")); //$NON-NLS-1$
			}
			Client client = createWebClient();
			MultivaluedMap map = new MultivaluedMapImpl();
			map.add(RestConstants.STORE_NAME, storeName);
			map.add(RestConstants.USER_EMAIL, adminUserName);
			map.add(RestConstants.PASSWORD, adminPassword);
			map.add(RestConstants.CREATE_SAMPLE_DATA, "false");

			WebResource webResource = client.resource(url + RestConstants.URL_SERVICE_STORE_REGISTER);
			ClientResponse response = webResource.accept(MediaType.APPLICATION_JSON).post(ClientResponse.class, map);
			if (response.getStatus() != 200) {
				throw new RuntimeException(Messages.getString("PosWebService.68") + response.getStatus()); //$NON-NLS-1$
			}
			PosResponse posResponse = createResponseFromEntity(response);
			return posResponse;
		} catch (Exception ex) {
			throw ex;
		}
	}

	public boolean isRemoteAccountEmty(String service_url, String userName, String password, String customerId, String storeId) throws Exception {
		service_url += RestConstants.URL_SERVICE_DATA_STORE + storeId;
		List<NameValuePair> map = new ArrayList<NameValuePair>();
		map.add(new BasicNameValuePair(RestConstants.DEVICE_ID, TerminalUtil.getSystemUID())); //$NON-NLS-1$
		map.add(new BasicNameValuePair(RestConstants.CUSTOMER_ID, customerId)); //$NON-NLS-1$
		map.add(new BasicNameValuePair(RestConstants.USER_EMAIL, userName)); //$NON-NLS-1$
		map.add(new BasicNameValuePair(RestConstants.PASSWORD, password)); //$NON-NLS-1$
		ClientResponse response = doGetRequest("/isEmpty", createWebClient(), service_url, map); //$NON-NLS-1$
		return response.getEntity(Boolean.class);
	}

	@SuppressWarnings("rawtypes")
	public List getDataList(String entity) throws Exception {
		ClientResponse response = doGetRequest("/entity", null); //$NON-NLS-1$
		return response.getEntity(new GenericType<List>() {
		});
	}

	public List<OrderType> getOrderTypes() throws Exception {
		ClientResponse response = doGetRequest("/ordertype", getLastUpdateTime(OrderType.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<OrderType>>() {
		});
	}

	public List<Store> getAllStores() throws Exception {
		ClientResponse response = doGetRequest("/store", getLastUpdateTime(Store.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<Store>>() {
		});
	}

	public List<ImageResource> getImageResources() throws Exception {
		ClientResponse response = doGetRequest("/imageResources", getLastUpdateTime(ImageResource.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<ImageResource>>() {
		});
	}

	public List<Outlet> getOutlets() throws Exception {
		ClientResponse response = doGetRequest("/outlet", getLastUpdateTime(Outlet.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<Outlet>>() {
		});
	}

	public List<Customer> getCustomers() throws Exception {
		ClientResponse response = doGetRequest("/customer", getLastUpdateTime(Customer.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<Customer>>() {
		});
	}

	public List<SalesArea> getSalesArea() throws Exception {
		ClientResponse response = doGetRequest("/salesarea", getLastUpdateTime(SalesArea.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<SalesArea>>() {
		});
	}

	public List<CronJob> getCronJob() throws Exception {
		ClientResponse response = doGetRequest("/cronJob", getLastUpdateTime(CronJob.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<CronJob>>() {
		});
	}

	public List<ReportGroup> getReportGroup() throws Exception {
		ClientResponse response = doGetRequest("/reportGroup", getLastUpdateTime(ReportGroup.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<ReportGroup>>() {
		});
	}

	public List<PrinterGroup> getPrinterGroup() throws Exception {
		ClientResponse response = doGetRequest("/printerGroup", getLastUpdateTime(PrinterGroup.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<PrinterGroup>>() {
		});
	}

	public List<VirtualPrinter> getVirtualPrinter() throws Exception {
		ClientResponse response = doGetRequest("/printer", getLastUpdateTime(VirtualPrinter.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<VirtualPrinter>>() {
		});
	}

	public List<VoidReason> getVoidReason() throws Exception {
		ClientResponse response = doGetRequest("/voidReason", getLastUpdateTime(VoidReason.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<VoidReason>>() {
		});
	}

	public List<ShopTableType> getShopTableType() throws Exception {
		ClientResponse response = doGetRequest("/shopTableType", getLastUpdateTime(ShopTableType.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<ShopTableType>>() {
		});
	}

	public List<SlideShowImage> getSlideShowImage() throws Exception {
		ClientResponse response = doGetRequest("/slideShowImage", getLastUpdateTime(SlideShowImage.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<SlideShowImage>>() {
		});
	}

	public List<ActionHistory> getActionHistory() throws Exception {
		ClientResponse response = doGetRequest("/actionHistory", getLastUpdateTime(ActionHistory.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<ActionHistory>>() {
		});
	}

	public List<VoidItem> getVoidItem() throws Exception {
		ClientResponse response = doGetRequest("/voidItem", getLastUpdateTime(VoidItem.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<VoidItem>>() {
		});
	}

	public List<Recepie> getRecipe() throws Exception {
		ClientResponse response = doGetRequest("/recipe", getLastUpdateTime(Recepie.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<Recepie>>() {
		});
	}

	public List<PurchaseOrder> getPurchaseOrder() throws Exception {
		ClientResponse response = doGetRequest("/purchaseOrder", getLastUpdateTime(PurchaseOrder.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<PurchaseOrder>>() {
		});
	}

	public List<StockCount> getStockCount() throws Exception {
		ClientResponse response = doGetRequest("/stockCount", getLastUpdateTime(StockCount.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<StockCount>>() {
		});
	}

	public List<ShopFloorTemplate> getShopFloorTemplate() throws Exception {
		ClientResponse response = doGetRequest("/shopFloorTemplate", getLastUpdateTime(ShopFloorTemplate.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<ShopFloorTemplate>>() {
		});
	}

	public List<Department> getDepartments() throws Exception {
		ClientResponse response = doGetRequest("/department", getLastUpdateTime(Department.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<Department>>() {
		});
	}

	public List<TerminalType> getTerminalTypes() throws Exception {
		ClientResponse response = doGetRequest("/terminaltype", getLastUpdateTime(TerminalType.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<TerminalType>>() {
		});
	}

	public List<Terminal> getTerminals() throws Exception {
		ClientResponse response = doGetRequest("/terminal", getLastUpdateTime(Terminal.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<Terminal>>() {
		});
	}

	public List<Currency> getCurrencies() throws Exception {

		ClientResponse response = doGetRequest("/currency", getLastUpdateTime(Currency.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<Currency>>() {
		});
	}

	public List<UserPermission> getUserPermissions() throws Exception {
		ClientResponse response = doGetRequest("/userpermission", getLastUpdateTime(UserPermission.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<UserPermission>>() {
		});
	}

	public List<UserType> getUserTypes() throws Exception {
		ClientResponse response = doGetRequest("/usertype", getLastUpdateTime(UserType.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<UserType>>() {
		});
	}

	public List<User> getUsers() throws Exception {
		ClientResponse response = doGetRequest("/user", getLastUpdateTime(User.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<User>>() {
		});
	}

	public List<Tax> getTaxes() throws Exception {
		ClientResponse response = doGetRequest("/tax", getLastUpdateTime(Tax.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<Tax>>() {
		});
	}

	public List<TaxGroup> getTaxGroups() throws Exception {
		ClientResponse response = doGetRequest("/taxgroup", getLastUpdateTime(TaxGroup.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<TaxGroup>>() {
		});
	}

	public List<MenuCategory> getMenuCategories() throws Exception {
		ClientResponse response = doGetRequest("/MenuCategory", getLastUpdateTime(MenuCategory.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<MenuCategory>>() {
		});
	}

	public List<MenuGroup> getMenuGroups() throws Exception {
		ClientResponse response = doGetRequest("/MenuGroup", getLastUpdateTime(MenuGroup.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<MenuGroup>>() {
		});
	}

	public List<MenuItem> getMenuItems() throws Exception {
		ClientResponse response = doGetRequest("/MenuItem", getLastUpdateTime(MenuItem.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<MenuItem>>() {
		});
	}

	public List<MenuItemSize> getMenuItemSize() throws Exception {
		ClientResponse response = doGetRequest("/MenuItemSize", getLastUpdateTime(MenuItemSize.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<MenuItemSize>>() {
		});
	}

	public List<ModifierGroup> getModifierGroups() throws Exception {
		ClientResponse response = doGetRequest("/ModifierGroup", getLastUpdateTime(ModifierGroup.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<ModifierGroup>>() {
		});
	}

	public List<MenuModifier> getMenuModifiers() throws Exception {
		ClientResponse response = doGetRequest("/MenuModifier", getLastUpdateTime(MenuModifier.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<MenuModifier>>() {
		});
	}

	public List<PriceRule> getPriceRules() throws Exception {
		ClientResponse response = doGetRequest("/PriceRule", getLastUpdateTime(PriceRule.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<PriceRule>>() {
		});
	}

	public List<PriceTable> getPriceList() throws Exception {
		ClientResponse response = doGetRequest("/PriceTable", getLastUpdateTime(PriceTable.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<PriceTable>>() {
		});
	}

	public List<PriceShift> getPriceShift() throws Exception {
		ClientResponse response = doGetRequest("/PriceShift", getLastUpdateTime(PriceShift.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<PriceShift>>() {
		});
	}

	public List<InventoryVendor> getInventoryVendors() throws Exception {
		ClientResponse response = doGetRequest("/inventoryVendor", getLastUpdateTime(InventoryVendor.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<InventoryVendor>>() {
		});
	}

	public List<InventoryVendorItems> getInventoryVendorItems() throws Exception {
		ClientResponse response = doGetRequest("/inventoryVendorItem", getLastUpdateTime(InventoryVendorItems.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<InventoryVendorItems>>() {
		});
	}

	public List<InventoryLocation> getInventoryLocations() throws Exception {
		ClientResponse response = doGetRequest("/inventorylocation", getLastUpdateTime(InventoryLocation.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<InventoryLocation>>() {
		});
	}

	public List<InventoryTransaction> getInventoryTransactions() throws Exception {
		ClientResponse response = doGetRequest("/inventoryTransaction", getLastUpdateTime(InventoryTransaction.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<InventoryTransaction>>() {
		});
	}

	public List<MenuItemInventoryStatus> getMenuItemInvStatus() throws Exception {
		ClientResponse response = doGetRequest("/menuItemInvStatus", getLastUpdateTime(MenuItemInventoryStatus.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<MenuItemInventoryStatus>>() {
		});
	}

	public List<InventoryStockUnit> getInventoryStockUnits() throws Exception {
		ClientResponse response = doGetRequest("/inventoryStockUnits", getLastUpdateTime(InventoryStockUnit.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<InventoryStockUnit>>() {
		});
	}

	public List<InventoryStock> getInventoryStocks() throws Exception {
		ClientResponse response = doGetRequest("/inventoryStock", getLastUpdateTime(InventoryStock.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<InventoryStock>>() {
		});
	}

	public List<InventoryUnitGroup> getAllInventoryUnitGroups() throws Exception {
		ClientResponse response = doGetRequest("/inventoryUnitGroup", getLastUpdateTime(InventoryUnitGroup.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<InventoryUnitGroup>>() {
		});
	}

	public List<InventoryUnit> getAllInventoryUnits() throws Exception {
		ClientResponse response = doGetRequest("/inventoryUnit", getLastUpdateTime(InventoryUnit.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<InventoryUnit>>() {
		});
	}

	public List<PackagingUnit> getAllPackagingUnits() throws Exception {
		ClientResponse response = doGetRequest("/packagingUnit", getLastUpdateTime(PackagingUnit.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<PackagingUnit>>() {
		});
	}

	public List<InventoryClosingBalance> getInventoryClosingBalance() throws Exception {
		ClientResponse response = doGetRequest("/inventoryClosingBlance", getLastUpdateTime(InventoryClosingBalance.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<InventoryClosingBalance>>() {
		});
	}

	public List<ShopFloor> getShopFloors() throws Exception {
		ClientResponse response = doGetRequest("/shopFloors", getLastUpdateTime(ShopFloor.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<ShopFloor>>() {
		});
	}

	public List<ShopTable> getShopTables() throws Exception {
		ClientResponse response = doGetRequest("/shopTables", getLastUpdateTime(ShopTable.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<ShopTable>>() {
		});
	}

	public List<BookingInfo> getBookingInfos() throws Exception {
		ClientResponse response = doGetRequest("/bookingInfos", getLastUpdateTime(BookingInfo.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<BookingInfo>>() {
		});
	}

	public List<ShopTableStatus> getAllShopTableStatus() throws Exception {
		ClientResponse response = doGetRequest("/shopTableStatus", getLastUpdateTime(ShopTableStatus.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<ShopTableStatus>>() {
		});
	}

	public List<CashBreakdown> getAllCashBreakdown() throws Exception {
		ClientResponse response = doGetRequest("/cashBreakdown", getLastUpdateTime(CashBreakdown.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<CashBreakdown>>() {
		});
	}

	public List<StoreSession> getAllStoreSession() throws Exception {
		ClientResponse response = doGetRequest("/storeSession", getLastUpdateTime(StoreSession.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<StoreSession>>() {
		});
	}

	public List<StoreSessionControl> getAllStoreSessionControls() throws Exception {
		ClientResponse response = doGetRequest("/storeSessionControl", getLastUpdateTime(StoreSessionControl.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<StoreSessionControl>>() {
		});
	}

	public List<CashDrawer> getAllCashDrawer() throws Exception {
		ClientResponse response = doGetRequest("/allCashDrawer", getLastUpdateTime(CashDrawer.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<CashDrawer>>() {
		});
	}

	public List<Ticket> getAllTickets() throws Exception {
		ClientResponse response = doGetRequest("/ticket", getLastUpdateTime(Ticket.class)); //$NON-NLS-1$
		GenericType<List<Ticket>> genericEntity = new GenericType<List<Ticket>>() {
		};
		return response.getEntity(genericEntity);
	}

	public List<Shift> getAllShifts() throws Exception {
		ClientResponse response = doGetRequest("/shift", getLastUpdateTime(Shift.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<Shift>>() {
		});
	}

	public List<Address> getAllAddress() throws Exception {
		ClientResponse response = doGetRequest("/address", getLastUpdateTime(Address.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<Address>>() {
		});
	}

	public List<AttendenceHistory> getAllAttendenceHistories() throws Exception {
		ClientResponse response = doGetRequest("/attendencehistory", getLastUpdateTime(AttendenceHistory.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<AttendenceHistory>>() {
		});
	}

	public List<AttributeGroup> getAttributeGroups() throws Exception {
		ClientResponse response = doGetRequest("/attributegroup", getLastUpdateTime(AttributeGroup.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<AttributeGroup>>() {
		});
	}

	public List<Attribute> getAttributes() throws Exception {
		ClientResponse response = doGetRequest("/attribute", getLastUpdateTime(Attribute.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<Attribute>>() {
		});
	}

	public List<CookingInstruction> getCookingInstructions() throws Exception {
		ClientResponse response = doGetRequest("/cookingInstruction", getLastUpdateTime(CookingInstruction.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<CookingInstruction>>() {
		});
	}

	public List<Course> getCourses() throws Exception {
		ClientResponse response = doGetRequest("/courses", getLastUpdateTime(Course.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<Course>>() {
		});
	}

	public List<CustomerGroup> getCustomerGroup() throws Exception {
		ClientResponse response = doGetRequest("/CustomerGroup", getLastUpdateTime(CustomerGroup.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<CustomerGroup>>() {
		});
	}

	public List<CustomPayment> getCustomPayment() throws Exception {
		ClientResponse response = doGetRequest("/CustomPayment", getLastUpdateTime(CustomPayment.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<CustomPayment>>() {
		});
	}

	public List<DeclaredTips> getDeclaredTips() throws Exception {
		ClientResponse response = doGetRequest("/DeclaredTips", getLastUpdateTime(DeclaredTips.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<DeclaredTips>>() {
		});
	}

	public List<DeliveryAddress> getDeliveryAddress() throws Exception {
		ClientResponse response = doGetRequest("/DeliveryAddress", getLastUpdateTime(DeliveryAddress.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<DeliveryAddress>>() {
		});
	}

	public List<DeliveryCharge> getDeliveryCharge() throws Exception {
		ClientResponse response = doGetRequest("/DeliveryCharge", getLastUpdateTime(DeliveryCharge.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<DeliveryCharge>>() {
		});
	}

	public List<Discount> getDiscount() throws Exception {
		ClientResponse response = doGetRequest("/Discount", getLastUpdateTime(Discount.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<Discount>>() {
		});
	}

	public List<GiftCard> getGiftCard() throws Exception {
		ClientResponse response = doGetRequest("/GiftCard", getLastUpdateTime(GiftCard.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<GiftCard>>() {
		});
	}

	public List<Gratuity> getGratuity() throws Exception {
		ClientResponse response = doGetRequest("/Gratuity", getLastUpdateTime(Gratuity.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<Gratuity>>() {
		});
	}

	public List<GratuityPaymentHistory> getGratuityPaymentHistory() throws Exception {
		ClientResponse response = doGetRequest("/GratuityPaymentHistory", getLastUpdateTime(GratuityPaymentHistory.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<GratuityPaymentHistory>>() {
		});
	}

	public List<Multiplier> getMultiplier() throws Exception {
		ClientResponse response = doGetRequest("/Multiplier", getLastUpdateTime(Multiplier.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<Multiplier>>() {
		});
	}

	public List<MenuItemModifierSpec> getMenuItemModifierSpec() throws Exception {
		ClientResponse response = doGetRequest("/MenuItemModifierSpec", getLastUpdateTime(MenuItemModifierSpec.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<MenuItemModifierSpec>>() {
		});
	}

	public List<MenuItemModifierPage> getMenuItemModifierPage() throws Exception {
		ClientResponse response = doGetRequest("/MenuItemModifierPage", getLastUpdateTime(MenuItemModifierPage.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<MenuItemModifierPage>>() {
		});
	}

	public List<PizzaCrust> getPizzaCrust() throws Exception {
		ClientResponse response = doGetRequest("/PizzaCrust", getLastUpdateTime(PizzaCrust.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<PizzaCrust>>() {
		});
	}

	public List<PizzaPrice> getPizzaPrice() throws Exception {
		ClientResponse response = doGetRequest("/PizzaPrice", getLastUpdateTime(PizzaPrice.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<PizzaPrice>>() {
		});
	}

	public List<MenuPage> getMenuPage() throws Exception {
		ClientResponse response = doGetRequest("/MenuPage", getLastUpdateTime(MenuPage.class)); //$NON-NLS-1$
		return response.getEntity(new GenericType<List<MenuPage>>() {
		});
	}

	private String getServiceUrl() {
		return Store.getWebServiceUrl();
	}

	private ClientResponse doGetRequest(String requestPath, java.util.Date date) throws Exception {
		return doGetRequest(requestPath, createWebClient(), getConnectionProperties(date));
	}

	private ClientResponse doGetRequest(String requestPath, Client client, List<NameValuePair> map) throws Exception {
		return doGetRequest(requestPath, client, getServiceUrl(), map);
	}

	private ClientResponse doGetRequest(String requestPath, Client client, String serviceUrl, List<NameValuePair> map) throws Exception {
		String paramString = URLEncodedUtils.format(map, "utf-8"); //$NON-NLS-1$
		WebResource webResource = client.resource(serviceUrl + requestPath + "?" + paramString); //$NON-NLS-1$
		ClientResponse response = webResource.accept(MediaType.APPLICATION_JSON).get(ClientResponse.class);
		if (response.getStatus() != 200) {
			throw new RuntimeException(Messages.getString("PosWebService.72") + response.getStatus()); //$NON-NLS-1$
		}
		return response;
	}

	private PosResponse createResponseFromEntity(ClientResponse response) {
		String jsonResponse = response.getEntity(String.class);
		PosResponse posResponse = null;
		if (StringUtils.isNotEmpty(jsonResponse)) {
			posResponse = (PosResponse) new GsonBuilder().create().fromJson(jsonResponse, PosResponse.class);
		}
		return posResponse;
	}

	public boolean isConnected() {
		try {
			PosResponse posResponse = checkConnection();
			return posResponse != null & posResponse.getResponseCode() == 200;
		} catch (Exception e) {
			PosLog.error(getClass(), e.getMessage());
		}
		return false;
	}

	public boolean isCloudConfigured() {
		try {
			Store store = StoreDAO.getRestaurant();
			String serviceURL = store.getProperty(RestConstants.WEB_SERVICE_URL);
			String userName = store.getProperty(RestConstants.WEB_LOGIN_USER_NAME);
			String password = store.getProperty(RestConstants.WEB_LOGIN_USER_PASSWORD);
			if (StringUtils.isNotEmpty(serviceURL) && StringUtils.isNotEmpty(userName) && StringUtils.isNotEmpty(password)) {
				return true;
			}
		} catch (Exception e) {
			PosLog.error(getClass(), e.getMessage());
		}
		return false;
	}

	private Client createWebClient() {
		Client client = Client.create();
		client.getProperties();
		return client;
	}

	private List<NameValuePair> getConnectionProperties(java.util.Date lastUpdateTime) {
		Store store = StoreDAO.getRestaurant();
		List<NameValuePair> map = new ArrayList<NameValuePair>();
		map.add(new BasicNameValuePair(RestConstants.DEVICE_ID, TerminalUtil.getSystemUID())); //$NON-NLS-1$
		map.add(new BasicNameValuePair(RestConstants.CUSTOMER_ID, store.getProperty(RestConstants.WEB_LOGIN_CUSTOMER_ID))); //$NON-NLS-1$
		map.add(new BasicNameValuePair(RestConstants.USER_EMAIL, store.getProperty(RestConstants.WEB_LOGIN_USER_NAME))); //$NON-NLS-1$
		map.add(new BasicNameValuePair(RestConstants.PASSWORD, store.getProperty(RestConstants.WEB_LOGIN_USER_PASSWORD))); //$NON-NLS-1$
		if (lastUpdateTime != null) {
			map.add(new BasicNameValuePair(RestConstants.LAST_UPDATE_TIME, String.valueOf(lastUpdateTime.getTime()))); //$NON-NLS-1$
		}
		return map;
	}

	/*
	 * 
	 * upload data
	 * 
	 */

	@SuppressWarnings("unchecked")
	public void uploadStoreSessionData() throws Exception {
		GenericDAO instance = GenericDAO.getInstance();
		List<StoreSession> storeSessionList = instance.findAllUnSyncItem(StoreSession.class);
		List<String> storeSessionIds = new ArrayList<String>();
		if (storeSessionList != null) {
			for (StoreSession storeSession : storeSessionList) {
				if (storeSession.getCloseTime() != null) {
					storeSessionIds.add(storeSession.getId());
				}

				uploadStoreSessionData(storeSession);
			}
		}
		instance.updateItemsLastSyncTime(storeSessionIds, StoreSession.REF);
	}

	public void uploadStoreSessionData(StoreSession storeSessionOrgin) throws Exception {
		StoreSession storeSession = new StoreSession();

		PropertyUtils.copyProperties(storeSession, storeSessionOrgin);
		storeSession.setOutletId(DataProvider.get().getStore().getDefaultOutletId());
		doSendStoreSessionToCloud(Arrays.asList(storeSession));
		uploadSessionCashDrawers(storeSession);

		try {
			uploadTickets(storeSession);
		} catch (Exception e) {
			String message = Messages.getString("PosWebService.89"); //$NON-NLS-1$
			POSMessageDialog.showError(POSUtil.getFocusedWindow(), message, e);
		}
	}

	private void doSendStoreSessionToCloud(List<StoreSession> sessions) {
		try {
			GenericEntity<List<StoreSession>> entity = new GenericEntity<List<StoreSession>>(sessions) {
			};
			uploadData(entity, "storesession"); //$NON-NLS-1$

		} catch (Exception e) {
			String message = Messages.getString("PosWebService.91"); //$NON-NLS-1$
			POSMessageDialog.showError(POSUtil.getFocusedWindow(), message, e);
		}
	}

	public void uploadTerminal() {
		List<Terminal> terminals = TerminalDAO.getInstance().findAll();
		if (terminals != null && !terminals.isEmpty()) {
			for (Terminal terminal : terminals) {
				makeXMLTransient(terminal);
			}
			try {
				uploadData(new GenericEntity<List<Terminal>>(terminals) {
				}, "terminal"); //$NON-NLS-1$
			} catch (Exception e) {
				String message = Messages.getString("PosWebService.93"); //$NON-NLS-1$
				POSMessageDialog.showError(POSUtil.getFocusedWindow(), message, e);
			}
		}

	}

	private void uploadSessionCashDrawers(StoreSession storeSession) throws Exception {
		List<String> ids = new ArrayList<String>();
		List<CashDrawer> cashDrawers = CashDrawerDAO.getInstance().findByUnSyncStoreOperationData(storeSession);
		if (cashDrawers != null && !cashDrawers.isEmpty()) {
			for (CashDrawer cashDrawer : cashDrawers) {

				CashDrawer drawer = new CashDrawer();
				PropertyUtils.copyProperties(drawer, cashDrawer);

				if (cashDrawer.getReportTime() != null) {
					ids.add(drawer.getId());
				}
				if (cashDrawer.getStartTime() != null) {
					CashDrawerReportService reportService2 = new CashDrawerReportService(cashDrawer);
					reportService2.populateReport();
				}
			}
		}
	}

	private void makeXMLTransient(Terminal terminal) {
		if (terminal == null)
			return;
		terminal.setCurrentCashDrawer(null);
		terminal.setAssignedUser(null);
	}

	public List<Ticket> initializeTicket(List<Ticket> ticketList) {
		if (ticketList == null) {
			return null;
		}
		for (Iterator<Ticket> iterator = ticketList.iterator(); iterator.hasNext();) {
			Ticket ticket = (Ticket) iterator.next();
			TicketDAO.getInstance().loadFullTicket(ticket);
			XMLTransientUtil.makeXMLTransient(ticket);
		}

		return ticketList;
	}

	@SuppressWarnings("unchecked")
	private void uploadTickets(StoreSession storeSession) throws Exception {
		TicketDAO ticketDAOInstance = TicketDAO.getInstance();
		List<Ticket> tickets = new ArrayList<>();
		List<Ticket> ticketOrgin = ticketDAOInstance.findAllUnSyncTicket(storeSession);
		Store thisStore = DataProvider.get().getStore();
		String outletId = thisStore.getDefaultOutletId();

		if (ticketOrgin != null && !ticketOrgin.isEmpty()) {
			for (Ticket ticket : ticketOrgin) {
				ticketDAOInstance.loadFullTicket(ticket);
				makeXMLTransient(ticket);
				ticket.setOutletId(outletId);
				tickets.add(ticket);
			}
		}
		doSendTicketToCloud(tickets);
	}

	public void doSendTicketToCloud(List<Ticket> tickets) throws Exception {
		GenericEntity<List<Ticket>> ticketEntity = new GenericEntity<List<Ticket>>(tickets) {
		};
		uploadData(ticketEntity, "tickets"); //$NON-NLS-1$
		List<String> ticketIds = new ArrayList<String>();
		for (Ticket ticket : tickets) {
			ticketIds.add(ticket.getId());
		}
		GenericDAO.getInstance().updateItemsLastSyncTime(ticketIds, Ticket.REF);
	}

	private void makeXMLTransient(Ticket ticket) {
		ticket.setProperties(null);
		ticket.setDepartment(null);

		List<TicketDiscount> discountList = ticket.getDiscounts();
		if (discountList != null && discountList.size() > 0) {
			for (TicketDiscount ticketDiscount : discountList) {
				makeXMLTransient(ticketDiscount);
			}
		}

		OrderType orderType = ticket.getOrderType();
		if (orderType != null) {
			makeXMLTransient(orderType);
		}

		List<TicketItem> ticketItemList = ticket.getTicketItems();
		if (ticketItemList != null) {
			Hibernate.initialize(ticketItemList);
			for (TicketItem ticketItem : ticketItemList) {
				makeXMLTransient(ticketItem);
			}
		}
		ArrayList<PosTransaction> transactions = new ArrayList<>(ticket.getTransactions());
		for (PosTransaction posTransaction : transactions) {
			String ticketId = posTransaction.getTicketId();
			posTransaction.setTicket(null);
			posTransaction.setTicketId(ticketId);
			posTransaction.setProperties(null);
		}

	}

	private void makeXMLTransient(TicketDiscount ticketDiscount) {
		ticketDiscount.setTicket(null);
	}

	private void makeXMLTransient(TicketItem ticketItem) {
		ticketItem.setTicket(null);
		List<TicketItemModifier> ticketItemModifiers = ticketItem.getTicketItemModifiers();
		if (ticketItemModifiers != null) {
			for (TicketItemModifier ticketItemModifier : ticketItemModifiers) {
				makeXMLTransient(ticketItemModifier);
			}
		}

		Boolean isComboItem = ticketItem.isComboItem();
		if (isComboItem) {
			List<TicketItem> comboTicketItems = ticketItem.getComboItems();
			if (comboTicketItems != null) {
				for (TicketItem cTicketItem : comboTicketItems) {
					makeXMLTransient(cTicketItem);
				}
			}
		}

		TicketItemModifier sizeModifier = ticketItem.getSizeModifier();
		if (sizeModifier != null) {
			makeXMLTransient(sizeModifier);
		}

		String menuItemId = ticketItem.getMenuItemId();
		ticketItem.setMenuItem(null);
		ticketItem.setMenuItemId(menuItemId);

		List<TicketItemDiscount> discountList = ticketItem.getDiscounts();
		if (discountList != null && discountList.size() > 0) {
			for (TicketItemDiscount ticketDiscount : discountList) {
				makeXMLTransient(ticketDiscount);
			}
		}
	}

	private void makeXMLTransient(TicketItemModifier ticketItemModifier) {
		ticketItemModifier.setTicketItem(null);
	}

	private void makeXMLTransient(TicketItemDiscount ticketDiscount) {
		ticketDiscount.setTicketItem(null);
	}

	private void makeXMLTransient(OrderType orderType) {
		orderType.setTerminalTypes(null);
		orderType.setCategories(null);
		orderType.setDepartments(null);

		byte[] imageBytes = orderType.getImageBytes();
		orderType.setImageData(null);
		orderType.setImageBytes(imageBytes);
	}

	@SuppressWarnings("rawtypes")
	public List<DataSyncInfo> getUpdatedRowCount(GenericEntity entity) throws Exception {
		Client client = createWebClient();
		String paramString = URLEncodedUtils.format(getConnectionProperties(null), "utf-8"); //$NON-NLS-1$
		WebResource webResource = client.resource(getServiceUrl() + "/" + "sync" + "/count" + "?" + paramString); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		ClientResponse response = webResource.accept(MediaType.APPLICATION_JSON).post(ClientResponse.class, entity);
		if (response.getStatus() == 200) {
			return response.getEntity(new GenericType<List<DataSyncInfo>>() {
			});
		}
		else if (response.getStatus() == 500) {
			throw new Exception(Messages.getString("PosWebService.68") + response.getStatus()); //$NON-NLS-1$
		}
		return null;
	}

	@SuppressWarnings("rawtypes")
	public void uploadData(GenericEntity entity, String pathInfo) throws Exception {
		Client client = createWebClient();
		String paramString = URLEncodedUtils.format(getConnectionProperties(null), "utf-8"); //$NON-NLS-1$
		WebResource webResource = client.resource(getServiceUrl() + "/" + pathInfo + "/save" + "?" + paramString); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		ClientResponse response = webResource.accept(MediaType.APPLICATION_JSON).post(ClientResponse.class, entity);
		if (response.getStatus() == 500) {
			throw new Exception(Messages.getString("PosWebService.100")); //$NON-NLS-1$
		}
	}

	public static PosWebService get() {
		return new PosWebService();
	}

	public Date getLastUpdateTime(Class<?> class1) throws Exception {
		return getLastUpdateTime(class1, StoreDAO.getRestaurant());
	}

	public Date getLastUpdateTime(Class<?> class1, Store store) throws Exception {
		String dateProperty = store.getProperty(class1.getSimpleName() + "." + Store.PROP_LAST_UPDATE_TIME); //$NON-NLS-1$
		if (dateProperty != null) {

			return DateUtil.parseSyncTime(dateProperty);
		}
		return null;
	}

	private void makeXMLTransient(InventoryTransaction inventoryTransaction) {
		MenuItem menuItem = inventoryTransaction.getMenuItem();
		if (menuItem != null) {
			makeXMLTransient(menuItem);
		}
	}

	@SuppressWarnings("deprecation")
	private void makeXMLTransient(MenuItem menuItem) {
		MenuItemDAO.getInstance().initialize(menuItem);
		menuItem.setStockUnits(null);
		menuItem.setComboGroups(null);
		menuItem.setComboItems(null);
		menuItem.setParentMenuItem(null);
		menuItem.setPizzaPriceList(null);
		menuItem.setAttributes(null);
		menuItem.setMenuItemModiferSpecs(null);
		menuItem.setPrinterGroup(null);
		menuItem.setVariants(null);

		MenuGroup menuGroup = menuItem.getParent();
		if (menuGroup != null) {

			MenuCategory itemCategory = menuGroup.getParent();
			MenuCategory category = new MenuCategory();
			if (itemCategory != null) {
				try {
					PropertyUtils.copyProperties(category, itemCategory);
					category.setDepartments(null);
					category.setOrderTypes(null);

				} catch (IllegalAccessException | InvocationTargetException | NoSuchMethodException e) {
					e.printStackTrace();
				}
			}
			menuGroup.setParent(category);
		}
	}

	public void doUploadTicketToCloud(Ticket mTicket) throws Exception {
		List<Ticket> tickets = new ArrayList<>();
		makeXMLTransient(mTicket);
		String outletId = DataProvider.get().getStore().getDefaultOutletId();
		mTicket.setOutletId(outletId);
		tickets.add(mTicket);

		List<InventoryTransaction> inventoryTrans = InventoryTransactionDAO.getInstance().findUnsyncedByTicketId(mTicket.getId());
		if (inventoryTrans != null) {
			for (InventoryTransaction inventoryTransaction : inventoryTrans) {
				makeXMLTransient(inventoryTransaction);
			}
		}

		GenericEntity<List<Ticket>> ticketEntity = new GenericEntity<List<Ticket>>(tickets) {
		};
		uploadData(ticketEntity, "tickets"); //$NON-NLS-1$

		List<String> ticketIds = new ArrayList<String>();
		for (Ticket ticket : tickets) {
			ticketIds.add(ticket.getId());
		}
		List<String> inventoryTransIds = new ArrayList<String>();
		for (InventoryTransaction inventoryTran : inventoryTrans) {
			inventoryTransIds.add(inventoryTran.getId());
		}
		GenericDAO instance = GenericDAO.getInstance();
		instance.updateItemsLastSyncTime(ticketIds, Ticket.REF);
		instance.updateItemsLastSyncTime(inventoryTransIds, InventoryLocation.REF);
	}
}
