package com.floreantpos.model;

import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.model.base.BaseComboGroup;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class ComboGroup extends BaseComboGroup implements TimedModel, PropertyContainer {
	private static final long serialVersionUID = 1L;
	private static final String JSON_PROP_ITEM_MODIFIED_PRICE = "itemModifiedPrices"; //$NON-NLS-1$
	private static final String JSON_PROP_MENU_ITEM_PRICE = "price"; //$NON-NLS-1$
	private static final String JSON_PROP_MENU_ITEM_ID = "menuItemId"; //$NON-NLS-1$

	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;
	private transient JsonObject propertiesContainer;

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public ComboGroup() {
	}

	/**
	 * Constructor for primary key
	 */
	public ComboGroup(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/
	private List<String> itemsId;

	public List<String> getItemsId() {
		return itemsId;
	}

	public void setItemsId(List<String> itemsId) {
		this.itemsId = itemsId;
	}

	@Override
	public String getProperties() {
		if (propertiesContainer != null) {
			return propertiesContainer.toString();
		}

		String properties = super.getProperties();
		if (StringUtils.isEmpty(properties)) {
			return null;
		}

		propertiesContainer = new Gson().fromJson(properties, JsonObject.class);
		return properties;
	}

	@Override
	public void setProperties(String properties) {
		super.setProperties(properties);
		propertiesContainer = new Gson().fromJson(properties, JsonObject.class);
	}

	@Override
	public JsonObject getPropertyStore() {
		if (propertiesContainer == null) {
			propertiesContainer = new JsonObject();
		}
		return propertiesContainer;
	}

	public void addItemPrice(String itemId, double modifiedPrice) {
		if (propertiesContainer == null) {
			propertiesContainer = getPropertyStore();
		}
		JsonArray itemModifiedPrices = propertiesContainer.getAsJsonArray(JSON_PROP_ITEM_MODIFIED_PRICE);

		if (itemModifiedPrices == null) {
			itemModifiedPrices = new JsonArray();
		}
		JsonObject itemIdJsonObj = getItemJsonObject(itemId, itemModifiedPrices);
		if (itemIdJsonObj == null) {
			itemIdJsonObj = new JsonObject();
			itemIdJsonObj.addProperty(JSON_PROP_MENU_ITEM_ID, itemId);
			itemIdJsonObj.addProperty(JSON_PROP_MENU_ITEM_PRICE, modifiedPrice);
			itemModifiedPrices.add(itemIdJsonObj);
		}
		else {
			itemIdJsonObj.remove(JSON_PROP_MENU_ITEM_PRICE);
			itemIdJsonObj.addProperty(JSON_PROP_MENU_ITEM_PRICE, modifiedPrice);
		}

		propertiesContainer.add(JSON_PROP_ITEM_MODIFIED_PRICE, itemModifiedPrices);

	}

	public double getItemPrice(String itemId) {
		if (propertiesContainer == null) {
			return 0;
		}
		JsonArray itemModifiedPrices = propertiesContainer.getAsJsonArray(JSON_PROP_ITEM_MODIFIED_PRICE);
		if (itemModifiedPrices == null || itemModifiedPrices.isJsonNull()) {
			return 0;
		}

		for (JsonElement jsonElement : itemModifiedPrices) {
			JsonObject jsonObject = jsonElement.getAsJsonObject();
			if (jsonObject == null) {
				continue;
			}
			JsonElement id = jsonObject.get(JSON_PROP_MENU_ITEM_ID);
			if (id == null) {
				continue;
			}
			if (id.getAsString().equals(itemId)) {
				JsonElement price = jsonObject.get(JSON_PROP_MENU_ITEM_PRICE);
				if (price == null) {
					return 0;
				}
				return price.getAsDouble();
			}
		}

		return 0;
	}

	private JsonObject getItemJsonObject(String itemId, JsonArray itemModifiedPrices) {
		if (!itemModifiedPrices.isJsonNull()) {
			for (JsonElement jsonElement : itemModifiedPrices) {
				JsonObject jsonObject = jsonElement.getAsJsonObject();
				if (jsonObject == null) {
					continue;
				}
				JsonElement id = jsonObject.get(JSON_PROP_MENU_ITEM_ID);
				if (id == null) {
					continue;
				}
				if (id.getAsString().equals(itemId)) {
					return jsonObject;
				}
			}
		}
		return null;
	}
}