package com.floreantpos.model;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.model.base.BaseDeliveryZone;
import com.google.gson.Gson;
import com.google.gson.JsonObject;

public class DeliveryZone extends BaseDeliveryZone implements TimedModel, PropertyContainer {
	private static final long serialVersionUID = 1L;

	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;
	private transient JsonObject propertiesContainer;

	public static final Integer NONE = 0;
	public static final Integer POLYGON = 1;
	public static final Integer CIRCLE = 2;
	public static final String BY_DISTANCE = "By distance";
	public static final String BY_ZIPCODE = "By zipcode";
	public static final String BY_MAP = "By map";
	public static final String JSON_PROP_COORDINATES = "coordinates";

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public DeliveryZone() {
	}

	/**
	 * Constructor for primary key
	 */
	public DeliveryZone(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/
	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	@Override
	public String getProperties() {
		if (propertiesContainer != null) {
			return propertiesContainer.toString();
		}

		String properties = super.getProperties();
		if (StringUtils.isEmpty(properties)) {
			return null;
		}
		try {
			propertiesContainer = new Gson().fromJson(properties, com.google.gson.JsonObject.class);
		} catch (Exception e) {
		}
		return properties;
	}

	@Override
	public void setProperties(String properties) {
		super.setProperties(properties);
		try {
			propertiesContainer = new Gson().fromJson(properties, com.google.gson.JsonObject.class);
		} catch (Exception e) {
		}
	}

	@Override
	public JsonObject getPropertyStore() {
		if (propertiesContainer == null) {
			propertiesContainer = new JsonObject();
		}
		return propertiesContainer;
	}

	public void setMarker(double lat, double lng) {
		setLatitude(lat);
		setLongitude(lng);
	}
}