package com.floreantpos.model.dao;

import java.util.List;

import org.hibernate.Session;

import com.floreantpos.model.SequenceNumber;

public class SequenceNumberDAO extends BaseSequenceNumberDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public SequenceNumberDAO() {
	}

	public int getNextSequenceNumber(String type, Session session) {
		SequenceNumber ref = get(type, session);
		if (ref == null)
			ref = new SequenceNumber(type, 1);

		int refNumber = ref.getNextSequenceNumber();
		ref.setNextSequenceNumber(refNumber + 1);
		session.saveOrUpdate(ref);
		return refNumber;
	}

	public void resetAll(Session session) {
		List<SequenceNumber> refList = findAll(session);
		if (refList == null)
			return;
		for (SequenceNumber ref : refList) {
			ref.setNextSequenceNumber(0);
			session.saveOrUpdate(ref);
		}
	}
}