package com.floreantpos.model.ext;

public class InvMapKey {
	/**
	 * 
	 */
	String menuItemId;
	String unitCode;
	boolean itemReturned;
	
	public InvMapKey(String menuItemId, String unitCode) {
		super();
		this.menuItemId = menuItemId;
		this.unitCode = unitCode;
	}

	public String getMenuItemId() {
		return menuItemId;
	}

	public String getUnitCode() {
		return unitCode;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((menuItemId == null) ? 0 : menuItemId.hashCode());
		result = prime * result + ((unitCode == null) ? 0 : unitCode.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		InvMapKey other = (InvMapKey) obj;
		if (menuItemId == null) {
			if (other.menuItemId != null)
				return false;
		}
		else if (!menuItemId.equals(other.menuItemId))
			return false;
		if (unitCode == null) {
			if (other.unitCode != null)
				return false;
		}
		else if (!unitCode.equals(other.unitCode))
			return false;
		return true;
	}

	public boolean isItemReturned() {
		return itemReturned;
	}

	public void setItemReturned(boolean itemReturned) {
		this.itemReturned = itemReturned;
	}

}