package com.floreantpos.model;

import java.awt.Color;
import java.awt.Image;
import java.sql.Blob;
import java.sql.SQLException;

import javax.swing.ImageIcon;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.PosLog;
import com.floreantpos.constants.AppConstants;
import com.floreantpos.model.base.BaseOrderType;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.POSUtil;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

@JsonIgnoreProperties(ignoreUnknown = true, value = { /*"terminalTypes", "categories", "departments", */"buttonColor", "textColor", "image", "scaledImage",
		"properties", "imageData" })
@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement
public class OrderType extends BaseOrderType implements TimedModel {
	private static final long serialVersionUID = 1L;

	public static final String BAR_TAB = "BAR_TAB"; //$NON-NLS-1$
	//	public static final String FOR_HERE = "FOR HERE"; //$NON-NLS-1$
	//	public static final String TO_GO = "TO GO"; //$NON-NLS-1$

	public static final String PROP_ID = "id"; //$NON-NLS-1$
	public static final String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$

	private transient JsonObject propertiesContainer;

	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;

	private byte[] imageBytes;

	public OrderType() {
	}

	/**
	 * Return the value associated with the column: DEFAULT_TAX_GROUP_ID
	 */
	public com.floreantpos.model.TaxGroup getDefaultTaxGroup() {
		return DataProvider.get().getTaxGroupById(getDefaultTaxGroupId());
	}

	/**
	 * Set the value related to the column: DEFAULT_TAX_GROUP_ID
	 * @param defaultTaxGroup the DEFAULT_TAX_GROUP_ID value
	 */
	public void setDefaultTaxGroup(com.floreantpos.model.TaxGroup defaultTaxGroup) {
		setDefaultTaxGroupId(defaultTaxGroup == null ? null : defaultTaxGroup.getId());
	}

	/**
	 * Return the value associated with the column: FOR_HERE_TAX_GROUP_ID
	 */
	public com.floreantpos.model.TaxGroup getForHereTaxGroup() {
		return DataProvider.get().getTaxGroupById(getForHereTaxGroupId());
	}

	/**
	 * Set the value related to the column: FOR_HERE_TAX_GROUP_ID
	 * @param forHereTaxGroup the FOR_HERE_TAX_GROUP_ID value
	 */
	public void setForHereTaxGroup(com.floreantpos.model.TaxGroup forHereTaxGroup) {
		setForHereTaxGroupId(forHereTaxGroup == null ? null : forHereTaxGroup.getId());
	}

	/**
	 * Return the value associated with the column: TO_GO_TAX_GROUP_ID
	 */
	public com.floreantpos.model.TaxGroup getToGoTaxGroup() {
		return DataProvider.get().getTaxGroupById(getToGoTaxGroupId());
	}

	/**
	 * Set the value related to the column: TO_GO_TAX_GROUP_ID
	 * @param toGoTaxGroup the TO_GO_TAX_GROUP_ID value
	 */
	public void setToGoTaxGroup(com.floreantpos.model.TaxGroup toGoTaxGroup) {
		setToGoTaxGroupId(toGoTaxGroup == null ? null : toGoTaxGroup.getId());
	}

	@XmlTransient
	public Color getTextColor() {
		if (getTextColorCode() == null) {
			return null;
		}
		return new Color(getTextColorCode());
	}

	public void setTextColor(Color textColor) {
		if (textColor != null) {
			setTextColorCode(textColor.getRGB());
		}
	}

	@Override
	public Integer getButtonColorCode() {
		Integer buttonColorCode = super.getButtonColorCode();
		if (buttonColorCode == null || buttonColorCode == 0 || buttonColorCode == -1316371 || buttonColorCode == -1250856) {
			buttonColorCode = Color.WHITE.getRGB();
		}
		return buttonColorCode;
	}

	public Color getButtonColor() {
		Integer buttonColorCode = getButtonColorCode();
		if (buttonColorCode == null) {
			return null;
		}

		return new Color(getButtonColorCode());
	}

	public void setButtonColor(Color buttonColor) {
		if (buttonColor != null) {
			setButtonColorCode(buttonColor.getRGB());
		}
	}

	public OrderType(java.lang.String id, String outletId) {
		super(id, outletId);
	}

	public String name() {
		return super.getName();
	}

	public OrderType valueOf() {
		return this;
	}

	@Override
	public String toString() {
		String name = getName();
		if (name != null)
			name.replaceAll("_", " "); //$NON-NLS-1$ //$NON-NLS-2$
		return name;
	}

	@XmlTransient
	public ImageIcon getImage() {
		if (imageBytes == null) {
			return null;
		}
		return new ImageIcon(imageBytes);
	}

	//	public Image getStoredImage() {
	//		ImageIcon tempImageIcon = new ImageIcon(getImageBytes());;
	//		Image tempImage;
	//		if (tempImageIcon != null) {
	//			tempImage = tempImageIcon.getImage();
	//		}
	//		else {
	//			return null;
	//		}
	//		return tempImage;
	//	}

	@XmlTransient
	@Override
	public void setImageData(Blob imageData) {
		super.setImageData(imageData);

		if (imageData != null) {
			try {
				int blobLength = (int) imageData.length();
				imageBytes = imageData.getBytes(1, blobLength);
			} catch (SQLException e) {
				PosLog.error(getClass(), e);
			}

		}
	}

	public ImageIcon getScaledImage(int width, int height) {
		Image scaledInstance = null;
		if (imageBytes != null) {
			ImageIcon image = new ImageIcon(imageBytes);
			scaledInstance = image.getImage().getScaledInstance(width, height, Image.SCALE_SMOOTH);
			return new ImageIcon(scaledInstance);
		}
		else
			return null;
	}

	public String getUniqueId() {
		return ("order_type_" + getName() + "_" + getId()).replaceAll("\\s+", "_"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
	}

	@Override
	public String getProperties() {
		if (propertiesContainer != null) {
			return propertiesContainer.toString();
		}

		String properties = super.getProperties();
		if (StringUtils.isEmpty(properties)) {
			return null;
		}

		propertiesContainer = new Gson().fromJson(properties, JsonObject.class);
		return properties;
	}

	@Override
	public void setProperties(String properties) {
		super.setProperties(properties);
		propertiesContainer = new Gson().fromJson(properties, JsonObject.class);
	}

	public void addProperty(String key, String value) {
		if (propertiesContainer == null) {
			propertiesContainer = new JsonObject();
		}
		propertiesContainer.addProperty(key, value);
	}

	public String getProperty(String key) {
		if (propertiesContainer == null) {
			return null;
		}
		if (propertiesContainer.has(key)) {
			JsonElement jsonElement = propertiesContainer.get(key);
			if (!jsonElement.isJsonNull()) {
				return jsonElement.getAsString();
			}
		}
		return null;
	}

	public boolean hasProperty(String key) {
		if (propertiesContainer != null) {
			return propertiesContainer.has(key);
		}
		return false;
	}

	public boolean isPropertyValueTrue(String propertyName) {
		String property = getProperty(propertyName);

		return POSUtil.getBoolean(property);
	}

	public void removeProperty(String propertyName) {
		if (propertiesContainer != null) {
			propertiesContainer.remove(propertyName);
		}
	}

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	public byte[] getImageBytes() {
		return imageBytes;
	}

	public void setImageBytes(byte[] imageBytes) {
		this.imageBytes = imageBytes;
	}

	public boolean isTokenInputEnable() {
		return POSUtil.getBoolean(getProperty(AppConstants.ENABLE_MANUAL_INPUT_OF_TOKEN));
	}

	public void setTokenInputEnable(boolean isEnable) {
		addProperty(AppConstants.ENABLE_MANUAL_INPUT_OF_TOKEN, String.valueOf(isEnable));
	}

	public boolean isBeverageMandatory() {
		return POSUtil.getBoolean(getProperty(AppConstants.BEVERAGE_IS_MANDATORY));
	}

	public void setBeverageMandatory(boolean isMandatory) {
		addProperty(AppConstants.BEVERAGE_IS_MANDATORY, String.valueOf(isMandatory));
	}
}