package com.floreantpos.report.model;

import org.apache.commons.lang3.StringUtils;

import com.floreantpos.POSConstants;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.User;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.util.NumberUtil;

public class PaymentReceivedReportModel extends ListTableModel {
	public PaymentReceivedReportModel() {
		super(new String[] { "user", "transTime", "transNo", "ticket", "transType", "total", "memberName" }); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$

	}

	@Override
	public Object getValueAt(int rowIndex, int columnIndex) {
		PosTransaction data = (PosTransaction) rows.get(rowIndex);
		Ticket ticket = data.getTicket();
		switch (columnIndex) {
			case 0:
				User user = data.getUser();
				if (user == null) {
					return POSConstants.NONE;
				}
				return user.getFullName();

			case 1:
				return DateUtil.formatDateWithBrowserTimeOffset(data.getTransactionTime());

			case 2:
				return data.getId();

			case 3:
				if (ticket == null) {
					return ""; //$NON-NLS-1$
				}
				return data.getTicket().getId();

			case 4:
				PaymentType paymentType = data.getPaymentType();
				if (paymentType == null) {
					return null;
				}
				String paymentTypeStr;
				if (paymentType.equals(PaymentType.CUSTOM_PAYMENT)) {
					String customPaymentName = data.getCustomPaymentName();
					paymentTypeStr = StringUtils.isEmpty(customPaymentName) ? null : customPaymentName;
				}
				else {
					paymentTypeStr = paymentType.getDisplayString();
				}
				return paymentTypeStr;

			case 5:
				if (data.getTransactionType().equalsIgnoreCase(TransactionType.DEBIT.name())) {
					return NumberUtil.round((-1) * data.getAmount());
				}
				return NumberUtil.round(data.getAmount());

			case 6:
				if (ticket == null) {
					return ""; //$NON-NLS-1$
				}
				if (data.getTicket().getCustomer() != null) {
					return data.getTicket().getCustomer().getName();
				}
				else {
					return ""; //$NON-NLS-1$
				}

		}
		return null;
	}

}