package com.floreantpos.model;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.constants.AppConstants;
import com.floreantpos.model.base.BaseOutlet;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.CopyUtil;
import com.google.gson.Gson;
import com.google.gson.JsonObject;

@JsonIgnoreProperties(ignoreUnknown = true, value = { "properties", "departments", "tableServingBGColor", "tableServingForeColor", "tableBookForeColor",
		"tableBookBGColor", "tableFreeForeColor", "tableFreeBGColor", "tableSeatForeColor", "tableSeatBGColor", "taxGroup", "address", "currency",
		"workingHours", "timeZone" })
@XmlRootElement
public class Outlet extends BaseOutlet implements TimedModel, PropertyContainer, AddressContainer {
	private static final long serialVersionUID = 1L;

	//public final static String PROP_KDS_ENABLED = "kds_enable";

	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;
	private transient JsonObject propertiesContainer;

	private List<WorkingHours> workingHours;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public Outlet() {
	}

	/**
	 * Constructor for primary key
	 */
	public Outlet(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/

	@Override
	public String toString() {
		return super.getName();
	}

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	@XmlTransient
	public TaxGroup getTaxGroup() {
		return DataProvider.get().getTaxGroupById(getTaxGroupId());
	}

	public void setTaxGroup(TaxGroup taxGroup) {
		String taxGroupId = null;
		if (taxGroup != null) {
			taxGroupId = taxGroup.getId();
		}
		super.setTaxGroupId(taxGroupId);
	}

	@XmlTransient
	public Address getAddress() {
		//		if (StringUtils.isNotEmpty(getAddressId())) {
		//			return AddressDAO.getInstance().get(getAddressId());
		//		}
		//		return null;

		Address address = new Address();
		CopyUtil.copyAddress(this, address);
		return address;
	}

	public void setAddress(Address address) {
		//		String addressId = null;
		//		if (address != null) {
		//			addressId = address.getId();
		//		}
		//		super.setAddressId(addressId);
	}

	@XmlTransient
	public Currency getCurrency() {
		return DataProvider.get().getCurrency(getCurrencyId(), getId());
	}

	public void setCurrency(Currency currency) {
		String currencyId = null;
		if (currency != null) {
			currencyId = currency.getId();
		}
		super.setCurrencyId(currencyId);
	}

	@Override
	public JsonObject getPropertyStore() {
		if (propertiesContainer == null) {
			propertiesContainer = new JsonObject();
		}
		return propertiesContainer;
	}

	//	public String getCurrencyName() {
	//		String currencyName = super.getCurrencyName();
	//		if (StringUtils.isEmpty(currencyName)) {
	//			return "Sample Currency"; //$NON-NLS-1$
	//		}
	//		return currencyName;
	//	}
	//
	//	public String getCurrencySymbol() {
	//		String currencySymbol = super.getCurrencySymbol();
	//		if (StringUtils.isEmpty(currencySymbol)) {
	//			currencySymbol = "$"; //$NON-NLS-1$
	//		}
	//		return currencySymbol;
	//	}

	//	public boolean isAllwMemberbasedPOI() {
	//		String update = getProperty(AppConstants.INVENTORY_ALLOW_MEMBER_POI);
	//		if (StringUtils.isEmpty(update)) {
	//			return false;
	//		}
	//		return Boolean.valueOf(update);
	//	}
	//
	//	public boolean isUpdateOnHandBlncForSale() {
	//		String update = getProperty(AppConstants.INVENTORY_UPDATE_ON_HAND_BALANCE_FOR_SALE);
	//		if (StringUtils.isEmpty(update)) {
	//			return true;
	//		}
	//		return Boolean.valueOf(update);
	//	}
	//
	//	public boolean isUpdateAvlBlncForSale() {
	//		String update = getProperty(AppConstants.INVENTORY_UPDATE_AVAIL_BALANCE_FOR_SALE);
	//		if (StringUtils.isEmpty(update)) {
	//			return true;
	//		}
	//		return Boolean.valueOf(update);
	//	}
	//
	//	public boolean isAllwNegOnHandBlnce() {
	//		String update = getProperty(AppConstants.INVENTORY_ALLOW_NEGETIVE_ON_HAND_BALANCE);
	//		if (StringUtils.isEmpty(update)) {
	//			return false;
	//		}
	//		return Boolean.valueOf(update);
	//	}
	//
	//	public boolean isUpdateAvlBlncForPOCreated() {
	//		String update = getProperty(AppConstants.INVENTORY_UPDATE_AVAILABLE_BALANCE_FOR_PURCHASE_ORDER_CREATED);
	//		if (StringUtils.isEmpty(update)) {
	//			return false;
	//		}
	//		return Boolean.valueOf(update);
	//	}
	//
	//	public boolean isUpdateOnHandBlncForPORec() {
	//		String update = getProperty(AppConstants.INVENTORY_UPDATE_ON_HAND_BALANCE_FOR_PURCHASE_ORDER_RECEIVED);
	//		if (StringUtils.isEmpty(update)) {
	//			return true;
	//		}
	//		return Boolean.valueOf(update);
	//	}
	//
	public String getImageId() {
		String storeLogoResourceId = getProperty(AppConstants.PROP_HEADER_LOGO_IMAGE_ID);
		if (StringUtils.isEmpty(storeLogoResourceId)) {
			String oldLogoResourceId = getProperty("ticket.header.logo.imageid"); //property name changed: ticket.header.logo.imageid-> logo.imageid //$NON-NLS-1$
			if (oldLogoResourceId != null) {
				addProperty(AppConstants.PROP_HEADER_LOGO_IMAGE_ID, oldLogoResourceId);//old image id replace with current image id
				return oldLogoResourceId;
			}
		}
		return storeLogoResourceId;
	}

	//	public ImageIcon getStoreLogo() {
	//		if (this.storeLogo == null) {
	//			String storeLogoResourceId = getImageId();
	//			if (StringUtils.isEmpty(storeLogoResourceId))
	//				return null;
	//			ImageResource logoResource = ImageResourceDAO.getInstance().findById(storeLogoResourceId);
	//			if (logoResource != null) {
	//				this.storeLogo = new ImageIcon(logoResource.getImage());
	//				if (this.storeLogo.getIconWidth() > 128 || this.storeLogo.getIconHeight() > 128) {
	//					this.storeLogo = new ImageIcon(POSUtil.getScaledImage(logoResource.getImage(), 128, 128));
	//				}
	//			}
	//		}
	//		return this.storeLogo;
	//	}

	//	public boolean isInventoryAvgPricingMethod() {
	//		String property = getProperty(AppConstants.INVENTORY_PRICING_METHOD);
	//		if (property == null) {
	//			return false;
	//		}
	//		return property.equals(AppConstants.INVENTORY_PRICING_METHOD_VALUE_AVG);
	//	}

	//	public void setStoreLogo(ImageIcon storeLogo) {
	//		this.storeLogo = storeLogo;
	//	}
	//
	//	public ImageIcon getLoginScreenBackground() {
	//		if (this.loginScreenBackground == null) {
	//			String resourceId = getProperty(AppConstants.PROP_LOGIN_SCREEN_BACKGROUND);
	//			if (resourceId == null)
	//				return null;
	//			ImageResource resource = ImageResourceDAO.getInstance().findById(resourceId);
	//			if (resource != null) {
	//				this.loginScreenBackground = new ImageIcon(resource.getImage());
	//			}
	//		}
	//		return loginScreenBackground;
	//	}
	//
	//	public void setLoginScreenBackground(ImageIcon loginScreenBackground) {
	//		this.loginScreenBackground = loginScreenBackground;
	//	}

	//	public static String getWebServiceUrl() {
	//		Store store = DataProvider.get().getStore();
	//		return store.getProperty(RestConstants.WEB_SERVICE_URL) + RestConstants.URL_SERVICE_DATA_STORE
	//				+ store.getProperty(RestConstants.WEB_SERVICE_SCHEMA_NAME); //$NON-NLS-1$
	//	}
	//
	//	public TipsReceivedBy getTipsReceivedByForDeliveryOrder() {
	//		try {
	//			String tipsReceiver = getProperty(AppConstants.TIPS_RECEIVED_BY_FOR_DELIVERY);
	//			if (StringUtils.isNotEmpty(tipsReceiver)) {
	//				return TipsReceivedBy.valueOf(tipsReceiver);
	//			}
	//			return TipsReceivedBy.Server;
	//		} catch (Exception e) {
	//			throw new PosException(Messages.getString("Outlet.2")); //$NON-NLS-1$
	//		}
	//	}
	//
	//	public TipsReceivedBy getTipsReceivedByForNonDeliveryOrder() {
	//		try {
	//			String tipsReceiver = getProperty(AppConstants.TIPS_RECEIVED_BY_FOR_NON_DELIVERY);
	//			if (StringUtils.isNotEmpty(tipsReceiver)) {
	//				return TipsReceivedBy.valueOf(tipsReceiver);
	//			}
	//			return TipsReceivedBy.Server;
	//		} catch (Exception e) {
	//			throw new PosException(Messages.getString("Outlet.2")); //$NON-NLS-1$
	//		}
	//	}
	//
	//	public double getOvertimeMarkup() {
	//		try {
	//			String overtimeMarkup = getProperty(AppConstants.STORE_OVERTIME_MARKUP);
	//			if (StringUtils.isNotEmpty(overtimeMarkup)) {
	//				return Double.parseDouble(overtimeMarkup);
	//			}
	//
	//		} catch (Exception e) {
	//		}
	//		return 0.0;
	//	}
	//
	//	public boolean hasCreateMemberPermission() {
	//		try {
	//			String memberCreate = getProperty(AppConstants.PROP_PERMISSION_CREATE_MEMBER);
	//			if (StringUtils.isNotEmpty(memberCreate)) {
	//				return Boolean.valueOf(memberCreate);
	//			}
	//
	//		} catch (Exception e) {
	//		}
	//		return true;
	//	}
	//
	//	public boolean isAutoSyncCharges() {
	//		return getBooleanProperty(Store.STORE_PROP_AUTOMATICALLY_SYNC_CHARGES_WHEN_DAY_CLOSED, Boolean.FALSE);
	//	}
	//
	//	public boolean isAllowPenyRounding() {
	//		try {
	//			String penyRoundAmnt = getProperty(AppConstants.STORE_PENY_ROUNDING);
	//			if (StringUtils.isNotEmpty(penyRoundAmnt)) {
	//				return Boolean.valueOf(penyRoundAmnt);
	//			}
	//
	//		} catch (Exception e) {
	//		}
	//		return false;
	//	}
	//
	//	public int getCustomerMonitorDisplayOption() {
	//		try {
	//			String displayOptionString = getProperty(AppConstants.CUSTOMER_MONITOR_DIS_OPTION);
	//			if (StringUtils.isNotEmpty(displayOptionString)) {
	//				return Integer.parseInt(displayOptionString);
	//			}
	//
	//		} catch (Exception e) {
	//		}
	//		return 0;
	//	}
	//
	//	public int getCustomerMonitorDisplaySlideDuration() {
	//		try {
	//			String slideDurationString = getProperty(AppConstants.CUSTOMER_MONITOR_SLIDE_DURATION);
	//			if (StringUtils.isNotEmpty(slideDurationString)) {
	//				return Integer.parseInt(slideDurationString);
	//			}
	//
	//		} catch (Exception e) {
	//		}
	//		return 5;
	//	}
	//
	//	public String getServerUrl() {
	//
	//		try {
	//			String serverUrl = getProperty(AppConstants.PROP_UPDATE_SERVER_URL);
	//			if (StringUtils.isNotEmpty(serverUrl)) {
	//				return serverUrl;
	//			}
	//
	//		} catch (Exception e) {
	//		}
	//
	//		return ""; //$NON-NLS-1$
	//	}

	public void setTablePrimaryFontSize(int priFont) {
		addProperty(AppConstants.FLOORPLAN_CONFIG_PRIMARY_FONT_SIZE, String.valueOf(priFont));
	}

	//	public int getTablePrimaryFontSize() {
	//		return getProperty(AppConstants.FLOORPLAN_CONFIG_PRIMARY_FONT_SIZE) == null ? 18
	//				: Integer.valueOf(getProperty(AppConstants.FLOORPLAN_CONFIG_PRIMARY_FONT_SIZE));
	//	}

	public void setTableSecondaryFontSize(int secFont) {
		addProperty(AppConstants.FLOORPLAN_CONFIG_SECONDARY_FONT_SIZE, String.valueOf(secFont));
	}

	//	public int getTableSecondaryFontSize() {
	//		return getProperty(AppConstants.FLOORPLAN_CONFIG_SECONDARY_FONT_SIZE) == null ? 10
	//				: Integer.valueOf(getProperty(AppConstants.FLOORPLAN_CONFIG_SECONDARY_FONT_SIZE));
	//	}

	public void setTableBtnWidth(int btnWidth) {
		addProperty(AppConstants.FLOORPLAN_CONFIG_BTN_WIDTH, String.valueOf(btnWidth));
	}

	//	public int getTableBtnWidth() {
	//		return getProperty(AppConstants.FLOORPLAN_CONFIG_BTN_WIDTH) == null ? 100 : Integer.valueOf(getProperty(AppConstants.FLOORPLAN_CONFIG_BTN_WIDTH));
	//	}

	public void setTableBtnHeight(int btnHeight) {
		addProperty(AppConstants.FLOORPLAN_CONFIG_BTN_HEIGHT, String.valueOf(btnHeight));
	}

	//	public int getTableBtnHeight() {
	//		return getProperty(AppConstants.FLOORPLAN_CONFIG_BTN_HEIGHT) == null ? 80 : Integer.valueOf(getProperty(AppConstants.FLOORPLAN_CONFIG_BTN_HEIGHT));
	//	}

	public void setTableSeatForeColor(Color seatForeColor) {
		addProperty(AppConstants.FLOORPLAN_CONFIG_SEAT_FORE_COLOR, seatForeColor != null ? String.valueOf(seatForeColor.getRGB()) : ""); //$NON-NLS-1$
	}
	//
	//	@XmlTransient
	//	public Color getTableSeatForeColor() {
	//		return StringUtils.isEmpty(getProperty(AppConstants.FLOORPLAN_CONFIG_SEAT_FORE_COLOR)) ? Color.BLACK
	//				: new Color(Integer.parseInt(getProperty(AppConstants.FLOORPLAN_CONFIG_SEAT_FORE_COLOR)));
	//	}

	public void setTableSeatBGColor(Color seatBgColor) {
		addProperty(AppConstants.FLOORPLAN_CONFIG_SEAT_BG_COLOR, seatBgColor != null ? String.valueOf(seatBgColor.getRGB()) : ""); //$NON-NLS-1$
	}

	//	@XmlTransient
	//	public Color getTableSeatBGColor() {
	//		return StringUtils.isEmpty(getProperty(AppConstants.FLOORPLAN_CONFIG_SEAT_BG_COLOR)) ? Color.ORANGE
	//				: new Color(Integer.parseInt(getProperty(AppConstants.FLOORPLAN_CONFIG_SEAT_BG_COLOR)));
	//	}

	public void setTableServingForeColor(Color servingForeColor) {
		addProperty(AppConstants.FLOORPLAN_CONFIG_SERVING_FORE_COLOR, servingForeColor != null ? String.valueOf(servingForeColor.getRGB()) : ""); //$NON-NLS-1$
	}

	//	@XmlTransient
	//	public Color getTableServingForeColor() {
	//		return StringUtils.isEmpty(getProperty(AppConstants.FLOORPLAN_CONFIG_SERVING_FORE_COLOR)) ? Color.BLACK
	//				: new Color(Integer.parseInt(getProperty(AppConstants.FLOORPLAN_CONFIG_SERVING_FORE_COLOR)));
	//	}

	public void setTableServingBGColor(Color servingBgColor) {
		addProperty(AppConstants.FLOORPLAN_CONFIG_SERVING_BG_COLOR, servingBgColor != null ? String.valueOf(servingBgColor.getRGB()) : ""); //$NON-NLS-1$
	}

	//	@XmlTransient
	//	public Color getTableServingBGColor() {
	//		return StringUtils.isEmpty(getProperty(AppConstants.FLOORPLAN_CONFIG_SERVING_BG_COLOR)) ? new Color(255, 102, 102)
	//				: new Color(Integer.parseInt(getProperty(AppConstants.FLOORPLAN_CONFIG_SERVING_BG_COLOR)));
	//	}

	public void setTableBookForeColor(Color bookForeColor) {
		addProperty(AppConstants.FLOORPLAN_CONFIG_BOOK_FORE_COLOR, bookForeColor != null ? String.valueOf(bookForeColor.getRGB()) : ""); //$NON-NLS-1$
	}

	//	@XmlTransient
	//	public Color getTableBookForeColor() {
	//		return StringUtils.isEmpty(getProperty(AppConstants.FLOORPLAN_CONFIG_BOOK_FORE_COLOR)) ? Color.BLACK
	//				: new Color(Integer.parseInt(getProperty(AppConstants.FLOORPLAN_CONFIG_BOOK_FORE_COLOR)));
	//	}

	public void setTableBookBGColor(Color bookBgColor) {
		addProperty(AppConstants.FLOORPLAN_CONFIG_BOOK_BG_COLOR, bookBgColor != null ? String.valueOf(bookBgColor.getRGB()) : ""); //$NON-NLS-1$
	}

	//	@XmlTransient
	//	public Color getTableBookBGColor() {
	//		return StringUtils.isEmpty(getProperty(AppConstants.FLOORPLAN_CONFIG_BOOK_BG_COLOR)) ? Color.YELLOW
	//				: new Color(Integer.parseInt(getProperty(AppConstants.FLOORPLAN_CONFIG_BOOK_BG_COLOR)));
	//	}
	//
	//	public void setTableFreeForeColor(Color freeForeColor) {
	//		addProperty(AppConstants.FLOORPLAN_CONFIG_FREE_FORE_COLOR, freeForeColor != null ? String.valueOf(freeForeColor.getRGB()) : ""); //$NON-NLS-1$
	//	}
	//
	//	@XmlTransient
	//	public Color getTableFreeForeColor() {
	//		return StringUtils.isEmpty(getProperty(AppConstants.FLOORPLAN_CONFIG_FREE_FORE_COLOR)) ? Color.black
	//				: new Color(Integer.parseInt(getProperty(AppConstants.FLOORPLAN_CONFIG_FREE_FORE_COLOR)));
	//	}

	public void setTableFreeBGColor(Color freeBgColor) {
		addProperty(AppConstants.FLOORPLAN_CONFIG_FREE_BG_COLOR, freeBgColor != null ? String.valueOf(freeBgColor.getRGB()) : ""); //$NON-NLS-1$
	}

	//	@XmlTransient
	//	public Color getTableFreeBGColor() {
	//		return StringUtils.isEmpty(getProperty(AppConstants.FLOORPLAN_CONFIG_FREE_BG_COLOR)) ? Color.white
	//				: new Color(Integer.parseInt(getProperty(AppConstants.FLOORPLAN_CONFIG_FREE_BG_COLOR)));
	//	}
	//
	//	public boolean isShowTableNameOnTable() {
	//		return Boolean.valueOf(getProperty(AppConstants.FLOORPLAN_CONFIG_SHOW_TABLE_NAME, "false")); //$NON-NLS-1$
	//	}
	//
	//	public boolean isShowTableNumberOnTable() {
	//		return Boolean.valueOf(getProperty(AppConstants.FLOORPLAN_CONFIG_SHOW_TABLE_NUMBER, "true")); //$NON-NLS-1$
	//	}
	//
	//	public boolean isShowServerNameOnTable() {
	//		return Boolean.valueOf(getProperty(AppConstants.FLOORPLAN_CONFIG_SHOW_SERVER_NAME_ON_TABLE, "true")); //$NON-NLS-1$
	//	}
	//
	//	public boolean isShowTokenNumberOnTable() {
	//		return Boolean.valueOf(getProperty(AppConstants.FLOORPLAN_CONFIG_SHOW_TOKEN_NUMBER_ON_TABLE, "true")); //$NON-NLS-1$
	//	}

	public void setShowTableNameOnTable(boolean show) {
		addProperty(AppConstants.FLOORPLAN_CONFIG_SHOW_TABLE_NAME, String.valueOf(show));
	}

	public void setShowTableNumberOnTable(boolean show) {
		addProperty(AppConstants.FLOORPLAN_CONFIG_SHOW_TABLE_NUMBER, String.valueOf(show));
	}

	public void setShowServerNameOnTable(boolean show) {
		addProperty(AppConstants.FLOORPLAN_CONFIG_SHOW_SERVER_NAME_ON_TABLE, String.valueOf(show));
	}

	public void setShowTokenNumberOnTable(boolean show) {
		addProperty(AppConstants.FLOORPLAN_CONFIG_SHOW_TOKEN_NUMBER_ON_TABLE, String.valueOf(show));
	}

	@Override
	public String getExtraProperties() {
		if (propertiesContainer != null) {
			return propertiesContainer.toString();
		}

		String properties = super.getExtraProperties();
		if (StringUtils.isEmpty(properties)) {
			return null;
		}

		propertiesContainer = new Gson().fromJson(properties, JsonObject.class);
		return properties;
	}

	@Override
	public void setExtraProperties(String properties) {
		super.setExtraProperties(properties);
		propertiesContainer = new Gson().fromJson(properties, JsonObject.class);
	}

	public void setDateFormat(String dateFormat) {
		addProperty(AppConstants.PROP_DEFAULT_DATE_FORMAT, dateFormat); //$NON-NLS-1$
	}

	public String getDateFormat() {
		return getProperty(AppConstants.PROP_DEFAULT_DATE_FORMAT, "dd-MMM-yy"); //$NON-NLS-1$
	}

	public void setPickUpAvailable(boolean pickUp) {
		addProperty(AppConstants.PROP_PICKUP, String.valueOf(pickUp));
	}

	public boolean isPickUpAvailable() {
		return getBooleanProperty(AppConstants.PROP_PICKUP, true);
	}

	public boolean isDeliveryAvailable() {
		return getBooleanProperty(AppConstants.PROP_DELIVERY, true);
	}

	public void setDeliveryAvailable(boolean delivery) {
		addProperty(AppConstants.PROP_DELIVERY, String.valueOf(delivery));
	}

	@XmlTransient
	public List<WorkingHours> getWorkingHours() {
		if (workingHours == null) {
			workingHours = new ArrayList<>();
			for (int i = 1; i <= 7; i++) {
				WorkingHours workingHour = getWorkingHours(i);
				if (workingHour == null) {
					continue;
				}
				workingHours.add(workingHour);
			}
		}
		return workingHours;
	}

	public WorkingHours getWorkingHours(int day) {
		/*if (!getBooleanProperty(WorkingHours.days[day] + WorkingHours.OPEN, true)) {
			return null;
		}*/
		return new WorkingHours(day, this);
	}

	public void setWorkingHours(List<WorkingHours> workingHours) {
		this.workingHours = workingHours;
	}
	
	@XmlTransient
	public TimeZone getTimeZone() {
		return TimeZone.getTimeZone(getProperty(WorkingHours.TIME_ZONE));
	}
}