package com.floreantpos.model;

import java.awt.Image;
import java.beans.Transient;
import java.sql.Blob;

import javax.swing.ImageIcon;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BaseImageResource;
import com.floreantpos.swing.PosUIManager;
import com.google.gson.Gson;
import com.google.gson.JsonObject;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement
@JsonIgnoreProperties(ignoreUnknown = true, value = { "asIcon", "image", "scaledImage", "buttonImage", "buttonBigImage", "imageIcon", "imageData" })
public class ImageResource extends BaseImageResource implements TimedModel, JsonPropertyContainer {
	private static final long serialVersionUID = 1L;
	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;
	
	private transient com.google.gson.JsonObject propertiesContainer;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public ImageResource () {
    }

	/**
	 * Constructor for primary key
	 */
	public ImageResource (java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/
	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	@Transient
	@Override
	@Deprecated
	public Blob getImageData() {
		return super.getImageData();
	}

	@Override
	@Deprecated
	public void setImageData(Blob imageData) {
		super.setImageData(imageData);
	}

	public enum IMAGE_CATEGORY {
		UNLISTED(0), FLOORPLAN(1), PRODUCTS(2), PEOPLE(3), DELETED(4);
		private int type;

		private IMAGE_CATEGORY(int type) {
			this.type = type;
		}

		public int getType() {
			return type;
		}

		public void setType(int type) {
			this.type = type;
		}

		public static IMAGE_CATEGORY fromInt(int type) {
			IMAGE_CATEGORY[] values = values();

			for (IMAGE_CATEGORY cat : values) {
				if (cat.type == type) {
					return cat;
				}
			}

			return UNLISTED;
		}
	}

	public IMAGE_CATEGORY getImageCategory() {
		return IMAGE_CATEGORY.fromInt(super.getImageCategoryNum());
	}

	public void setImageCategory(IMAGE_CATEGORY imageCategory) {
		super.setImageCategoryNum(imageCategory.getType());
	}

	public ImageIcon getScaledImage(int w, int h) {
		byte[] imageData = getImageBytes();
		if (imageData == null) {
			return null;
		}

		ImageIcon imageIcon = new ImageIcon(imageData);
		Image scaledImage = imageIcon.getImage().getScaledInstance(w, h, Image.SCALE_SMOOTH);
		return new ImageIcon(scaledImage);
	}

	public ImageIcon getButtonImage() {
		byte[] imageData = getImageBytes();
		if (imageData == null) {
			return null;
		}
		ImageIcon imageIcon = new ImageIcon(imageData);
		return getScaledImageIcon(imageIcon, 40);
	}

	public static ImageIcon getScaledImageIcon(ImageIcon imageIcon, int size) {
		//size = PosUIManager.getSize(size);
		int iconHeight = imageIcon.getIconHeight();
		int iconWidth = imageIcon.getIconWidth();

		if (iconWidth > iconHeight) {
			int width = size;
			int height = (iconHeight * width) / iconWidth;
			Image scaledImage = imageIcon.getImage().getScaledInstance(PosUIManager.getSize(width), PosUIManager.getSize(height), Image.SCALE_SMOOTH);
			return new ImageIcon(scaledImage);
		}
		else {
			int height = size;
			int width = (iconWidth * height) / iconHeight;
			Image scaledImage = imageIcon.getImage().getScaledInstance(PosUIManager.getSize(width), PosUIManager.getSize(height), Image.SCALE_SMOOTH);
			return new ImageIcon(scaledImage);
		}
	}

	public ImageIcon getButtonImage(int w, int h) {
		byte[] imageData = getImageBytes();
		if (imageData == null) {
			return null;
		}
		ImageIcon imageIcon = new ImageIcon(imageData);
		int iconHeight = imageIcon.getIconHeight();
		int iconWidth = imageIcon.getIconWidth();

		if (iconWidth > iconHeight) {
			int width = w;
			int height = (iconHeight * width) / iconWidth;
			Image scaledImage = imageIcon.getImage().getScaledInstance(width, height, Image.SCALE_SMOOTH);
			return new ImageIcon(scaledImage);
		}
		else {
			int height = h;
			int width = (iconWidth * height) / iconHeight;
			Image scaledImage = imageIcon.getImage().getScaledInstance(width, height, Image.SCALE_SMOOTH);
			return new ImageIcon(scaledImage);
		}
	}

	public ImageIcon getImageOfHeight(int h) {
		byte[] imageData = getImageBytes();
		if (imageData == null) {
			return null;
		}
		ImageIcon imageIcon = new ImageIcon(imageData);
		int iconHeight = imageIcon.getIconHeight();
		int iconWidth = imageIcon.getIconWidth();

		int height = h;
		int width = (iconWidth * height) / iconHeight;
		if (height <=0 || width <= 0) {
			return null;
		}
		Image scaledImage = imageIcon.getImage().getScaledInstance(width, height, Image.SCALE_SMOOTH);
		return new ImageIcon(scaledImage);
	}

	public ImageIcon getButtonBigImage() {
		byte[] imageData = getImageBytes();
		if (imageData == null) {
			return null;
		}
		ImageIcon imageIcon = new ImageIcon(imageData);
		int iconHeight = imageIcon.getIconHeight();
		int iconWidth = imageIcon.getIconWidth();

		if (iconWidth > iconHeight) {
			int width = 200;
			int height = (iconHeight * width) / iconWidth;
			Image scaledImage = imageIcon.getImage().getScaledInstance(PosUIManager.getSize(width), PosUIManager.getSize(height), Image.SCALE_SMOOTH);
			return new ImageIcon(scaledImage);
		}
		else {
			int height = 200;
			int width = (iconWidth * height) / iconHeight;
			Image scaledImage = imageIcon.getImage().getScaledInstance(PosUIManager.getSize(width), PosUIManager.getSize(height), Image.SCALE_SMOOTH);
			return new ImageIcon(scaledImage);
		}
	}

	@XmlTransient
	public Image getImage() {
		byte[] imageData = getImageBytes();
		if (imageData == null) {
			return null;
		}
		return new ImageIcon(imageData).getImage();
	}

	public ImageIcon getImageIcon() {
		byte[] imageData = getImageBytes();
		if (imageData == null) {
			return null;
		}
		return new ImageIcon(imageData);
	}

	@XmlTransient
	public ImageIcon getAsIcon() {
		byte[] imageData = getImageBytes();
		if (imageData == null) {
			return null;
		}
		return getButtonImage();
	}
	
	@Override
	public void setProperties(String properties) {
		this.propertiesContainer = null;
		super.setProperties(properties);
	}

	@Override
	public void updateProperties(String properties) {
		super.setProperties(properties);
	}
	
	@Override
	public JsonObject getPropertyStore() {
		if (propertiesContainer == null) {
			if (StringUtils.isBlank(super.getProperties())) {
				propertiesContainer = new com.google.gson.JsonObject();
			}
			else {
				propertiesContainer = new Gson().fromJson(super.getProperties(), com.google.gson.JsonObject.class);
			}
		}
		return propertiesContainer;
	}
}