package com.floreantpos.model;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;

public interface PropertyContainer {
	@JsonIgnore
	public abstract JsonObject getPropertyStore();

	public default boolean hasProperty(String key) {
		return this.getPropertyStore().has(key);
	}

	public default String getProperty(String key) {
		if (this.getPropertyStore().has(key)) {
			JsonElement jsonElement = this.getPropertyStore().get(key);
			if (jsonElement instanceof JsonNull) {
				return null;
			}
			return jsonElement.getAsString();
		}
		return null;
	}

	public default String getProperty(String key, String defaultValue) {
		if (this.getPropertyStore().has(key)) {
			return this.getPropertyStore().get(key).getAsString();
		}
		return defaultValue;
	}

	public default Boolean getBooleanProperty(String key, boolean defaultValue) {
		JsonElement string = getPropertyStore().get(key);
		if (string == null) {
			return defaultValue;
		}
		return string.getAsBoolean();
	}
	
	public default double getDoubleProperty(String key) {
		return parseDouble(getProperty(key));
	}
	
	public default int getIntProperty(String key) {
		return (int) parseDouble(getProperty(key));
	}

	public default void addProperty(String key, String value) {
		this.getPropertyStore().addProperty(key, value);
	}

	public default void removeProperty(String propertyName) {
		if (this.getPropertyStore() != null) {
			this.getPropertyStore().remove(propertyName);
		}
	}
	
	public static double parseDouble(String s) {
		if (StringUtils.isBlank(s)) {
			return 0;
		}
		
		try {
			return Double.parseDouble(s);
		} catch (Exception x) {
			return 0;
		}
	}
}
