/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.model;

import java.util.Iterator;
import java.util.List;

import javax.xml.bind.annotation.XmlRootElement;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.Messages;
import com.floreantpos.model.base.BaseVirtualPrinter;
import com.google.gson.Gson;
import com.google.gson.JsonObject;

@JsonIgnoreProperties(ignoreUnknown = true, value = { "kdsPrinter" })
@XmlRootElement
public class VirtualPrinter extends BaseVirtualPrinter implements TimedModel, PropertyContainer {
	private static final long serialVersionUID = 1L;

	public final static int REPORT = 0;
	public final static int RECEIPT = 1;
	public final static int KITCHEN = 2;
	public final static int PACKING = 3;
	public final static int KITCHEN_DISPLAY = 4;
	public final static int LABEL = 5;
	public final static int STICKER = 6;

	private static Printer kdsPrinter;
	private transient JsonObject propertiesContainer;
	public static final String BEEP_AFTER_PRINT_TO_KITCHEN_IS_DONE = "beep_after_print_to_kitchen_is_done "; //$NON-NLS-1$

	public final static String[] PRINTER_TYPE_NAMES = { Messages.getString("VirtualPrinter.0"), Messages.getString("VirtualPrinter.1"), //$NON-NLS-1$//$NON-NLS-2$
			Messages.getString("VirtualPrinter.2"), Messages.getString("VirtualPrinter.3"), "", Messages.getString("VirtualPrinter.5"), //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$
			Messages.getString("VirtualPrinter.6") }; //$NON-NLS-1$

	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public VirtualPrinter () {
    }

	/**
	 * Constructor for primary key
	 */
	public VirtualPrinter (java.lang.String id) {
		super(id);
	}

	/**
	 * Constructor for required fields
	 */
	public VirtualPrinter (
		java.lang.String id,
		java.lang.String name) {

		super (
			id,
			name);
	}

	/*[CONSTRUCTOR MARKER END]*/

	@Override
	public int hashCode() {
		return getName().hashCode();
	}

	@Override
	public boolean equals(Object obj) {
		if (!(obj instanceof VirtualPrinter)) {
			return false;
		}

		VirtualPrinter other = (VirtualPrinter) obj;

		return this.getName().equalsIgnoreCase(other.getName());
	}

	public String getDisplayName() {
		return PRINTER_TYPE_NAMES[getType()];
	}

	public static Printer getKdsPrinter() {
		if (kdsPrinter == null) {
			VirtualPrinter kdsVPrinter = new VirtualPrinter();
			kdsVPrinter.setName("kds");//$NON-NLS-1$ 
			kdsVPrinter.setType(VirtualPrinter.KITCHEN_DISPLAY);

			kdsPrinter = new Printer(kdsVPrinter, "kds");//$NON-NLS-1$ 
		}
		return kdsPrinter;
	}

	@Override
	public String toString() {
		String name = getName();

		List<String> typeNames = getOrderTypeNames();
		if (typeNames != null && typeNames.size() > 0) {
			name += " ("; //$NON-NLS-1$

			for (Iterator iterator = typeNames.iterator(); iterator.hasNext();) {
				String string = (String) iterator.next();
				name += string;
				if (iterator.hasNext()) {
					name += ", "; //$NON-NLS-1$
				}
			}
			name += ")"; //$NON-NLS-1$
		}

		return name;
	}
	
	/*[CONSTRUCTOR MARKER END]*/
	@Override
	public String getProperties() {
		if (propertiesContainer != null) {
			return propertiesContainer.toString();
		}

		String properties = super.getProperties();
		if (StringUtils.isEmpty(properties)) {
			return null;
		}

		propertiesContainer = new Gson().fromJson(properties, JsonObject.class);
		return properties;
	}

	@Override
	public void setProperties(String properties) {
		super.setProperties(properties);
		propertiesContainer = new Gson().fromJson(properties, JsonObject.class);
	}

	@Override
	public JsonObject getPropertyStore() {
		if (propertiesContainer == null) {
			propertiesContainer = new JsonObject();
		}
		return propertiesContainer;
	}

	public boolean isBeepAfterPrintToKitchenIsDone() {
		return getBooleanProperty(BEEP_AFTER_PRINT_TO_KITCHEN_IS_DONE, false);
	}

	public void setBeepAfterPrintToKitchenIsDone(boolean isbeepAfterPrintToKitchenIsDone) {
		addProperty(BEEP_AFTER_PRINT_TO_KITCHEN_IS_DONE, String.valueOf(isbeepAfterPrintToKitchenIsDone));
	}
	
}