package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the TRANSACTIONS table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="TRANSACTIONS"
 */

public abstract class BasePosTransaction  implements Comparable, Serializable {

	public static String REF = "PosTransaction"; //$NON-NLS-1$
	public static String PROP_CARD_NUMBER = "cardNumber"; //$NON-NLS-1$
	public static String PROP_SERVICE_CHARGE_AMOUNT = "serviceChargeAmount"; //$NON-NLS-1$
	public static String PROP_TOLERANCE_AMOUNT = "toleranceAmount"; //$NON-NLS-1$
	public static String PROP_GIFT_CERT_PAID_AMOUNT = "giftCertPaidAmount"; //$NON-NLS-1$
	public static String PROP_CARD_HOLDER_NAME = "cardHolderName"; //$NON-NLS-1$
	public static String PROP_TAX_AMOUNT = "taxAmount"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_CARD_READER = "cardReader"; //$NON-NLS-1$
	public static String PROP_EXTRA_PROPERTIES = "extraProperties"; //$NON-NLS-1$
	public static String PROP_AUTHORIZABLE = "authorizable"; //$NON-NLS-1$
	public static String PROP_TERMINAL_ID = "terminalId"; //$NON-NLS-1$
	public static String PROP_REASON_ID = "reasonId"; //$NON-NLS-1$
	public static String PROP_CAPTURED = "captured"; //$NON-NLS-1$
	public static String PROP_CARD_TRANSACTION_ID = "cardTransactionId"; //$NON-NLS-1$
	public static String PROP_CARD_MERCHANT_GATEWAY = "cardMerchantGateway"; //$NON-NLS-1$
	public static String PROP_TENDER_AMOUNT = "tenderAmount"; //$NON-NLS-1$
	public static String PROP_CUSTOMER_ID = "customerId"; //$NON-NLS-1$
	public static String PROP_GIFT_CERT_CASH_BACK_AMOUNT = "giftCertCashBackAmount"; //$NON-NLS-1$
	public static String PROP_CLOUD_SYNCED = "cloudSynced"; //$NON-NLS-1$
	public static String PROP_NOTE = "note"; //$NON-NLS-1$
	public static String PROP_DATA_VERSION = "dataVersion"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_TRANSACTION_TYPE = "transactionType"; //$NON-NLS-1$
	public static String PROP_CARD_AUTH_CODE = "cardAuthCode"; //$NON-NLS-1$
	public static String PROP_GIFT_CERT_NUMBER = "giftCertNumber"; //$NON-NLS-1$
	public static String PROP_CUSTOM_PAYMENT_FIELD_NAME = "customPaymentFieldName"; //$NON-NLS-1$
	public static String PROP_RECEPIENT_ID = "recepientId"; //$NON-NLS-1$
	public static String PROP_HAS_SYNC_ERROR = "hasSyncError"; //$NON-NLS-1$
	public static String PROP_CUSTOM_PAYMENT_REF = "customPaymentRef"; //$NON-NLS-1$
	public static String PROP_CUSTOMER_BALANCE_BEFORE = "customerBalanceBefore"; //$NON-NLS-1$
	public static String PROP_GIFT_CERT_FACE_VALUE = "giftCertFaceValue"; //$NON-NLS-1$
	public static String PROP_SERVER_ID = "serverId"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_CARD_TYPE = "cardType"; //$NON-NLS-1$
	public static String PROP_CASH_DRAWER_ID = "cashDrawerId"; //$NON-NLS-1$
	public static String PROP_DRAWER_RESETTED = "drawerResetted"; //$NON-NLS-1$
	public static String PROP_CUSTOM_PAYMENT_NAME = "customPaymentName"; //$NON-NLS-1$
	public static String PROP_PAYMENT_TYPE_STRING = "paymentTypeString"; //$NON-NLS-1$
	public static String PROP_STORE_SESSION_ID = "storeSessionId"; //$NON-NLS-1$
	public static String PROP_VOIDED = "voided"; //$NON-NLS-1$
	public static String PROP_FEE_AMOUNT = "feeAmount"; //$NON-NLS-1$
	public static String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$
	public static String PROP_TICKET = "ticket"; //$NON-NLS-1$
	public static String PROP_AMOUNT = "amount"; //$NON-NLS-1$
	public static String PROP_TIPS_AMOUNT = "tipsAmount"; //$NON-NLS-1$
	public static String PROP_CUSTOM_PAYMENT_ID = "customPaymentId"; //$NON-NLS-1$
	public static String PROP_MARKED_CAPTURED = "markedCaptured"; //$NON-NLS-1$
	public static String PROP_TRANSACTION_TIME = "transactionTime"; //$NON-NLS-1$
	public static String PROP_USER_ID = "userId"; //$NON-NLS-1$
	public static String PROP_CHANGE_AMOUNT = "changeAmount"; //$NON-NLS-1$
	public static String PROP_CUSTOMER_BALANCE_AFTER = "customerBalanceAfter"; //$NON-NLS-1$
	public static String PROP_DEPARTMENT_ID = "departmentId"; //$NON-NLS-1$


	// constructors
	public BasePosTransaction () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BasePosTransaction (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	/**
	 * Constructor for required fields
	 */
	public BasePosTransaction (
		java.lang.String id,
		java.lang.String transactionType,
		java.lang.String paymentTypeString) {

		this.setId(id);
		this.setTransactionType(transactionType);
		this.setPaymentTypeString(paymentTypeString);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	 long version;

	// fields
			private java.lang.Integer dataVersion;
				private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.util.Date transactionTime;
				private java.lang.Double amount;
				private java.lang.Double taxAmount;
				private java.lang.Double serviceChargeAmount;
				private java.lang.Double tipsAmount;
				private java.lang.Double tenderAmount;
				private java.lang.Double toleranceAmount;
				private java.lang.Double changeAmount;
				private java.lang.Double feeAmount;
				private java.lang.String transactionType;
				private java.lang.Boolean voided;
				private java.lang.String paymentTypeString;
				private java.lang.Boolean captured;
				private java.lang.Boolean markedCaptured;
				private java.lang.Boolean authorizable;
				private java.lang.String cardHolderName;
				private java.lang.String cardNumber;
				private java.lang.String cardAuthCode;
				private java.lang.String cardType;
				private java.lang.String cardTransactionId;
				private java.lang.String cardMerchantGateway;
				private java.lang.String cardReader;
				private java.lang.String giftCertNumber;
				private java.lang.Double giftCertFaceValue;
				private java.lang.Double giftCertPaidAmount;
				private java.lang.Double giftCertCashBackAmount;
				private java.lang.String customerId;
				private java.lang.Double customerBalanceBefore;
				private java.lang.Double customerBalanceAfter;
				private java.lang.Boolean drawerResetted;
				private java.lang.String note;
				private java.lang.String outletId;
				private java.lang.String departmentId;
				private java.lang.Integer terminalId;
				private java.lang.String userId;
				private java.lang.String serverId;
				private java.lang.String cashDrawerId;
				private java.lang.String reasonId;
				private java.lang.String recepientId;
				private java.lang.Boolean cloudSynced;
				private java.lang.Boolean hasSyncError;
				private java.lang.String customPaymentId;
				private java.lang.String customPaymentName;
				private java.lang.String customPaymentRef;
				private java.lang.String customPaymentFieldName;
				private java.lang.String storeSessionId;
				private java.lang.String extraProperties;
	
	// many to one
	private com.floreantpos.model.Ticket ticket;

	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.GlobalIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */

	public long getVersion () {
			return version;
	}



	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: DATA_VERSION
	 */

	public java.lang.Integer getDataVersion () {
						return dataVersion == null ? Integer.valueOf(0) : dataVersion;
		}



	/**
	 * Set the value related to the column: DATA_VERSION
	 * @param dataVersion the DATA_VERSION value
	 */
			public void setDataVersion (java.lang.Integer dataVersion) {
			this.dataVersion = dataVersion;
	}



	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: TRANSACTION_TIME
	 */

	public java.util.Date getTransactionTime () {
			return transactionTime;
	}



	/**
	 * Set the value related to the column: TRANSACTION_TIME
	 * @param transactionTime the TRANSACTION_TIME value
	 */
			public void setTransactionTime (java.util.Date transactionTime) {
			this.transactionTime = transactionTime;
	}



	/**
	 * Return the value associated with the column: AMOUNT
	 */

	public java.lang.Double getAmount () {
						return amount == null ? Double.valueOf(0) : amount;
		}



	/**
	 * Set the value related to the column: AMOUNT
	 * @param amount the AMOUNT value
	 */
			public void setAmount (java.lang.Double amount) {
			this.amount = amount;
	}



	/**
	 * Return the value associated with the column: TAX_AMOUNT
	 */

	public java.lang.Double getTaxAmount () {
						return taxAmount == null ? Double.valueOf(0) : taxAmount;
		}



	/**
	 * Set the value related to the column: TAX_AMOUNT
	 * @param taxAmount the TAX_AMOUNT value
	 */
			public void setTaxAmount (java.lang.Double taxAmount) {
			this.taxAmount = taxAmount;
	}



	/**
	 * Return the value associated with the column: SERVICE_CHARGE_AMOUNT
	 */

	public java.lang.Double getServiceChargeAmount () {
						return serviceChargeAmount == null ? Double.valueOf(0) : serviceChargeAmount;
		}



	/**
	 * Set the value related to the column: SERVICE_CHARGE_AMOUNT
	 * @param serviceChargeAmount the SERVICE_CHARGE_AMOUNT value
	 */
			public void setServiceChargeAmount (java.lang.Double serviceChargeAmount) {
			this.serviceChargeAmount = serviceChargeAmount;
	}



	/**
	 * Return the value associated with the column: TIPS_AMOUNT
	 */

	public java.lang.Double getTipsAmount () {
						return tipsAmount == null ? Double.valueOf(0) : tipsAmount;
		}



	/**
	 * Set the value related to the column: TIPS_AMOUNT
	 * @param tipsAmount the TIPS_AMOUNT value
	 */
			public void setTipsAmount (java.lang.Double tipsAmount) {
			this.tipsAmount = tipsAmount;
	}



	/**
	 * Return the value associated with the column: TENDER_AMOUNT
	 */

	public java.lang.Double getTenderAmount () {
						return tenderAmount == null ? Double.valueOf(0) : tenderAmount;
		}



	/**
	 * Set the value related to the column: TENDER_AMOUNT
	 * @param tenderAmount the TENDER_AMOUNT value
	 */
			public void setTenderAmount (java.lang.Double tenderAmount) {
			this.tenderAmount = tenderAmount;
	}



	/**
	 * Return the value associated with the column: TOLERANCE_AMOUNT
	 */

	public java.lang.Double getToleranceAmount () {
						return toleranceAmount == null ? Double.valueOf(0) : toleranceAmount;
		}



	/**
	 * Set the value related to the column: TOLERANCE_AMOUNT
	 * @param toleranceAmount the TOLERANCE_AMOUNT value
	 */
			public void setToleranceAmount (java.lang.Double toleranceAmount) {
			this.toleranceAmount = toleranceAmount;
	}



	/**
	 * Return the value associated with the column: CHANGE_AMOUNT
	 */

	public java.lang.Double getChangeAmount () {
						return changeAmount == null ? Double.valueOf(0) : changeAmount;
		}



	/**
	 * Set the value related to the column: CHANGE_AMOUNT
	 * @param changeAmount the CHANGE_AMOUNT value
	 */
			public void setChangeAmount (java.lang.Double changeAmount) {
			this.changeAmount = changeAmount;
	}



	/**
	 * Return the value associated with the column: FEE_AMOUNT
	 */

	public java.lang.Double getFeeAmount () {
						return feeAmount == null ? Double.valueOf(0) : feeAmount;
		}



	/**
	 * Set the value related to the column: FEE_AMOUNT
	 * @param feeAmount the FEE_AMOUNT value
	 */
			public void setFeeAmount (java.lang.Double feeAmount) {
			this.feeAmount = feeAmount;
	}



	/**
	 * Return the value associated with the column: TRANSACTION_TYPE
	 */

	public java.lang.String getTransactionType () {
			return transactionType;
	}



	/**
	 * Set the value related to the column: TRANSACTION_TYPE
	 * @param transactionType the TRANSACTION_TYPE value
	 */
			public void setTransactionType (java.lang.String transactionType) {
			this.transactionType = transactionType;
	}



	/**
	 * Return the value associated with the column: VOIDED
	 */

	public java.lang.Boolean isVoided () {
					return voided == null ? Boolean.FALSE : voided;
		}

	public java.lang.Boolean getVoided () {
				return voided == null ? Boolean.FALSE : voided;
			}


	/**
	 * Set the value related to the column: VOIDED
	 * @param voided the VOIDED value
	 */
			public void setVoided (java.lang.Boolean voided) {
			this.voided = voided;
	}



	/**
	 * Return the value associated with the column: PAYMENT_TYPE
	 */

	public java.lang.String getPaymentTypeString () {
			return paymentTypeString;
	}



	/**
	 * Set the value related to the column: PAYMENT_TYPE
	 * @param paymentTypeString the PAYMENT_TYPE value
	 */
			public void setPaymentTypeString (java.lang.String paymentTypeString) {
			this.paymentTypeString = paymentTypeString;
	}



	/**
	 * Return the value associated with the column: CAPTURED
	 */

	public java.lang.Boolean isCaptured () {
					return captured == null ? Boolean.FALSE : captured;
		}

	public java.lang.Boolean getCaptured () {
				return captured == null ? Boolean.FALSE : captured;
			}


	/**
	 * Set the value related to the column: CAPTURED
	 * @param captured the CAPTURED value
	 */
			public void setCaptured (java.lang.Boolean captured) {
			this.captured = captured;
	}



	/**
	 * Return the value associated with the column: MARKED_CAPTURED
	 */

	public java.lang.Boolean isMarkedCaptured () {
					return markedCaptured == null ? Boolean.FALSE : markedCaptured;
		}

	public java.lang.Boolean getMarkedCaptured () {
				return markedCaptured == null ? Boolean.FALSE : markedCaptured;
			}


	/**
	 * Set the value related to the column: MARKED_CAPTURED
	 * @param markedCaptured the MARKED_CAPTURED value
	 */
			public void setMarkedCaptured (java.lang.Boolean markedCaptured) {
			this.markedCaptured = markedCaptured;
	}



	/**
	 * Return the value associated with the column: AUTHORIZABLE
	 */

	public java.lang.Boolean isAuthorizable () {
					return authorizable == null ? Boolean.FALSE : authorizable;
		}

	public java.lang.Boolean getAuthorizable () {
				return authorizable == null ? Boolean.FALSE : authorizable;
			}


	/**
	 * Set the value related to the column: AUTHORIZABLE
	 * @param authorizable the AUTHORIZABLE value
	 */
			public void setAuthorizable (java.lang.Boolean authorizable) {
			this.authorizable = authorizable;
	}



	/**
	 * Return the value associated with the column: CARD_HOLDER_NAME
	 */

	public java.lang.String getCardHolderName () {
			return cardHolderName;
	}



	/**
	 * Set the value related to the column: CARD_HOLDER_NAME
	 * @param cardHolderName the CARD_HOLDER_NAME value
	 */
			public void setCardHolderName (java.lang.String cardHolderName) {
			this.cardHolderName = cardHolderName;
	}



	/**
	 * Return the value associated with the column: CARD_NUMBER
	 */

	public java.lang.String getCardNumber () {
			return cardNumber;
	}



	/**
	 * Set the value related to the column: CARD_NUMBER
	 * @param cardNumber the CARD_NUMBER value
	 */
			public void setCardNumber (java.lang.String cardNumber) {
			this.cardNumber = cardNumber;
	}



	/**
	 * Return the value associated with the column: CARD_AUTH_CODE
	 */

	public java.lang.String getCardAuthCode () {
			return cardAuthCode;
	}



	/**
	 * Set the value related to the column: CARD_AUTH_CODE
	 * @param cardAuthCode the CARD_AUTH_CODE value
	 */
			public void setCardAuthCode (java.lang.String cardAuthCode) {
			this.cardAuthCode = cardAuthCode;
	}



	/**
	 * Return the value associated with the column: CARD_TYPE
	 */

	public java.lang.String getCardType () {
			return cardType;
	}



	/**
	 * Set the value related to the column: CARD_TYPE
	 * @param cardType the CARD_TYPE value
	 */
			public void setCardType (java.lang.String cardType) {
			this.cardType = cardType;
	}



	/**
	 * Return the value associated with the column: CARD_TRANSACTION_ID
	 */

	public java.lang.String getCardTransactionId () {
			return cardTransactionId;
	}



	/**
	 * Set the value related to the column: CARD_TRANSACTION_ID
	 * @param cardTransactionId the CARD_TRANSACTION_ID value
	 */
			public void setCardTransactionId (java.lang.String cardTransactionId) {
			this.cardTransactionId = cardTransactionId;
	}



	/**
	 * Return the value associated with the column: CARD_MERCHANT_GATEWAY
	 */

	public java.lang.String getCardMerchantGateway () {
			return cardMerchantGateway;
	}



	/**
	 * Set the value related to the column: CARD_MERCHANT_GATEWAY
	 * @param cardMerchantGateway the CARD_MERCHANT_GATEWAY value
	 */
			public void setCardMerchantGateway (java.lang.String cardMerchantGateway) {
			this.cardMerchantGateway = cardMerchantGateway;
	}



	/**
	 * Return the value associated with the column: CARD_READER
	 */

	public java.lang.String getCardReader () {
			return cardReader;
	}



	/**
	 * Set the value related to the column: CARD_READER
	 * @param cardReader the CARD_READER value
	 */
			public void setCardReader (java.lang.String cardReader) {
			this.cardReader = cardReader;
	}



	/**
	 * Return the value associated with the column: GIFT_CERT_NUMBER
	 */

	public java.lang.String getGiftCertNumber () {
			return giftCertNumber;
	}



	/**
	 * Set the value related to the column: GIFT_CERT_NUMBER
	 * @param giftCertNumber the GIFT_CERT_NUMBER value
	 */
			public void setGiftCertNumber (java.lang.String giftCertNumber) {
			this.giftCertNumber = giftCertNumber;
	}



	/**
	 * Return the value associated with the column: GIFT_CERT_FACE_VALUE
	 */

	public java.lang.Double getGiftCertFaceValue () {
						return giftCertFaceValue == null ? Double.valueOf(0) : giftCertFaceValue;
		}



	/**
	 * Set the value related to the column: GIFT_CERT_FACE_VALUE
	 * @param giftCertFaceValue the GIFT_CERT_FACE_VALUE value
	 */
			public void setGiftCertFaceValue (java.lang.Double giftCertFaceValue) {
			this.giftCertFaceValue = giftCertFaceValue;
	}



	/**
	 * Return the value associated with the column: GIFT_CERT_PAID_AMOUNT
	 */

	public java.lang.Double getGiftCertPaidAmount () {
						return giftCertPaidAmount == null ? Double.valueOf(0) : giftCertPaidAmount;
		}



	/**
	 * Set the value related to the column: GIFT_CERT_PAID_AMOUNT
	 * @param giftCertPaidAmount the GIFT_CERT_PAID_AMOUNT value
	 */
			public void setGiftCertPaidAmount (java.lang.Double giftCertPaidAmount) {
			this.giftCertPaidAmount = giftCertPaidAmount;
	}



	/**
	 * Return the value associated with the column: GIFT_CERT_CASH_BACK_AMOUNT
	 */

	public java.lang.Double getGiftCertCashBackAmount () {
						return giftCertCashBackAmount == null ? Double.valueOf(0) : giftCertCashBackAmount;
		}



	/**
	 * Set the value related to the column: GIFT_CERT_CASH_BACK_AMOUNT
	 * @param giftCertCashBackAmount the GIFT_CERT_CASH_BACK_AMOUNT value
	 */
			public void setGiftCertCashBackAmount (java.lang.Double giftCertCashBackAmount) {
			this.giftCertCashBackAmount = giftCertCashBackAmount;
	}



	/**
	 * Return the value associated with the column: CUSTOMER_ID
	 */

	public java.lang.String getCustomerId () {
			return customerId;
	}



	/**
	 * Set the value related to the column: CUSTOMER_ID
	 * @param customerId the CUSTOMER_ID value
	 */
			public void setCustomerId (java.lang.String customerId) {
			this.customerId = customerId;
	}



	/**
	 * Return the value associated with the column: CUSTOMER_BALANCE_BEFORE
	 */

	public java.lang.Double getCustomerBalanceBefore () {
						return customerBalanceBefore == null ? Double.valueOf(0) : customerBalanceBefore;
		}



	/**
	 * Set the value related to the column: CUSTOMER_BALANCE_BEFORE
	 * @param customerBalanceBefore the CUSTOMER_BALANCE_BEFORE value
	 */
			public void setCustomerBalanceBefore (java.lang.Double customerBalanceBefore) {
			this.customerBalanceBefore = customerBalanceBefore;
	}



	/**
	 * Return the value associated with the column: CUSTOMER_BALANCE_AFTER
	 */

	public java.lang.Double getCustomerBalanceAfter () {
						return customerBalanceAfter == null ? Double.valueOf(0) : customerBalanceAfter;
		}



	/**
	 * Set the value related to the column: CUSTOMER_BALANCE_AFTER
	 * @param customerBalanceAfter the CUSTOMER_BALANCE_AFTER value
	 */
			public void setCustomerBalanceAfter (java.lang.Double customerBalanceAfter) {
			this.customerBalanceAfter = customerBalanceAfter;
	}



	/**
	 * Return the value associated with the column: DRAWER_RESETTED
	 */

	public java.lang.Boolean isDrawerResetted () {
					return drawerResetted == null ? Boolean.FALSE : drawerResetted;
		}

	public java.lang.Boolean getDrawerResetted () {
				return drawerResetted == null ? Boolean.FALSE : drawerResetted;
			}


	/**
	 * Set the value related to the column: DRAWER_RESETTED
	 * @param drawerResetted the DRAWER_RESETTED value
	 */
			public void setDrawerResetted (java.lang.Boolean drawerResetted) {
			this.drawerResetted = drawerResetted;
	}



	/**
	 * Return the value associated with the column: NOTE
	 */

	public java.lang.String getNote () {
			return note;
	}



	/**
	 * Set the value related to the column: NOTE
	 * @param note the NOTE value
	 */
			public void setNote (java.lang.String note) {
			this.note = note;
	}



	/**
	 * Return the value associated with the column: OUTLET_ID
	 */

	public java.lang.String getOutletId () {
			return outletId;
	}



	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
			public void setOutletId (java.lang.String outletId) {
			this.outletId = outletId;
	}



	/**
	 * Return the value associated with the column: DEPARTMENT_ID
	 */

	public java.lang.String getDepartmentId () {
			return departmentId;
	}



	/**
	 * Set the value related to the column: DEPARTMENT_ID
	 * @param departmentId the DEPARTMENT_ID value
	 */
			public void setDepartmentId (java.lang.String departmentId) {
			this.departmentId = departmentId;
	}



	/**
	 * Return the value associated with the column: TERMINAL_ID
	 */

	public java.lang.Integer getTerminalId () {
						return terminalId == null ? Integer.valueOf(0) : terminalId;
		}



	/**
	 * Set the value related to the column: TERMINAL_ID
	 * @param terminalId the TERMINAL_ID value
	 */
			public void setTerminalId (java.lang.Integer terminalId) {
			this.terminalId = terminalId;
	}



	/**
	 * Return the value associated with the column: USER_ID
	 */

	public java.lang.String getUserId () {
			return userId;
	}



	/**
	 * Set the value related to the column: USER_ID
	 * @param userId the USER_ID value
	 */
			public void setUserId (java.lang.String userId) {
			this.userId = userId;
	}



	/**
	 * Return the value associated with the column: SERVER_ID
	 */

	public java.lang.String getServerId () {
			return serverId;
	}



	/**
	 * Set the value related to the column: SERVER_ID
	 * @param serverId the SERVER_ID value
	 */
			public void setServerId (java.lang.String serverId) {
			this.serverId = serverId;
	}



	/**
	 * Return the value associated with the column: CASH_DRAWER_ID
	 */

	public java.lang.String getCashDrawerId () {
			return cashDrawerId;
	}



	/**
	 * Set the value related to the column: CASH_DRAWER_ID
	 * @param cashDrawerId the CASH_DRAWER_ID value
	 */
			public void setCashDrawerId (java.lang.String cashDrawerId) {
			this.cashDrawerId = cashDrawerId;
	}



	/**
	 * Return the value associated with the column: PAYOUT_REASON_ID
	 */

	public java.lang.String getReasonId () {
			return reasonId;
	}



	/**
	 * Set the value related to the column: PAYOUT_REASON_ID
	 * @param reasonId the PAYOUT_REASON_ID value
	 */
			public void setReasonId (java.lang.String reasonId) {
			this.reasonId = reasonId;
	}



	/**
	 * Return the value associated with the column: PAYOUT_RECEPIENT_ID
	 */

	public java.lang.String getRecepientId () {
			return recepientId;
	}



	/**
	 * Set the value related to the column: PAYOUT_RECEPIENT_ID
	 * @param recepientId the PAYOUT_RECEPIENT_ID value
	 */
			public void setRecepientId (java.lang.String recepientId) {
			this.recepientId = recepientId;
	}



	/**
	 * Return the value associated with the column: CLOUD_SYNCED
	 */

	public java.lang.Boolean isCloudSynced () {
					return cloudSynced == null ? Boolean.FALSE : cloudSynced;
		}

	public java.lang.Boolean getCloudSynced () {
				return cloudSynced == null ? Boolean.FALSE : cloudSynced;
			}


	/**
	 * Set the value related to the column: CLOUD_SYNCED
	 * @param cloudSynced the CLOUD_SYNCED value
	 */
			public void setCloudSynced (java.lang.Boolean cloudSynced) {
			this.cloudSynced = cloudSynced;
	}



	/**
	 * Return the value associated with the column: HAS_SYNC_ERROR
	 */

	public java.lang.Boolean isHasSyncError () {
					return hasSyncError == null ? Boolean.FALSE : hasSyncError;
		}

	public java.lang.Boolean getHasSyncError () {
				return hasSyncError == null ? Boolean.FALSE : hasSyncError;
			}


	/**
	 * Set the value related to the column: HAS_SYNC_ERROR
	 * @param hasSyncError the HAS_SYNC_ERROR value
	 */
			public void setHasSyncError (java.lang.Boolean hasSyncError) {
			this.hasSyncError = hasSyncError;
	}



	/**
	 * Return the value associated with the column: CUSTOM_PAYMENT_ID
	 */

	public java.lang.String getCustomPaymentId () {
			return customPaymentId;
	}



	/**
	 * Set the value related to the column: CUSTOM_PAYMENT_ID
	 * @param customPaymentId the CUSTOM_PAYMENT_ID value
	 */
			public void setCustomPaymentId (java.lang.String customPaymentId) {
			this.customPaymentId = customPaymentId;
	}



	/**
	 * Return the value associated with the column: CUSTOM_PAYMENT_NAME
	 */

	public java.lang.String getCustomPaymentName () {
			return customPaymentName;
	}



	/**
	 * Set the value related to the column: CUSTOM_PAYMENT_NAME
	 * @param customPaymentName the CUSTOM_PAYMENT_NAME value
	 */
			public void setCustomPaymentName (java.lang.String customPaymentName) {
			this.customPaymentName = customPaymentName;
	}



	/**
	 * Return the value associated with the column: CUSTOM_PAYMENT_REF
	 */

	public java.lang.String getCustomPaymentRef () {
			return customPaymentRef;
	}



	/**
	 * Set the value related to the column: CUSTOM_PAYMENT_REF
	 * @param customPaymentRef the CUSTOM_PAYMENT_REF value
	 */
			public void setCustomPaymentRef (java.lang.String customPaymentRef) {
			this.customPaymentRef = customPaymentRef;
	}



	/**
	 * Return the value associated with the column: CUSTOM_PAYMENT_FIELD_NAME
	 */

	public java.lang.String getCustomPaymentFieldName () {
			return customPaymentFieldName;
	}



	/**
	 * Set the value related to the column: CUSTOM_PAYMENT_FIELD_NAME
	 * @param customPaymentFieldName the CUSTOM_PAYMENT_FIELD_NAME value
	 */
			public void setCustomPaymentFieldName (java.lang.String customPaymentFieldName) {
			this.customPaymentFieldName = customPaymentFieldName;
	}



	/**
	 * Return the value associated with the column: STORE_SESSION_ID
	 */

	public java.lang.String getStoreSessionId () {
			return storeSessionId;
	}



	/**
	 * Set the value related to the column: STORE_SESSION_ID
	 * @param storeSessionId the STORE_SESSION_ID value
	 */
			public void setStoreSessionId (java.lang.String storeSessionId) {
			this.storeSessionId = storeSessionId;
	}



	/**
	 * Return the value associated with the column: EXTRA_PROPERTIES
	 */

	public java.lang.String getExtraProperties () {
			return extraProperties;
	}



	/**
	 * Set the value related to the column: EXTRA_PROPERTIES
	 * @param extraProperties the EXTRA_PROPERTIES value
	 */
			public void setExtraProperties (java.lang.String extraProperties) {
			this.extraProperties = extraProperties;
	}



	/**
	 * Return the value associated with the column: TICKET_OUTLET_ID
	 */

	public com.floreantpos.model.Ticket getTicket () {
			return ticket;
	}



	/**
	 * Set the value related to the column: TICKET_OUTLET_ID
	 * @param ticket the TICKET_OUTLET_ID value
	 */
			public void setTicket (com.floreantpos.model.Ticket ticket) {
			this.ticket = ticket;
	}


	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.PosTransaction)) return false;
		else {
			com.floreantpos.model.PosTransaction posTransaction = (com.floreantpos.model.PosTransaction) obj;
			if (null == this.getId() || null == posTransaction.getId()) return this == obj;
			else return (this.getId().equals(posTransaction.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}