/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.db.update;

import java.sql.DriverManager;
import java.sql.SQLException;

import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;

import com.floreantpos.PosLog;
import com.floreantpos.model.Customer;

import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.resource.ClassLoaderResourceAccessor;

public class UpdateDBTo284 {

	private SessionFactory sessionFactory;
	private String dbConnectString;
	private String user;
	private String password;
	private String schemaName;

	public UpdateDBTo284(SessionFactory sessionFactory, String dbConnectString, String user, String password, String schemaName) {
		this.sessionFactory = sessionFactory;
		this.dbConnectString = dbConnectString;
		this.user = user;
		this.password = password;
		this.schemaName = schemaName;
	}

	public void update() throws Exception {
		//updateCustomer();
		executeLiquibaseUpdate();
	}

	private void updateCustomer() {
		try (Session session = sessionFactory.openSession()) {
			Transaction transaction = session.beginTransaction();
			Query query = session.createQuery("update " + Customer.REF + " set " + Customer.PROP_ACTIVE + "=true"); //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$
			int update = query.executeUpdate();
			PosLog.info(getClass(), "updated " + update + " customers"); //$NON-NLS-1$ //$NON-NLS-2$
			transaction.commit();
		}
	}

	private void executeLiquibaseUpdate() throws SQLException, DatabaseException, LiquibaseException {
		try (java.sql.Connection connection = DriverManager.getConnection(dbConnectString, user, password)) {
			Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation(new JdbcConnection(connection));
			if (!schemaName.equals("public")) {
				database.setDefaultSchemaName(schemaName);
			}

			Liquibase liquibase = new liquibase.Liquibase("db-changelog7.xml", new ClassLoaderResourceAccessor(), database); //$NON-NLS-1$
			liquibase.update(new Contexts(), new LabelExpression());

			PosLog.info(getClass(), "db-changelog7 successful for schema: " + schemaName);
		}
	}
}