package com.floreantpos.model.util;

import com.floreantpos.model.Customer;
import com.floreantpos.model.Ticket;

public class TicketUtil {

	public static void setCustomer(Ticket ticket, Customer customer) {
		if (customer == null) {
			ticket.removeCustomer();
			return;
		}

		ticket.setCustomerId(customer.getId());
		ticket.addProperty(Ticket.CUSTOMER_ID, String.valueOf(customer.getId()));
		ticket.addProperty(Ticket.CUSTOMER_NAME, customer.getFirstName());
		ticket.addProperty(Ticket.CUSTOMER_LAST_NAME, customer.getLastName());
		ticket.addProperty(Ticket.CUSTOMER_PHONE, customer.getMobileNo());
		ticket.addProperty(Ticket.CUSTOMER_ZIP_CODE, customer.getZipCode());
		ticket.addProperty(Ticket.CUSTOMER_TAX_EXEMPT, customer.isTaxExempt().toString());
	}
}
