package com.floreantpos.model;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.model.base.BaseAccessLog;
import com.google.gson.Gson;
import com.google.gson.JsonObject;

public class AccessLog extends BaseAccessLog implements PropertyContainer {
	private static final String JSON_PROP_PLUGIN_NAME = "plugin_name";

	private static final long serialVersionUID = 1L;

	private transient JsonObject propertiesContainer;

	public AccessLog() {
	}

	/**
	 * Constructor for primary key
	 */
	public AccessLog(java.lang.String id) {
		super(id);
	}

	@Override
	public JsonObject getPropertyStore() {
		if (propertiesContainer == null) {
			propertiesContainer = new JsonObject();
		}
		return propertiesContainer;
	}

	@Override
	public void setProperties(String properties) {
		super.setProperties(properties);
		propertiesContainer = new Gson().fromJson(properties, JsonObject.class);
	}

	@Override
	public String getProperties() {
		if (propertiesContainer != null) {
			return propertiesContainer.toString();
		}

		String properties = super.getProperties();
		if (StringUtils.isEmpty(properties)) {
			return null;
		}

		propertiesContainer = new Gson().fromJson(properties, JsonObject.class);
		return properties;
	}

	public void setPluginName(String pluginName) {
		addProperty(JSON_PROP_PLUGIN_NAME, pluginName);
	}

	public String getPluginName() {
		return getProperty(JSON_PROP_PLUGIN_NAME, "");
	}

}