package com.floreantpos.model;

import java.beans.Transient;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

import com.floreantpos.model.base.BaseStoreSession;
import com.floreantpos.model.util.DataProvider;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement
public class StoreSession extends BaseStoreSession implements TimedModel {
	private static final long serialVersionUID = 1L;

	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public StoreSession() {
	}

	/**
	 * Constructor for primary key
	 */
	public StoreSession(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/

	public User getClosedBy() {
		return DataProvider.get().getUserById(getClosedByUserId(), getOutletId());
	}

	public void setClosedBy(User user) {
		if (user == null) {
			setClosedByUserId(null);
		}
		else {
			setClosedByUserId(user.getId());
		}
	}

	public User getOpenedBy() {
		return DataProvider.get().getUserById(getOpenedByUserId(), getOutletId());
	}

	public void setOpenedBy(User user) {
		if (user == null) {
			setOpenedByUserId(null);
		}
		else {
			setOpenedByUserId(user.getId());
		}
	}

	@Transient
	public Outlet getOutlet() {
		Outlet outlet;
		String outletId = getOutletId();
		if (outletId == null)
			return null;
		outlet = (Outlet) DataProvider.get().getObjectOf(Outlet.class, outletId);
		return outlet;
	}

	@Transient
	public void setOutlet(Outlet outlet) {
		String outletId = null;
		if (outlet != null) {
			outletId = outlet.getId();
		}
		super.setOutletId(outletId);

	}

	public boolean isOpen() {
		return getCloseTime() == null;
	}

}