package com.floreantpos.model.util;

import com.google.gson.JsonObject;

public class PaymentMethodJsonExtractor {
	public static final String JSON_PROP_PAYMENT_TYPE_NAME = "payment_type_name";
	public static final String JSON_PROP_PAYMENT_GATEWAY_NAME = "gateway";

	public static final String PROP_PAYMENT_METHOD_COFIG_KEY = "configuration";

	public static final String PROP_PAYMENT_METHOD_STRIPE_API_KEY = "stripe.apikey";

	public static final String PROP_PAYMENT_METHOD_AUTHORIZE_DOT_NET_LOGIN_ID_KEY = "authorize_dot_net.loginId";
	public static final String PROP_PAYMENT_METHOD_AUTHORIZE_DOT_NET_TRANS_KEY = "authorize_dot_net_trans.transKey";
	public static final String PROP_PAYMENT_METHOD_AUTHORIZE_DOT_NET_CHKSANDBOXMODE_KEY = "authorize_dot_net_chksandboxmode.loginId";

	public static final String PROP_PAYMENT_METHOD_CARD_CONNECT_HOST_SYSTEM_KEY = "card_connect_host.hostSystem";
	public static final String PROP_PAYMENT_METHOD_CARD_CONNECT_MERCHANT_ID_KEY = "card_connect_merchant_id.merchantId";
	public static final String PROP_PAYMENT_METHOD_CARD_CONNECT_USER_NAME_KEY = "card_connect_user_name.userName";
	public static final String PROP_PAYMENT_METHOD_CARD_CONNECT_PASSWORD_KEY = "card_connect_password.password";

	public static final String PROP_PAYMENT_METHOD_CUSTOM_PAYMENT_NAME_KEY = "custom_payment.name";
	public static final String PROP_PAYMENT_METHOD_CUSTOM_PAYMENT_REFERENCE_FIELD_NAME_KEY = "custom_payment.referenceFieldName";
	public static final String PROP_PAYMENT_METHOD_CUSTOM_PAYMENT_IS_REQUIRED_NO_KEY = "custom_payment.isRequiredNo";
	public static final String PROP_PAYMENT_METHOD_CUSTOM_PAYMENT_IS_ENABLE_KEY = "custom_payment.isEnable";

	public static String getGatewayName(JsonObject jsonObject) {
		if (!jsonObject.has(JSON_PROP_PAYMENT_GATEWAY_NAME)) {
			return "";
		}

		return jsonObject.get(JSON_PROP_PAYMENT_GATEWAY_NAME) == null ? "" : jsonObject.get(JSON_PROP_PAYMENT_GATEWAY_NAME).getAsString();
	}

	public static String getPaymentType(JsonObject jsonObject) {
		return jsonObject.get(JSON_PROP_PAYMENT_TYPE_NAME) == null ? "" : jsonObject.get(JSON_PROP_PAYMENT_TYPE_NAME).getAsString();
	}
}
