/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.report;

import java.util.Date;

import com.floreantpos.model.User;

public class PayrollReportData {
	User user;

	Date date;
	Date from, to;
	double totalHour;
	double overtime;
	double rate, overtimeRate;
	double regularPayment, overtimePayment, totalPayment;
	Date fromDateOfWeek, toDateOfWeek;
	double totalDeclaredTips, totalNoCashTips;
	int firstDayOfWeek;

	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}

	public Date getFrom() {
		return from;
	}

	public void setFrom(Date from) {
		this.from = from;
	}

	public Date getTo() {
		return to;
	}

	public void setTo(Date to) {
		this.to = to;
	}

	public double getTotalHour() {
		return totalHour;
	}

	public void setTotalHour(double totalHour) {
		this.totalHour = totalHour;
	}

	public double getRate() {
		return rate;
	}

	public void setRate(double rate) {
		this.rate = rate;
	}

	public double getTotalPayment() {
		return totalPayment;
	}

	public void setTotalPayment(double payment) {
		this.totalPayment = payment;
	}

	public Date getDate() {
		return date;
	}

	public void setDate(Date date) {
		this.date = date;
	}

	public void calculate() {
		long fromTime = from.getTime();
		long toTime = to.getTime();

		long milliseconds = toTime - fromTime;
		if (milliseconds < 0) {
			totalHour = 0;
			return;
		}

		double seconds = milliseconds / 1000.0;
		double minutes = seconds / 60.0;
		double hours = minutes / 60.0;

		double diff = toTime - fromTime;
		diff = diff / (1000 * 60 * 60 * 24);
		totalHour = hours;
		rate = user.getCostPerHour();
		totalPayment = totalHour * rate;
	}

	private static final int SECOND = 1000;
	private static final int MINUTE = 60 * SECOND;
	private static final int HOUR = 60 * MINUTE;
	private static final int DAY = 24 * HOUR;

	public void calculateTotalHour() {
		long fromTime = from.getTime();
		long toTime = to.getTime();

		long milliseconds = toTime - fromTime;
		long totalWorkHour = milliseconds / 3600000;

		long regularWHInms = 40 * 3600000;
		long overTimeWHms = milliseconds - regularWHInms;

		if (milliseconds < 0) {
			totalHour = 0;
			return;
		}

		double seconds = milliseconds / 1000.0;
		double minutes = seconds / 60.0;
		double hours = minutes / 60.0;

		double diff = toTime - fromTime;
		diff = diff / (1000 * 60 * 60 * 24);
		totalHour += hours;
		overtime = (totalHour > 40) ? totalHour - 40 : 0;
		rate = user.getCostPerHour();
		overtimeRate = user.getOvertimeRatePerHour();
		regularPayment = (totalHour - overtime) * rate;
		overtimePayment = overtime * overtimeRate;
		totalPayment = regularPayment + overtimePayment;
		//		System.out.println("total hour: " + totalHour + "; rate: " + rate + "; overtimehour: " + overtime + "; overtimerate: " + overtimeRate + "; payment: " + payment);
	}

	public Date getFromDateOfWeek() {
		return fromDateOfWeek;
	}

	public void setFromDateOfWeek(Date fromDateOfWeek) {
		this.fromDateOfWeek = fromDateOfWeek;
	}

	public Date getToDateOfWeek() {
		return toDateOfWeek;
	}

	public void setToDateOfWeek(Date toDateOfWeek) {
		this.toDateOfWeek = toDateOfWeek;
	}

	public double getOvertime() {
		return overtime;
	}

	public void setOvertime(double overtime) {
		this.overtime = overtime;
	}

	public double getOvertimeRate() {
		return overtimeRate;
	}

	public void setOvertimeRate(double overtimeRate) {
		this.overtimeRate = overtimeRate;
	}

	public double getRegularPayment() {
		return regularPayment;
	}

	public void setRegularPayment(double regularPayment) {
		this.regularPayment = regularPayment;
	}

	public double getOvertimePayment() {
		return overtimePayment;
	}

	public void setOvertimePayment(double overtimePayment) {
		this.overtimePayment = overtimePayment;
	}

	public double getTotalDeclaredTips() {
		return totalDeclaredTips;
	}

	public void setTotalDeclaredTips(double totalDeclaredTips) {
		this.totalDeclaredTips = totalDeclaredTips;
	}

	public double getTotalNoCashTips() {
		return totalNoCashTips;
	}

	public void setTotalNoCashTips(double totalNoCashTips) {
		this.totalNoCashTips = totalNoCashTips;
	}

	public int getFirstDayOfWeek() {
		return firstDayOfWeek;
	}

	public void setFirstDayOfWeek(int firstDayOfWeek) {
		this.firstDayOfWeek = firstDayOfWeek;
	}
}
