/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.model;

import java.util.Calendar;
import java.util.Date;

import com.floreantpos.Messages;

public enum ServicePaymentType {
	//@formatter:off
	ANUALLY(Messages.getString("ServicePaymentType.Annually")),  //$NON-NLS-1$
	HALF_YEARLY(Messages.getString("ServicePaymentType.HalfYearly")), //$NON-NLS-1$
	QUARTERLY(Messages.getString("ServicePaymentType.Quarterly")), //$NON-NLS-1$
	MONTHLY(Messages.getString("ServicePaymentType.Monthly")),  //$NON-NLS-1$
	ONE_TIME(Messages.getString("ServicePaymentType.OneTime")),  //$NON-NLS-1$
	DAILY(Messages.getString("ServicePaymentType.Daily")), //$NON-NLS-1$
	WEEKLY(Messages.getString("ServicePaymentType.Weekly"))  //$NON-NLS-1$
	;
	//@formatter:on

	private String displayString;

	private ServicePaymentType(String display) {
		this.displayString = display;
	}

	@Override
	public String toString() {
		return displayString;
	}

	public String getDisplayString() {
		return displayString;
	}

	public void setDisplayString(String displayString) {
		this.displayString = displayString;
	}

	public Date calculateEndDate(Date serviceStartTime) {
		Calendar calendar = Calendar.getInstance();
		calendar.setTime(serviceStartTime);
		switch (this) {
			case ANUALLY:
				calendar.add(Calendar.YEAR, 1);
				break;
			case HALF_YEARLY:
				calendar.add(Calendar.MONTH, 6);
				break;
			case QUARTERLY:
				calendar.add(Calendar.MONTH, 3);
				break;
			case MONTHLY:
				calendar.add(Calendar.MONTH, 1);
				break;
			case WEEKLY:
				calendar.add(Calendar.DAY_OF_MONTH, 7);
				break;
			case DAILY:
			case ONE_TIME:
				calendar.add(Calendar.DAY_OF_MONTH, 1);
				break;
			default:
				break;
		}
		calendar.add(Calendar.SECOND, -1);
		return calendar.getTime();
	}

}
