package com.floreantpos.extension.cardconnect;

public enum SecuredResponseStatus {
	APPROVED(SecuredConstants.PROP_IPP320_RESPSTAT_APPROVED), RETRY(SecuredConstants.PROP_IPP320_RESPSTAT_RETRY), DECLINED(
			SecuredConstants.PROP_IPP320_RESPSTAT_DECLINED);

	private String status;

	private SecuredResponseStatus(String status) {
		this.status = status;
	}

	public static SecuredResponseStatus fromStatus(String status) {
		SecuredResponseStatus[] values = values();
		for (SecuredResponseStatus value : values) {
			if (value.status.equals(status)) {
				return value;
			}
		}
		return SecuredResponseStatus.RETRY;
	}

	public String getStatus() {
		return status;
	}

	@Override
	public String toString() {
		return this.status;
	}
}
