/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.db.update;

import java.sql.DriverManager;
import java.sql.SQLException;

import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;

import com.floreantpos.PosLog;
import com.floreantpos.model.Customer;

import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.resource.ClassLoaderResourceAccessor;

public class UpdateDBTo288 {

	private SessionFactory sessionFactory;
	private String dbConnectString;
	private String user;
	private String password;
	private String schemaName;

	public UpdateDBTo288(SessionFactory sessionFactory, String dbConnectString, String user, String password, String schemaName) {
		this.sessionFactory = sessionFactory;
		this.dbConnectString = dbConnectString;
		this.user = user;
		this.password = password;
		this.schemaName = schemaName;
	}

	public void update() throws Exception {
		copyDataFromOldColumnToNewColumn();
	}
	
	private void copyDataFromOldColumnToNewColumn() {
		try (Session session = sessionFactory.openSession()) {
			Transaction transaction = session.beginTransaction();
			String[] queries = {
					"update %s.store s set zipcode = (select zip_code from %s.store s2 where s.id=s2.id)",
					"update %s.outlet o set address_line1 = (select address_line_1 from %s.outlet o2 where o.id=o2.id )",
					"update %s.outlet o set address_line2 = (select address_line_2 from %s.outlet o2 where o.id=o2.id )",
					"update %s.outlet o set address_line3 = (select address_line_3 from %s.outlet o2 where o.id=o2.id )"
			};
			for (String string : queries) {
				PosLog.info(getClass(), string);
				SQLQuery query = session.createSQLQuery(String.format(string, schemaName, schemaName));
				int update = query.executeUpdate();
				PosLog.info(getClass(), "updated " + update + " row");
			}
			transaction.commit();
		}
	}
}