package com.floreantpos.model;

import java.util.List;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BasePriceTable;
import com.floreantpos.model.dao.CustomerGroupDAO;
import com.floreantpos.model.dao.DepartmentDAO;
import com.floreantpos.model.dao.OutletDAO;
import com.floreantpos.model.dao.PriceShiftDAO;
import com.floreantpos.model.dao.SalesAreaDAO;
import com.floreantpos.model.util.DataProvider;

@JsonIgnoreProperties(ignoreUnknown = true, value = { "department", "outlet", "salesArea", "orderType", "customerGroup", "priceShift", "lastUpdatedBy" })
@XmlRootElement
public class PriceTable extends BasePriceTable implements TimedModel {
	private static final long serialVersionUID = 1L;
	private List<PriceTableItem> priceTableItems;
	private Department department;
	private Outlet outlet;
	private SalesArea salesArea;
	private OrderType orderType;
	private CustomerGroup customerGroup;
	private PriceShift priceShift;
	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public PriceTable() {
	}

	/**
	 * Constructor for primary key
	 */
	public PriceTable(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/
	@Override
	public String toString() {
		return super.getName();
	}

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	public void setPriceTableItems(List<PriceTableItem> items) {
		this.priceTableItems = items;
	}

	public List<PriceTableItem> getPriceTableItems() {
		return priceTableItems;
	}

	@XmlTransient
	@JsonIgnore
	public Department getDepartment() {
		String departmentId = getDepartmentId();
		if (StringUtils.isEmpty(departmentId))
			return null;
		if (department == null || !department.getId().equals(departmentId)) {
			department = DepartmentDAO.getInstance().get(departmentId);
		}
		return department;
	}

	public void setDepartment(Department department) {
		this.department = department;
		String departmentId = null;
		if (department != null) {
			departmentId = department.getId();
		}
		super.setDepartmentId(departmentId);
	}

	@XmlTransient
	@JsonIgnore
	public Outlet getOutlet() {
		String outletId = getOutletId();
		if (StringUtils.isEmpty(outletId))
			return null;
		if (outlet == null || !outlet.getId().equals(outletId)) {
			outlet = OutletDAO.getInstance().get(outletId);
		}
		return outlet;
	}

	public void setOutlet(Outlet outlet) {
		this.outlet = outlet;
		String outletId = null;
		if (outlet != null) {
			outletId = outlet.getId();
		}
		super.setOutletId(outletId);
	}

	@XmlTransient
	@JsonIgnore
	public SalesArea getSalesArea() {
		String salesAreaId = getSalesAreaId();
		if (StringUtils.isEmpty(salesAreaId))
			return null;
		if (salesArea == null || !salesArea.getId().equals(salesAreaId)) {
			salesArea = SalesAreaDAO.getInstance().get(salesAreaId);
		}
		return salesArea;
	}

	public void setSalesArea(SalesArea salesArea) {
		this.salesArea = salesArea;
		String salesAreaId = null;
		if (salesArea != null) {
			salesAreaId = salesArea.getId();
		}
		super.setSalesAreaId(salesAreaId);
	}

	@XmlTransient
	@JsonIgnore
	public CustomerGroup getCustomerGroup() {
		String customerGroupId = getCustomerGroupId();
		if (StringUtils.isEmpty(customerGroupId))
			return null;
		if (customerGroup == null || !customerGroup.getId().equals(customerGroupId)) {
			customerGroup = CustomerGroupDAO.getInstance().get(customerGroupId);
		}
		return customerGroup;
	}

	public void setCustomerGroup(CustomerGroup customerGroup) {
		this.customerGroup = customerGroup;
		String customerGroupId = null;
		if (customerGroup != null) {
			customerGroupId = customerGroup.getId();
		}
		super.setCustomerGroupId(customerGroupId);
	}

	@XmlTransient
	@JsonIgnore
	public PriceShift getPriceShift() {
		String priceShiftId = getPriceShiftId();
		String outletId = getOutletId();
		if (StringUtils.isEmpty(priceShiftId) || StringUtils.isEmpty(outletId))
			return null;
		if (priceShift == null || !priceShift.getId().equals(priceShiftId)) {
			priceShift = PriceShiftDAO.getInstance().get(priceShiftId, outletId);
		}
		return priceShift;
	}

	public void setPriceShift(PriceShift priceShift) {
		this.priceShift = priceShift;
		String priceShiftId = null;
		if (priceShift != null) {
			priceShiftId = priceShift.getId();
		}
		super.setPriceShiftId(priceShiftId);
	}

	@XmlTransient
	@JsonIgnore
	public OrderType getOrderType() {
		String orderTypeId = getOrderTypeId();
		String outletId = getOutletId();
		if (StringUtils.isEmpty(orderTypeId) || StringUtils.isEmpty(outletId))
			return null;
		if (orderType == null || !orderType.getId().equals(orderTypeId)) {
			orderType = DataProvider.get().getOrderType(orderTypeId, outletId);
		}
		return orderType;
	}

	public void setOrderType(OrderType orderType) {
		this.orderType = orderType;
		String orderTypeId = null;
		if (orderType != null) {
			orderTypeId = orderType.getId();
		}
		super.setOrderTypeId(orderTypeId);
	}
}