package com.floreantpos.model;

public enum SubOrderType {
	FOR_HERE("FOR_HERE", com.floreantpos.Messages.getString("For_Here")),//NON-NLS-1$ //NON-NLS-2$
	TO_GO("TO_GO", com.floreantpos.Messages.getString("To_Go")),//NON-NLS-1$ //NON-NLS-2$
	;
	
	private String name;
	private String displayString;
	
	private SubOrderType(String name, String displayString) {
		this.name = name;
		this.displayString = displayString;
	}

	public String getName() {
		return name;
	}

	public String getDisplayString() {
		return displayString;
	}
	
	public static SubOrderType fromName(String name) {
		SubOrderType[] values = values();
		for (SubOrderType subOrderType : values) {
			if (subOrderType.getName().equals(name)) {
				return subOrderType;
			}
		}
		return null;
	}
}
