package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the PRICE_TABLE table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="PRICE_TABLE"
 */

public abstract class BasePriceTable  implements Comparable, Serializable {

	public static String REF = "PriceTable"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATED_BY = "lastUpdatedBy"; //$NON-NLS-1$
	public static String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$
	public static String PROP_DESCRIPTION = "description"; //$NON-NLS-1$
	public static String PROP_SALES_AREA_ID = "salesAreaId"; //$NON-NLS-1$
	public static String PROP_PRICE_SHIFT_ID = "priceShiftId"; //$NON-NLS-1$
	public static String PROP_NAME = "name"; //$NON-NLS-1$
	public static String PROP_ACTIVE = "active"; //$NON-NLS-1$
	public static String PROP_CUSTOMER_GROUP_ID = "customerGroupId"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_ORDER_TYPE_ID = "orderTypeId"; //$NON-NLS-1$
	public static String PROP_CUSTOMER_IS_MEMBER = "customerIsMember"; //$NON-NLS-1$
	public static String PROP_DEPARTMENT_ID = "departmentId"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$


	// constructors
	public BasePriceTable () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BasePriceTable (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	 long version;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.String name;
				private java.lang.String description;
				private java.lang.String lastUpdatedBy;
				private java.lang.String outletId;
				private java.lang.String departmentId;
				private java.lang.String salesAreaId;
				private java.lang.String orderTypeId;
				private java.lang.String customerGroupId;
				private java.lang.String priceShiftId;
				private java.lang.Boolean active;
				private java.lang.Boolean customerIsMember;
				private java.lang.Boolean deleted;
	


	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.GlobalIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */

	public long getVersion () {
			return version;
	}



	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: NAME
	 */

	public java.lang.String getName () {
			return name;
	}



	/**
	 * Set the value related to the column: NAME
	 * @param name the NAME value
	 */
			public void setName (java.lang.String name) {
			this.name = name;
	}



	/**
	 * Return the value associated with the column: DESCRIPTION
	 */

	public java.lang.String getDescription () {
			return description;
	}



	/**
	 * Set the value related to the column: DESCRIPTION
	 * @param description the DESCRIPTION value
	 */
			public void setDescription (java.lang.String description) {
			this.description = description;
	}



	/**
	 * Return the value associated with the column: LAST_UPDATED_BY
	 */

	public java.lang.String getLastUpdatedBy () {
			return lastUpdatedBy;
	}



	/**
	 * Set the value related to the column: LAST_UPDATED_BY
	 * @param lastUpdatedBy the LAST_UPDATED_BY value
	 */
			public void setLastUpdatedBy (java.lang.String lastUpdatedBy) {
			this.lastUpdatedBy = lastUpdatedBy;
	}



	/**
	 * Return the value associated with the column: OUTLET_ID
	 */

	public java.lang.String getOutletId () {
			return outletId;
	}



	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
			public void setOutletId (java.lang.String outletId) {
			this.outletId = outletId;
	}



	/**
	 * Return the value associated with the column: DEPARTMENT_ID
	 */

	public java.lang.String getDepartmentId () {
			return departmentId;
	}



	/**
	 * Set the value related to the column: DEPARTMENT_ID
	 * @param departmentId the DEPARTMENT_ID value
	 */
			public void setDepartmentId (java.lang.String departmentId) {
			this.departmentId = departmentId;
	}



	/**
	 * Return the value associated with the column: SALES_AREA_ID
	 */

	public java.lang.String getSalesAreaId () {
			return salesAreaId;
	}



	/**
	 * Set the value related to the column: SALES_AREA_ID
	 * @param salesAreaId the SALES_AREA_ID value
	 */
			public void setSalesAreaId (java.lang.String salesAreaId) {
			this.salesAreaId = salesAreaId;
	}



	/**
	 * Return the value associated with the column: ORDER_TYPE_ID
	 */

	public java.lang.String getOrderTypeId () {
			return orderTypeId;
	}



	/**
	 * Set the value related to the column: ORDER_TYPE_ID
	 * @param orderTypeId the ORDER_TYPE_ID value
	 */
			public void setOrderTypeId (java.lang.String orderTypeId) {
			this.orderTypeId = orderTypeId;
	}



	/**
	 * Return the value associated with the column: CUSTOMER_GROUP_ID
	 */

	public java.lang.String getCustomerGroupId () {
			return customerGroupId;
	}



	/**
	 * Set the value related to the column: CUSTOMER_GROUP_ID
	 * @param customerGroupId the CUSTOMER_GROUP_ID value
	 */
			public void setCustomerGroupId (java.lang.String customerGroupId) {
			this.customerGroupId = customerGroupId;
	}



	/**
	 * Return the value associated with the column: PRICE_SHIFT_ID
	 */

	public java.lang.String getPriceShiftId () {
			return priceShiftId;
	}



	/**
	 * Set the value related to the column: PRICE_SHIFT_ID
	 * @param priceShiftId the PRICE_SHIFT_ID value
	 */
			public void setPriceShiftId (java.lang.String priceShiftId) {
			this.priceShiftId = priceShiftId;
	}



	/**
	 * Return the value associated with the column: ACTIVE
	 */

	public java.lang.Boolean isActive () {
					return active == null ? Boolean.FALSE : active;
		}

	public java.lang.Boolean getActive () {
				return active == null ? Boolean.FALSE : active;
			}


	/**
	 * Set the value related to the column: ACTIVE
	 * @param active the ACTIVE value
	 */
			public void setActive (java.lang.Boolean active) {
			this.active = active;
	}



	/**
	 * Return the value associated with the column: CUSTOMER_IS_MEMBER
	 */

	public java.lang.Boolean isCustomerIsMember () {
					return customerIsMember == null ? Boolean.FALSE : customerIsMember;
		}

	public java.lang.Boolean getCustomerIsMember () {
				return customerIsMember == null ? Boolean.FALSE : customerIsMember;
			}


	/**
	 * Set the value related to the column: CUSTOMER_IS_MEMBER
	 * @param customerIsMember the CUSTOMER_IS_MEMBER value
	 */
			public void setCustomerIsMember (java.lang.Boolean customerIsMember) {
			this.customerIsMember = customerIsMember;
	}



	/**
	 * Return the value associated with the column: DELETED
	 */

	public java.lang.Boolean isDeleted () {
						return deleted == null ? Boolean.valueOf(false) : deleted;
			}

	public java.lang.Boolean getDeleted () {
					return deleted == null ? Boolean.valueOf(false) : deleted;
			}


	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
			public void setDeleted (java.lang.Boolean deleted) {
			this.deleted = deleted;
	}


	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue () {
		return "false";
	}




	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.PriceTable)) return false;
		else {
			com.floreantpos.model.PriceTable priceTable = (com.floreantpos.model.PriceTable) obj;
			if (null == this.getId() || null == priceTable.getId()) return this == obj;
			else return (this.getId().equals(priceTable.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}