package com.floreantpos;

import org.apache.commons.logging.LogFactory;

public class PosLog {

	public static void error(Class<?> eClass, String message) {
		LogFactory.getLog(eClass).error(message);
	}
	
	public static void error(Class<?> eClass, Exception e) {
		String message = e.getMessage();
		LogFactory.getLog(eClass).error(message, e);
	}
	
	public static void error(Class<?> eClass, String message, Exception e) {
		LogFactory.getLog(eClass).error(message, e);
	}

	public static void debug(Class<?> eClass, String message) {
		LogFactory.getLog(eClass).debug(message);
	}

	public static void info(Class<?> eClass, String message) {
		LogFactory.getLog(eClass).info(message);
	}
}
