package com.floreantpos.model;

import java.awt.Color;
import java.util.UUID;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BaseMenuPageItem;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.util.DataProvider;

@XmlAccessorType(XmlAccessType.FIELD)
@JsonIgnoreProperties(ignoreUnknown = true, value = { "menuItem", "image", "buttonColor", "textColor" })
@XmlRootElement
public class MenuPageItem extends BaseMenuPageItem {
	private static final long serialVersionUID = 1L;

	private transient MenuItem menuItem;
	private final String randomId = UUID.randomUUID().toString();

	public MenuPageItem() {
		super();
	}

	public MenuPageItem(java.lang.String id) {
		super(id);
	}

	public MenuPageItem(java.lang.Integer col, java.lang.Integer row) {
		super();
		super.setCol(col);
		super.setRow(row);
	}

	public MenuPageItem(java.lang.Integer col, java.lang.Integer row, MenuItem menuItem, MenuPage menuPage) {
		super();
		super.setCol(col);
		super.setRow(row);

		setMenuItem(menuItem);
		setMenuPage(menuPage);
	}

	public void setMenuPage(MenuPage menuPage) {
		if (menuPage != null) {
			setMenuPageId(menuPage.getId());
		}
		else {
			setMenuPageId(null);
		}
	}

	@XmlTransient
	public MenuItem getMenuItem() {
		if (menuItem == null && getMenuItemId() != null) {
			menuItem = MenuItemDAO.getInstance().get(getMenuItemId());
		}
		return menuItem;
	}

	public void setMenuItem(MenuItem menuItem) {
		this.menuItem = menuItem;
		if (menuItem != null) {
			setMenuItemId(menuItem.getId());
			setMenuItemName(menuItem.getDisplayName());
			setTranslatedName(menuItem.getTranslatedName());
			setButtonColorCode(menuItem.getButtonColorCode());
			setTextColorCode(menuItem.getTextColorCode());
			setImageId(menuItem.getImageId());
			setShowImageOnly(menuItem.isShowImageOnly());
			setVariant(menuItem.isVariant());
			setHasVariant(menuItem.isHasVariant());
			setVisible(menuItem.isVisible());
		}
		else {
			setMenuItemId(null);
			setMenuItemName(null);
			setTranslatedName(null);
			setButtonColorCode(null);
			setTextColorCode(null);
			setImageId(null);
			setShowImageOnly(null);
			setVariant(null);
			setHasVariant(null);
			setVisible(null);
		}
	}

	@Override
	public Integer getButtonColorCode() {
		Integer buttonColorCode = super.getButtonColorCode();
		if (buttonColorCode == null || buttonColorCode == 0 || buttonColorCode == -1316371) {
			buttonColorCode = Color.WHITE.getRGB();
		}
		return buttonColorCode;
	}

	@XmlTransient
	public Color getButtonColor() {
		Integer buttonColorCode = getButtonColorCode();
		if (buttonColorCode == null) {
			return null;
		}

		return new Color(getButtonColorCode());
	}

	public void setButtonColor(Color buttonColor) {
		if (buttonColor != null) {
			setButtonColorCode(buttonColor.getRGB());
		}
	}

	@XmlTransient
	public Color getTextColor() {
		if (getTextColorCode() == null) {
			return null;
		}
		return new Color(getTextColorCode());
	}

	public void setTextColor(Color textColor) {
		if (textColor != null) {
			setTextColorCode(textColor.getRGB());
		}
	}

	public String getRandomId() {
		return randomId;
	}

	@XmlTransient
	public String getDisplayName() {
		Terminal terminal = DataProvider.get().getCurrentTerminal();
		if (((terminal != null && terminal.isShowTranslatedName()) || isVariant()) && StringUtils.isNotEmpty(super.getTranslatedName())) {
			return super.getTranslatedName();
		}
		String name = super.getMenuItemName();
		return name;
	}

	public boolean isRowColumnEquals(MenuPageItem other) {
		return this.getRow().equals(other.getRow()) && this.getCol().equals(other.getCol());
	}
}