package com.floreantpos.model;

import java.awt.Color;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BaseMultiplier;

@JsonIgnoreProperties(ignoreUnknown = true, value = { "buttonBackgroundColor", "buttonTextColor" })
@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement
public class Multiplier extends BaseMultiplier implements TimedModel {
	private static final long serialVersionUID = 1L;
	public static final String REGULAR = "Regular"; //$NON-NLS-1$
	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;

	public Multiplier() {
		setGlobalId(com.floreantpos.util.GlobalIdGenerator.generateGlobalId());
	}

	public Multiplier(java.lang.String name) {
		super(name);
		setGlobalId(com.floreantpos.util.GlobalIdGenerator.generateGlobalId());
	}

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	@XmlTransient
	@Override
	public Integer getButtonColor() {
		Integer buttonColorCode = super.getButtonColor();
		if (buttonColorCode == null || buttonColorCode == 0 || buttonColorCode == -1316371) {
			buttonColorCode = Color.WHITE.getRGB();
		}
		return buttonColorCode;
	}

	@Override
	public Integer getTextColor() {
		Integer textColor = super.getTextColor();
		return textColor == 0 ? null : textColor;
	}

	@XmlTransient
	public Color getButtonBackgroundColor() {
		Integer buttonColorCode = getButtonColor();
		if (buttonColorCode == null) {
			return null;
		}

		return new Color(getButtonColor());
	}

	public void setButtonBackgroundColor(Color buttonColor) {
		if (buttonColor != null) {
			setButtonColor(buttonColor.getRGB());
		}
	}

	@XmlTransient
	public Color getButtonTextColor() {
		if (getTextColor() == null) {
			return null;
		}
		return new Color(getTextColor());
	}

	public void setButtonTextColor(Color textColor) {
		if (textColor != null) {
			setTextColor(textColor.getRGB());
		}
	}

	@Override
	public String toString() {
		return super.getId();
	}

}