package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the MENU_ITEM_INVENTORY_STATUS table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="MENU_ITEM_INVENTORY_STATUS"
 */

public abstract class BaseMenuItemInventoryStatus  implements Comparable, Serializable {

	public static String REF = "MenuItemInventoryStatus"; //$NON-NLS-1$
	public static String PROP_STOCK_AMOUNT = "stockAmount"; //$NON-NLS-1$
	public static String PROP_UNIT_ON_HAND = "unitOnHand"; //$NON-NLS-1$
	public static String PROP_AVAILABLE_UNIT = "availableUnit"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$


	// constructors
	public BaseMenuItemInventoryStatus () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseMenuItemInventoryStatus (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	private long version;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.Double availableUnit;
				private java.lang.Double stockAmount;
				private java.lang.Double unitOnHand;
	


	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="assigned"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */
				public long getVersion () {
						return version;
			}

	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */
				public java.util.Date getLastUpdateTime () {
						return lastUpdateTime;
			}

	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */
				public java.util.Date getLastSyncTime () {
						return lastSyncTime;
			}

	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: AVAILABLE_UNIT
	 */
				public java.lang.Double getAvailableUnit () {
										return availableUnit == null ? Double.valueOf(0) : availableUnit;
					}

	/**
	 * Set the value related to the column: AVAILABLE_UNIT
	 * @param availableUnit the AVAILABLE_UNIT value
	 */
			public void setAvailableUnit (java.lang.Double availableUnit) {
			this.availableUnit = availableUnit;
	}



	/**
	 * Return the value associated with the column: STOCK_AMOUNT
	 */
				public java.lang.Double getStockAmount () {
										return stockAmount == null ? Double.valueOf(0) : stockAmount;
					}

	/**
	 * Set the value related to the column: STOCK_AMOUNT
	 * @param stockAmount the STOCK_AMOUNT value
	 */
			public void setStockAmount (java.lang.Double stockAmount) {
			this.stockAmount = stockAmount;
	}



	/**
	 * Return the value associated with the column: UNIT_ON_HAND
	 */
				public java.lang.Double getUnitOnHand () {
										return unitOnHand == null ? Double.valueOf(0) : unitOnHand;
					}

	/**
	 * Set the value related to the column: UNIT_ON_HAND
	 * @param unitOnHand the UNIT_ON_HAND value
	 */
			public void setUnitOnHand (java.lang.Double unitOnHand) {
			this.unitOnHand = unitOnHand;
	}





	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.MenuItemInventoryStatus)) return false;
		else {
			com.floreantpos.model.MenuItemInventoryStatus menuItemInventoryStatus = (com.floreantpos.model.MenuItemInventoryStatus) obj;
			if (null == this.getId() || null == menuItemInventoryStatus.getId()) return this == obj;
			else return (this.getId().equals(menuItemInventoryStatus.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}