package com.floreantpos.model;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BaseModifierMultiplierPrice;
import com.floreantpos.model.util.DataProvider;

@JsonIgnoreProperties(ignoreUnknown = true, value = { "multiplier" })
@XmlRootElement
public class ModifierMultiplierPrice extends BaseModifierMultiplierPrice implements TimedModel {
	private static final long serialVersionUID = 1L;
	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public ModifierMultiplierPrice() {
	}

	/**
	 * Constructor for primary key
	 */
	public ModifierMultiplierPrice(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	/**
	 * Return the value associated with the column: MULTIPLIER_ID
	 */
	@XmlTransient
	public com.floreantpos.model.Multiplier getMultiplier() {
		return DataProvider.get().getMultiplierById(getMultiplierId());
	}

	/**
	 * Set the value related to the column: MULTIPLIER_ID
	 * @param multiplier the MULTIPLIER_ID value
	 */
	public void setMultiplier(com.floreantpos.model.Multiplier multiplier) {
		setMultiplierId(multiplier == null ? null : multiplier.getId());
	}

	@Override
	public Double getPrice() {
		Double price = super.getPrice();
		return price == 0.0 ? null : price;
	}

}