/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.report;

import java.util.List;

import javax.swing.table.AbstractTableModel;

import com.floreantpos.Messages;
import com.floreantpos.model.CashDropTransaction;
import com.floreantpos.model.Customer;
import com.floreantpos.model.PayOutTransaction;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.util.DateUtil;

public class CashDrawerTransactionReportModel extends AbstractTableModel {

	//	private final static SimpleDateFormat dateFormat = new SimpleDateFormat("dd MMM yy, hh:mm a"); //$NON-NLS-1$
	//	private String[] columnNames = { "transTime", "transNo", "token", "totalAmount" }; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
	private String[] columnNames = { "transTime", "ticketId", "member", "totalAmount", "transType" }; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$

	private List<PosTransaction> items;

	public CashDrawerTransactionReportModel() {
		super();
	}

	public int getRowCount() {
		if (items == null)
			return 0;

		return items.size();
	}

	public int getColumnCount() {
		return columnNames.length;
	}

	@Override
	public String getColumnName(int column) {
		return columnNames[column];
	}

	public Object getValueAt(int rowIndex, int columnIndex) {
		PosTransaction transaction = items.get(rowIndex);
		Ticket ticket = transaction.getTicket();
		switch (columnIndex) {
			case 0:
				return DateUtil.formatDateWithBrowserTimeOffset(transaction.getTransactionTime());

			case 1:
				if (ticket != null) {
					return ticket.getId();
				}
				return null;

			case 2:
				String customerId = transaction.getCustomerId();
				if (customerId == null) {
					return Messages.getString("GUEST"); //$NON-NLS-1$
				}
				Customer customer = CustomerDAO.getInstance().findById(customerId);
				return customer == null ? Messages.getString("GUEST") : customer.getName(); //$NON-NLS-1$

			case 3:
				if (transaction instanceof RefundTransaction || transaction instanceof CashDropTransaction || transaction instanceof PayOutTransaction) {
					return transaction.getAmount() * (-1);
				}
				else {
					return transaction.getAmount();
				}

			case 4:
				return transaction.getPaymentTypeString().replaceAll("_", " "); //$NON-NLS-1$ //$NON-NLS-2$

		}
		return null;
	}

	public List<PosTransaction> getItems() {
		return items;
	}

	public void setItems(List<PosTransaction> items) {
		this.items = items;
	}
}
