/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.report;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.model.User;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.ListTableModel;

public class PayrollReportModel extends ListTableModel {

	private String userId = ""; //$NON-NLS-1$
	private long totalWorkHourByUser = 0;
	private long totalRegularWorkHourByUser = 0;
	private long totalOvertimeWorkHourByUser = 0;
	private Integer rowIndex = null;

	public PayrollReportModel() {
		super(new String[] { "userId", "userName", "role", "clockIn", "clockOut", "regularWorkHourDisplay", "overtimeWorkHourDisplay", "regularPayment", //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$//$NON-NLS-5$//$NON-NLS-6$//$NON-NLS-7$//$NON-NLS-8$
				"overtimePayment", "totalWorkHourMs", "costPerHourRate", "overtimeRatePerHour", "totalWorkHourDisplay", "totalPayment", //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$//$NON-NLS-4$//$NON-NLS-5$//$NON-NLS-6$
				"totalRegularWorkHourByUserDisplay", "totalOvertimeWorkHourByUserDisplay", "totalWorkHourByUserDisplay" }); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
	}

	public Object getValueAt(int rowIndex, int columnIndex) {
		PayrollReportData data = (PayrollReportData) rows.get(rowIndex);

		User user = data.getUser();
		User parentUser = user.getParentUser();

		String currentUserId = ""; //$NON-NLS-1$
		if (parentUser != null) {
			currentUserId = parentUser.getId();
		}
		else {
			currentUserId = user.getId();
		}

		calculateDisplayString(rowIndex, data, currentUserId);

		switch (columnIndex) {

			case 0:
				return currentUserId;

			case 1:
				if (parentUser != null) {
					return String.valueOf(parentUser.getFullName());
				}
				return String.valueOf(user.getFullName());

			case 2:
				return user.getType().getName();

			case 3:
				return DateUtil.format24HoursDate(data.getClockIn());

			case 4:
				return DateUtil.format24HoursDate(data.getClockOut());

			case 5:
				return data.getRegularHourDisplay();

			case 6:
				return data.getOvertimeWorkHourDisplay();

			case 7:
				return data.getRegularPayment();

			case 8:
				return data.getOvertimePayment();

			case 9:
				return data.getTotalWorkHourMs();

			case 10:
				return data.getCostPerHour();

			case 11:
				return data.getOvertimeRatePerHour();

			case 12:
				return data.getTotalWorkHourDisplay();

			case 13:
				return data.getTotalPayment();

			case 14:
				return PayrollReportData.getHour(totalRegularWorkHourByUser) + "h " + PayrollReportData.getMin(totalRegularWorkHourByUser) + "m"; //$NON-NLS-1$ //$NON-NLS-2$

			case 15:
				return PayrollReportData.getHour(totalOvertimeWorkHourByUser) + "h " + PayrollReportData.getMin(totalOvertimeWorkHourByUser) + "m"; //$NON-NLS-1$ //$NON-NLS-2$

			case 16:
				return PayrollReportData.getHour(totalWorkHourByUser) + "h " + PayrollReportData.getMin(totalWorkHourByUser) + "m"; //$NON-NLS-1$ //$NON-NLS-2$

		}
		return null;
	}

	private void calculateDisplayString(int rowIndex, PayrollReportData data, String currentUserId) {
		if (this.rowIndex != null && this.rowIndex == rowIndex) {
			return;
		}
		this.rowIndex = rowIndex;

		if (StringUtils.isBlank(userId)) {
			totalRegularWorkHourByUser = data.getRegularWorkHourMs();
			totalOvertimeWorkHourByUser = data.getOvertimeWorkHourMs();
			totalWorkHourByUser = data.getTotalWorkHourMs();

			userId = currentUserId;
		}
		else {
			if (userId.equals(currentUserId)) {
				totalRegularWorkHourByUser += data.getRegularWorkHourMs();
				totalOvertimeWorkHourByUser += data.getOvertimeWorkHourMs();
				totalWorkHourByUser += data.getTotalWorkHourMs();
			}
			else {
				totalRegularWorkHourByUser = data.getRegularWorkHourMs();
				totalOvertimeWorkHourByUser = data.getOvertimeWorkHourMs();
				totalWorkHourByUser = data.getTotalWorkHourMs();

				userId = currentUserId;
			}
		}
	}

}
