/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.model;

public enum InventoryTransactionType {
	IN(1, "IN"), OUT(-1, "OUT"), UNCHANGED(0, "UNCHANGED"), CONVERSION(2, "CONV."); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$

	private int type;
	private String name;

	private InventoryTransactionType(int type) {
		this.type = type;
	}

	private InventoryTransactionType(int type, String name) {
		this.type = type;
		this.name = name;
	}

	public int getType() {
		return type;
	}
	
	public String getName() {
		return name;
	}

	public static InventoryTransactionType fromInt(int type) {
		InventoryTransactionType[] values = values();

		for (InventoryTransactionType inOutEnum : values) {
			if (inOutEnum.type == type) {
				return inOutEnum;
			}
		}

		return UNCHANGED;
	}
	
	@Override
	public String toString() {
		return name;
	}
}
