package com.orocube.workspace.subscription;

import java.util.ArrayList;
import java.util.List;

public enum SubscriptionProduct {
	Menugreat("menugreat", "Menugreat", "per outlet"), //$NON-NLS-1$  //$NON-NLS-2$ //$NON-NLS-3$
	OroposLive("oropos_live", "Oropos Live", "per user"), //$NON-NLS-1$  //$NON-NLS-2$ //$NON-NLS-3$
	MultiOutlet("multi_outlet", "Multi Outlet", "per outlet"), //$NON-NLS-1$  //$NON-NLS-2$ //$NON-NLS-3$
	Siiopa("siiopa_v2", "Siiopa", "per terminal"); //$NON-NLS-1$  //$NON-NLS-2$ //$NON-NLS-3$

	private String id;
	private String label;
	private String subscriptionType;

	private SubscriptionProduct(String label) {
		this.label = label;
	}

	private SubscriptionProduct(String id, String label) {
		this.id = id;
		this.label = label;
	}

	private SubscriptionProduct(String id, String label, String subscriptionType) {
		this.id = id;
		this.label = label;
		this.subscriptionType = subscriptionType;
	}

	public String getId() {
		return id;
	}

	public String getLabel() {
		return label;
	}

	@Override
	public String toString() {
		return getLabel();
	}

	public static SubscriptionProduct getById(String id) {
		for (SubscriptionProduct product : values()) {
			if (product.getId().equals(id)) {
				return product;
			}
		}
		return null;
	}

	public List<SubscriptionPlan> getMonthlyPlans() {
		List<SubscriptionPlan> monthlyPlans = new ArrayList<>();
		for (SubscriptionPlan subscriptionPlan : SubscriptionPlan.values()) {
			if (subscriptionPlan.getProductId().equals(this.getId()) && subscriptionPlan.getInterval().equals("month")) {
				monthlyPlans.add(subscriptionPlan);
			}
		}
		return monthlyPlans;
	}

	public String getSubscriptionKey() {
		return "subscription." + getId(); //$NON-NLS-1$
	}

	public String getSubscriptionType() {
		return subscriptionType;
	}

	public void setSubscriptionType(String subscriptionType) {
		this.subscriptionType = subscriptionType;
	}

}
