package com.floreantpos.model;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BaseAttributeGroup;

@JsonIgnoreProperties(ignoreUnknown = true, value = { "attributes" })
@XmlRootElement
public class AttributeGroup extends BaseAttributeGroup implements TimedModel {
	private static final long serialVersionUID = 1L;

	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public AttributeGroup() {
	}

	/**
	 * Constructor for primary key
	 */
	public AttributeGroup(java.lang.String id) {
		super(id);
	}

	/**
	 * Constructor for required fields
	 */
	public AttributeGroup(java.lang.String id, java.lang.String name) {

		super(id, name);
	}

	/*[CONSTRUCTOR MARKER END]*/

	@Override
	public String toString() {
		return super.getName();
	}

	@XmlTransient
	@JsonIgnore
	public String getVariantsDisplay() {
		if (getNonDeletedAttributes() == null) {
			return "";
		}
		String attributes = getNonDeletedAttributes().toString();
		return attributes.substring(1, attributes.length() - 1);

	}

	public List<Attribute> getNonDeletedAttributes() {
		List<Attribute> attributes = new ArrayList<Attribute>();
		if (super.getAttributes() == null) {
			return attributes;
		}
		for (Attribute attribute : super.getAttributes()) {
			if (attribute.isDeleted()) {
				continue;
			}
			attributes.add(attribute);
		}
		return attributes;
	}
}