package com.floreantpos.model;

import javax.xml.bind.annotation.XmlRootElement;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BaseInventoryUnitGroup;

@XmlRootElement
@JsonIgnoreProperties(ignoreUnknown = true, value = { "units" })
public class InventoryUnitGroup extends BaseInventoryUnitGroup implements TimedModel {
	private static final long serialVersionUID = 1L;

	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public InventoryUnitGroup() {
	}

	/**
	 * Constructor for primary key
	 */
	public InventoryUnitGroup(java.lang.String id) {
		super(id);
	}

	/**
	 * Constructor for required fields
	 */
	public InventoryUnitGroup(java.lang.String id, java.lang.String name) {

		super(id, name);
	}

	/*[CONSTRUCTOR MARKER END]*/
	@Override
	public String toString() {
		return super.getName();
	}

	public String getUniqueId() {
		return ("unitgroup_" + getName() + "_" + getId()).replaceAll("\\s+", "_"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
	}
}